<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Change password
* @package TenderSystem
* @subpackage password
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'action'			=> array(),
	'offsite'			=> array()		
);
get_request($fields_request,$action,$error,$cfg);
// login submitted
if ($action['action']) {
	// field request errors and type 
	$fields_request = array (
		'password_md'		=> array(),
		'password_current'	=> array("",	REQUEST_PASSWORD,	FORMAT_PASSWORD,	"e1"),
		'password_new'		=> array("e3",	REQUEST_PASSWORD,	FORMAT_PASSWORD, 	"e6"),
		'password_confirm'	=> array("e4",	REQUEST_PASSWORD,	FORMAT_PASSWORD,	"e6")
	);
	// get data
	get_request($fields_request,$info,$error,$cfg);
	if ($info['password_new'] != $info['password_confirm']) {
		// New password and confirm password don't match
		$error[] = "e5";
	}
	if (!$info['password_md'] && !$info['password_current']) {
		// no current password
		$error[] = "e2";
	}
	if($error) {
		// generate and display the xml
		xml_generator('password','change',$error,"",$cfg);
	} else {
		  // set hash function
		 $hash_function = $cfg['password']['hash'];
		 // check if function exists
		 if(!function_exists($hash_function)) {
		 	// set to default
		 	$hash_function = "md5";
		 }
		 // check password scheme
		 if($cfg['password']['scheme'] == "2") {
		 	// hash(pre_salt + password + post_salt)
		 	$password_new = $hash_function($cfg['password']['salt']['pre'].$info['password_new'].$cfg['password']['salt']['post']);
		 	$password_current = $hash_function($cfg['password']['salt']['pre'].$info['password_current'].$cfg['password']['salt']['post']);
		 } elseif($cfg['password']['scheme'] == "3") {
		 	$hash_1 = $hash_function($cfg['password']['salt']['pre']);
		 	$hash_2 = $hash_function($info['password_new']);
		 	$hash_3 = $hash_function($cfg['password']['salt']['post']);
		 	$password_new = $hash_function($hash_1.$hash_2.$hash_3);
		 	$hash_1 = $hash_function($cfg['password']['salt']['pre']);
		 	$hash_2 = $hash_function($info['password_current']);
		 	$hash_3 = $hash_function($cfg['password']['salt']['post']);
		 	$password_current = $hash_function($hash_1.$hash_2.$hash_3);
		 } else {
		 	$password_new = $hash_function($info['password_new']);
		 	$password_current = $hash_function($info['password_current']);
		 }
		 if(!$info['password_current']) {
		 	$password_current = $info['password_md'];
		 }
		// paramaters to send to the application server
		$params = array(
			'module'			=> 'password',
			'function'			=> 'change',
			'session' 			=> $_SESSION['ts_id'],
		    'current_password'  => $password_current,
			'new_password'  	=> $password_new
		);
		// if offsite login
		if ($action['offsite']) {
			$params['offsite'] = "true";						
		}
		// send the message to app
		$data = send_message($params,$cfg);
	}
} else {
	// if offsite login
	if ($action['offsite']) {
		$paramater['offsite'] = "true";						
	}
	// generate and display the xml
	xml_generator('password','change',$error_code,$paramater,$cfg);
}
?>