<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Reset password
* @package TenderSystem
* @subpackage password
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'action'	=> array(),
	'username'	=> array("e7",	REQUEST_USERNAME,	FORMAT_USERNAME,	"e9"),
	'email'		=> array("e8",	REQUEST_EMAIL,		FORMAT_NONE,		"e10")
);
get_request($fields_request,$action,$error,$cfg);
// login submitted
if ($action['action'] || ($action['username'] && $action['email'])) {
	// set md5 if present handling
	if($error) {
		// paramaters to send to the application server
		$params = array(
			'username'	=> $action['username'],
			'email'		=> $action['email']
		);
		// send the message to gui
		xml_generator('password','reset',$error,$params,$cfg);
	} else {
		$params = array(
			'module'		=> 'password',
			'function'		=> 'reset',
			'server_ip'		=> $_SERVER['REMOTE_ADDR'],
			'username'		=> $action['username'],
			'email'			=> $action['email']
			
		);
		// send the message to app
		$data = send_message($params,$cfg);
	}
} else {
	// insert username if present
	if ($_SESSION['ts_username']) {
		// set the username from the session
		$params['username'] = $_SESSION['ts_username'];
	}
	// send the message to gui
	xml_generator('password','reset',"",$params,$cfg);
}
?>