<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/passwordchange"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'password'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="password"/>
					<input type="hidden" name="function" value="change"/>
				<xsl:if test="offsite">
					<input type="hidden" name="offsite" value="true"/>
				</xsl:if>
					<xsl:variable name="md" select="md"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:choose>
							<xsl:when test="md">
									<input type="hidden" name="password_md" value="{$md}"/>
							</xsl:when>
							<xsl:otherwise>
									<tr>
										<td align="right" width="110" class="t1"><xsl:value-of select="$lng/passwordcurrent"/></td>
										<td align="left" width="270"><input type="password" name="password_current" size="12" class="t2"/></td>
									</tr>
							</xsl:otherwise>
						</xsl:choose>
						<tr>
							<td align="right" width="110" class="t1"><xsl:value-of select="$lng/passwordnew"/></td>
							<td align="left" width="270"><input type="password" name="password_new" size="12" maxlenght="32" class="t2"/></td>
						</tr>
						<tr>
							<td align="right" width="110" class="t1"><xsl:value-of select="$lng/passwordconfirm"/></td>
							<td align="left" width="270"><input type="password" size="12" name="password_confirm" maxlenght="32" class="t2"/></td>
						</tr>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<tr>
							<td align="right" width="270" colspan="2">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/passwordchange"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/passwordchange"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/passwordinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script>
<xsl:choose>
	<xsl:when test="md">
		document.report.password_new.focus();
	</xsl:when>
	<xsl:otherwise>
		document.report.password_current.focus();
	</xsl:otherwise>
</xsl:choose>
	</script>
</body>
</html>

</xsl:template>
</xsl:stylesheet>
