<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/confirmreset"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/confirmreset"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'password'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="password"/>
					<input type="hidden" name="function" value="confirm"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="error">
							<xsl:variable name="err" select="document(concat('../../language/', $language, '/error.xml'))/e/error"/>
							<xsl:for-each select="error">
								<xsl:variable name="errorcode" select="."/>
								<tr>
									<td align="left" colspan="2" class="e">
										<xsl:value-of select="$err[@id=$errorcode]"/>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td colspan="2"><br/></td>
							</tr>
						</xsl:if>
						<xsl:if test="confirm='1'">
							<tr>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/confirmationgood"/>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/confirmreset"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/confirminst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
