<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/passwordreset"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/passwordreset"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'password'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="password"/>
					<input type="hidden" name="function" value="reset"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
				<xsl:choose>
					<xsl:when test="success='1' and user/usersid">
						<tr>
							<td colspan="2">
								<xsl:value-of select="$lng/passwordresetted"/>
							</td>
						</tr>
					</xsl:when>
					<xsl:when test="success='1'">
						<tr>
							<td colspan="2">
								<xsl:value-of select="$lng/emailconfirmationsent"/>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<br/>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<a href="./main.php?module=session&amp;function=login"><xsl:value-of select="$lng/clicklink"/></a>
							</td>
						</tr>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td align="left" class="t1"><xsl:value-of select="$lng/username"/></td>
							<td align="left">
								<input type="text" name="username" size="20" class="t2" value="{username}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1"><xsl:value-of select="$lng/emailaddress"/></td>
							<td align="left"><input type="text" name="email" size="20" maxlenght="32" class="t2" value="{email}"/></td>
						</tr>
						<tr>
							<td align="right" colspan="2">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/resetpassword"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:otherwise>
				</xsl:choose>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/passwordreset"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/resetinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
