<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Cancel purchase order
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// e2 - Missing purchase order ID
// e3 - Purchase order ID must be a number
// e4 - Missing Cancel Purchase Order Reason
$fields_request = array (
	'id'				=> array("e2", REQUEST_NUMBER,	FORMAT_NONE,	"e3"),
	'reason'			=> array(),
	'notify'			=> array(),
	'action'			=> array(),
	'cancellationfee'	=> array()
);
if(!get_request($fields_request,$action,$error,$cfg)) {
	// error
	xml_generator("procure","error",$error,"",$cfg);	
} elseif($action['action']) {
	// set paramaters
	$params = array(
		'module'			=> 'procure',
		'function'			=> 'cancel_purchase_order',
		'id'				=> $action['id'],
		'reason'			=> $action['reason'],
		'notify'			=> $action['notify'],
		'cancellationfee'	=> $action['cancellationfee']
	);
	// send the message to app
	$data = send_message($params,$cfg);
} else {
	$params['id'] = $action['id'];
	require_once($cfg['file'].'modules/settings/config.inc.php');
	xml_generator("procure","cancel_purchase_order","",$params,$cfg);
}
?>