<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Generic funstions
* @package TenderSystem
* @subpackage procure
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// Security - ensure that file never called directly
// not required if global variables are off or API is hosted on a non-public server
if (eregi(basename(__FILE__),$_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

/**
* determine which language packs are loaded on the server
* @return array
*/
function procure_add_first_product($module,$function,$action,$fields_request,$cfg,$error=array()) {
	// determine if add product selected
	if (is_array($action['action'])) {
		// get the selected key value
		$action = key($action['action']);
	} else {
		$action = $action['action'];
	}
	if(get_request($fields_request,$_SESSION['procure'],$error,$cfg)) {
		// set paramaters
		$params = array(
			'module'	=> $module,
			'function'	=> 'product',
			'product' 	=> $action
		);
	} else {
		// paramaters to send to the application server
		$params = array(
			'module'	=> $module,
			'function'	=> $function,
			'error'		=> $error
		);
	}
	// insert tender information
	$params['procure'] = $_SESSION['procure'];
	// send the message to app
	send_message($params,$cfg);
}


/**
* determine which language packs are loaded on the server
* @return array
*/
function procure_request($module,$function,$cfg,$error=array()) {
	// field request errors and type 
	// 1003 - RFQ Number is missing
	// 1004 - RFQ Reference is missing
	// 1005 - Area ID is missing
	// 1006 - Area ID must be a number
	$fields_request = array (
		'rfq_number'		=> array("1003",	REQUEST_ANY),
		'rfq_reference'		=> array("1004",	REQUEST_LUHN,	FORMAT_NONE,	"1014"),
		'area'				=> array("1005",	REQUEST_NUMBER,	FORMAT_NONE,	"1006"),
		'attachmentname'	=> array()
	);
	// get fields
	if(get_request($fields_request,$_SESSION['procure'],$error,$cfg))
	{
		$params['function'] = 'post_'.$function;
	} else {
		$params['function'] = $function;
		$params['error'] = $error;
	}
	$params['module'] = $module;
	// insert tender information
	$params['procure'] = $_SESSION['procure'];
	$attachment = $_FILES['attachment'];
	// upload attachment
	if ($attachment['name'] && !$params['procure']['attachmentname']) {
		if($attachment['error'] || !$attachment['size']) {
			// Error uploading attachment
			$params['error'][] = "1007";
			$params['function'] = $function;
		} else {
			$file_destination = upload_file($attachment,$module,$cfg);
			if (is_string($file_destination)) {
				$params['procure']['attachmentname'] = $attachment['name'];
				// set file information
				$_SESSION['procure']['attachment']['name'] = $attachment['name'];
				$_SESSION['procure']['attachment']['content'] = base64_encode(file_get_contents($file_destination));
			} else {
				// Error uploading attachment
				$params['error'] = array_merge($params['error'],$file_destination['error']);
				$params['function'] = $function;
			}
		}
	}
	// send the message to app
	send_message($params,$cfg);
}

function prepare_request($module,$function,$cfg,$info=array(),$error=array()) {
	// clean the procure session to prevent multiple procure requested simultaneously
	unset($_SESSION['procure']);
	// determine if admin requesting tender on behlf of user
	// 1000 - User ID must be a number
	$fields_request['usersid'] = array("",REQUEST_NUMBER,FORMAT_NONE,"1000");
	if(get_request($fields_request,$info,$error,$cfg)) {
		// paramaters to send to the application server
		$params = array(
			'module'	=> $module,
			'function'	=> $function
		);
		if ($info['usersid']) {
			$_SESSION['procure']['userid'] = $params['procure']['userid'] = $info['usersid'];
		}
		// send the message to app
		send_message($params,$cfg);	
	} else {
		// error
		xml_generator("procure","error",$error,"",$cfg);
	}
}

function procure_get_approve($module,$cfg,$info=array(),$error=array()) {
	// field request errors and type 
	// 1033 - Missing Tender ID
	// 1032 - Tender ID must be a number
	$fields_request = array (
		'tenderid'		=> array("1033",	REQUEST_NUMBER,	FORMAT_NONE,	"1032")
	);
	// get fields
	if(get_request($fields_request,$info,$error,$cfg)) {
		// set paramaters
		$params = array(
			'module'		=> $module,
			'function'		=> "approve",
			'searchinfo'	=> $info
		);
		// send the message to app
		send_message($params,$cfg);
	} else {
		// error occurred, generate xml
		xml_generator($module,"error",$error,"",$cfg);
	}
}

function procure_submit_approve($module,$cfg,$info=array(),$error=array()) {
	// field request errors and type 
	// 1003 - Missing RFQ Number
	// 1004 - Missing RFQ Reference
	// 1005 - Missing Area ID
	// 1006 - Area ID must be a number
	// 1027 - Missing Tender Items
	// 1032 - Tender ID must be a number
	// 1033 - Missing Tender ID
	$fields_request = array (
		'tenderid'			=> array("1033",REQUEST_NUMBER,	FORMAT_NONE,	"1032"),
		'rfq_number'		=> array("1003"),
		'rfq_reference'		=> array("1004"),
		'area'				=> array("1005",	REQUEST_NUMBER,	FORMAT_NONE,	"1006"),
		'tenderitem'		=> array("1027"),
		'supplier_select'	=> array()		
	);
	// get fields
	if(get_request($fields_request,$info,$error,$cfg)) {
		// set paramaters
		$params = array(
			'module'		=> $module,
			'function'		=> 'approve',
			'info'			=> $info
		);
		// send the message to app
		send_message($params,$cfg);
	} else {
		// error occurred, generate xml
		xml_generator($module,"error",$error,"",$cfg);
	}
}
?>