<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
	
<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/cancelpurchaseorder"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="id"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="cancel_purchase_order"/>
					<input type="hidden" name="id" value="{id}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
			<xsl:choose>
				<xsl:when test="id">
					<tr>
						<td class="h t1"><xsl:value-of select="$lng/reason"/></td>
					</tr>
					<tr>
						<td>
							<textarea class="t2" name="reason" cols="60" rows="4"></textarea>
						</td>
					</tr>
					<tr>
						<td class="t2" align="right">
							<xsl:value-of select="$lng/cancellationfee"/>
							<xsl:value-of select="' '"/>
							<xsl:value-of select="localprecurrency"/>
							<input type="text" name="cancellationfee" size="4" maxlenght="40" class="t2" value="0.00"/>
							<xsl:value-of select="localpostcurrency"/>
						</td>
					</tr>
					<tr>
						<td class="t2" align="right">
							<input type="submit" name="action" class="t2">
								<xsl:attribute name="value">
									<xsl:value-of select="$lng/submit"/>
								</xsl:attribute>
							</input>
							<xsl:value-of select="' '"/>
							<select name="notify" class="t2">
								<option value=""><xsl:value-of select="$lng/notifynone"/></option>
								<option value="all"><xsl:value-of select="$lng/notifyall"/></option>
							</select>
						</td>
					</tr>
				</xsl:when>
				<xsl:when test="cancel">
					<tr>
						<td class="t1"><xsl:value-of select="$lng/purchaseordercanceled"/></td>
					</tr>
					<tr>
						<td class="t1">
							<a target="main">
								<xsl:attribute name="href">
									<xsl:value-of select="concat('./main.php?module=report&amp;function=company&amp;reporttype=tender_group_by_quote&amp;tenderid=',tenderinfo/id,'&amp;organisationid=',tenderinfo/organisation)"/>
								</xsl:attribute>
								<xsl:value-of select="$lng/completerfq"/>
							</a>
						</td>
					</tr>
				</xsl:when>
			</xsl:choose>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/cancelpurchaseorder"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/cancelinstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<script type="text/javascript">

	</script>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
