<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="./procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderitemprofile"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="item_profile"/>
					<input type="hidden" name="id" value="{tenderiteminfo/id}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
					<xsl:if test="updated='1'">
						<tr>
							<td colspan="5" class="t1">
								<xsl:value-of select="$lng/updated"/>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/tenderinfo"/>:
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderiteminfo/tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/rfq_number"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderiteminfo/tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/rfq_number"/>
								</a>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/rfq_reference"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/statename"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/areaname"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" class="t2">
								<xsl:call-template name="tender_icon">
									<xsl:with-param name="classification" select="tenderiteminfo/tenderclassification"/>
									<xsl:with-param name="status" select="tenderiteminfo/tenderstatus"/>
								</xsl:call-template>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/requested"/>
							</td>
							<td align="left" class="t2">
								<a target="main" href="./main.php?module=user&amp;function=profile&amp;id={tenderiteminfo/usersid}">
									<xsl:value-of select="tenderiteminfo/name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderiteminfo/surname"/>
								</a>
							</td>
						</tr>
						<tr>
							<td colspan="5"><br/></td>
						</tr>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/tenderiteminfo"/>:<xsl:value-of select="tenderiteminfo/id"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/classification"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/classification"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/category"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/categoryname"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/category_sub"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/category_subname"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="brand" class="t2" value="{tenderiteminfo/brand}">
									<xsl:if test="editable='0' or tenderiteminfo/status!='2' or tenderiteminfo/type &gt; 2">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" valign="top" class="t1">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td align="left" valign="top" class="t2">
								<input type="text" name="model" class="t2" value="{tenderiteminfo/model}" size="10">
									<xsl:if test="editable='0' or tenderiteminfo/status!='2' or tenderiteminfo/type &gt; 2">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
							</td>
							<td align="left" valign="top" class="t1">
								<xsl:value-of select="$lng/description"/>
							</td>
							<td align="left" valign="top" class="t2">
								<textarea type="text" name="description" class="t2" cols="30">
									<xsl:if test="editable='0' or tenderiteminfo/status!='2'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
									<xsl:value-of select="tenderiteminfo/description"/>
								</textarea>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/quote"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="localprecurrency"/>
								<input type="text" name="quote" class="t2" size="8" value="{tenderiteminfo/quote}">
									<xsl:if test="editable='0' or tenderiteminfo/status!='2'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
								<xsl:value-of select="localpostcurrency"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/budget"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="localprecurrency"/>
								<input type="text" name="budget" class="t2" size="8" value="{tenderiteminfo/budget}">
									<xsl:if test="editable='0' or tenderiteminfo/status!='2'">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
								<xsl:value-of select="localpostcurrency"/>								
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/sent"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/sent"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/received"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/received"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" class="t2">
								<xsl:call-template name="tender_item_icon">
									<xsl:with-param name="classification" select="tenderiteminfo/classification"/>
									<xsl:with-param name="status" select="tenderiteminfo/status"/>
									<xsl:with-param name="completestatus" select="tenderiteminfo/complete_status"/>
									<xsl:with-param name="tenderclassification" select="tenderiteminfo/tenderclassification"/>
								</xsl:call-template>
							</td>
						<xsl:if test="tenderiteminfo/error!=''">
							<td align="left" class="t1">
								<xsl:value-of select="$lng/error"/>
							</td>
							<td align="left" class="e">
								<xsl:value-of select="tenderiteminfo/error"/>
							</td>
						</xsl:if>
						</tr>
					<xsl:if test="editable='1' and tenderiteminfo/status='2'">
						<tr>
							<td><br/></td>
							<td align="right" class="t1">
								<xsl:value-of select="$lng/notifymessage"/>
							</td>
							<td class="t2" colspan="3">
								<textarea name="message" cols="45" rows="2" class="t2"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="right" colspan="4">
								<input type="submit" name="changetender" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
								<input type="checkbox" name="notify" class="t2"/>
								<xsl:value-of select="$lng/notify"/>
								<input type="checkbox" name="invalidatequotes" class="t2"/>
								<xsl:value-of select="$lng/invalidatequotes"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="tenderiteminfo/status='6'">
						<tr colspan="5">
							<td><br/></td>
						</tr>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/completeinfo"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/transactionfee"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="localprecurrency"/><xsl:value-of select="tenderiteminfo/transaction_fee"/><xsl:value-of select="localpostcurrency"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/completedate"/>
							</td>
							<td align="left" colspan="3" class="t2">
								<xsl:value-of select="tenderiteminfo/complete_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderiteminfo/complete_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="localdisplay"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" class="t2">
								<xsl:choose>
									<xsl:when test="tenderiteminfo/complete_status='1'">
										<xsl:value-of select="$lng/awarded"/>
									</xsl:when>
									<xsl:when test="tenderiteminfo/complete_status='2'">
										<xsl:value-of select="$lng/nontender"/>
									</xsl:when>
									<xsl:when test="tenderiteminfo/complete_status='3'">
										<xsl:value-of select="$lng/cashsettlement"/>
									</xsl:when>
									<xsl:when test="tenderiteminfo/complete_status='4'">
										<xsl:value-of select="$lng/invalidate"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/reason"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/reason"/>
							</td>
						</tr>
				<xsl:if test="tenderiteminfo/complete_status='1'">
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/purchaseorder"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=authenticate_purchase_order&amp;auth_string=',tenderiteminfo/authentication,'&amp;tenderid=',tenderiteminfo/tenderid,'&amp;language=',user/language)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/purchase_order"/>
								</a>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tenderquote"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=quote_profile&amp;id=',tenderiteminfo/tender_quote)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/tender_quote"/>
								</a>
							</td>
						</tr>
					<xsl:if test="feedback_response or tenderiteminfo/forid!=tenderiteminfo/byid">
						<tr>
							<td><br/></td>
						<xsl:if test="feedback_response">
							<td align="left" class="t1">
								<xsl:value-of select="$lng/feedbackresponse"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',tenderiteminfo/forid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/complete_order"/>
								</a>
							</td>
						</xsl:if>
						<xsl:if test="tenderiteminfo/forid!=tenderiteminfo/byid">
							<td align="left" class="t1">
									<xsl:value-of select="$lng/completefor"/>
								</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',tenderiteminfo/forid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/forname"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderiteminfo/forsurname"/>
								</a>
							</td>
						</xsl:if>
						</tr>
					</xsl:if>
				</xsl:if>
					<xsl:if test="tenderiteminfo/complete_status='2'">
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/nontender"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/nontender"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/amount"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/cash"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="tenderiteminfo/complete_status='3'">
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/amount"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderiteminfo/cash"/>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/completeby"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',tenderiteminfo/byid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/byname"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderiteminfo/bysurname"/>
								</a>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="tenderiteminfo/agent">
						<tr colspan="5">
							<td><br/></td>
						</tr>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/agentinfo"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="4">
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
									<tr>
										<td class="h1 t1">
											<xsl:value-of select="$lng/supplier"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/agentname"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/method"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/email"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/phonework"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/phonemobile"/>
										</td>
									<xsl:if test="/response/user/classification='3'">
										<td class="h1a t1">
											<xsl:value-of select="$lng/sendsms"/>
										</td>
									</xsl:if>
										<td class="h1a t1">
											<xsl:value-of select="$lng/message"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/quote"/>
										</td>
									</tr>
								<xsl:for-each select="tenderiteminfo/agent">
									<tr>
										<td class="h2b t2" align="left" valign="top">
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./organisation)"/>
												</xsl:attribute>
												<xsl:value-of select="suppliername"/>
											</a>
										</td>
										<td class="h2c t2">
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
												</xsl:attribute>
												<xsl:value-of select="name"/>
												<xsl:value-of select="' '"/>
												<xsl:value-of select="surname"/>
											</a>
										</td>
										<td class="h2c t2">
											<xsl:value-of select="method"/>
										</td>
										<td class="h2c t2">
											<a target="main">
												<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/rfqnumber"/>: <xsl:value-of select="../rfq_number"/></xsl:attribute>
												<xsl:value-of select="email"/>
											</a>
										</td>
										<td class="h2c t2">
											<a>
												<xsl:attribute name="href">
													<xsl:value-of select="'callto://+'"/>
													<xsl:value-of select="phone_prefix"/>
													<xsl:number value="phone_work" format="1"/>
												</xsl:attribute>
												<xsl:value-of select="phone_work"/>
											</a>
										</td>
										<td class="h2c t2">
											<a>
												<xsl:attribute name="href">
													<xsl:value-of select="'callto://+'"/>
													<xsl:value-of select="phone_prefix"/>
													<xsl:number value="phone_mobile" format="1"/>
												</xsl:attribute>
												<xsl:value-of select="phone_mobile"/>
											</a>
										</td>
									<xsl:if test="/response/user/classification='3'">
										<td class="h2c t2">
											<a>
												<xsl:attribute name="href">./main.php?module=messenger&amp;function=utilities&amp;usersid=<xsl:value-of select="usersid"/>&amp;body=<xsl:value-of select="$lng/rfqnumber"/>: <xsl:value-of select="../rfq_number"/></xsl:attribute>
												<img src="./theme/{$theme}/icon/sms.gif" border="0">
													<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/sms"/></xsl:attribute>
												</img>
											</a>
										</td>
									</xsl:if>
										<td class="h2c t2" valign="top">
										<xsl:if test="request_message!='' and request_message!='0'">
											<a>
												<xsl:attribute name="href">./main.php?module=generic&amp;function=message&amp;id=<xsl:value-of select="request_message"/></xsl:attribute>
												<img src="./theme/{$theme}/icon/mail_view.gif" border="0">
													<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/message"/></xsl:attribute>
												</img>
											</a>
											<xsl:if test="/response/user/classification='3'">
											<a onclick="alertsend('{request_message}','{email}')">
												<img src="./theme/{$theme}/icon/resubmit.gif" border="0">
													<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/send"/></xsl:attribute>
												</img>
											</a>
											</xsl:if>
										</xsl:if>
										<xsl:if test="request_message='' or request_message='0'">
											<xsl:value-of select="$lng/none"/>
										</xsl:if>
										</td>
										<td class="h2c t2" align="left" valign="top">
									<xsl:choose>
										<xsl:when test="/response/tenderinfo/status = 6">
											<xsl:value-of select="$lng/completed"/>
										</xsl:when>
										<xsl:when test="/response/tenderinfo/status > 3">	
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=',/response/tenderiteminfo/tenderclassification,'&amp;function=add_quote&amp;usersid=',id,'&amp;tenderitem=',/response/tenderiteminfo/id)"/>
												</xsl:attribute>
												<xsl:value-of select="$lng/add"/>
											</a>
										</xsl:when>
										<xsl:otherwise>
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=',/response/tenderiteminfo/tenderclassification,'&amp;function=quote&amp;usersid=',id,'&amp;tenderitem=',/response/tenderiteminfo/id)"/>
												</xsl:attribute>
												<xsl:value-of select="$lng/submit"/>
											</a>
										</xsl:otherwise>
									</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
								</table>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="tenderiteminfo/quote_response">
						<tr>
							<td colspan="5"><br/></td>
						</tr>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/quote"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="4">
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
									<tr>
										<td><br/></td>
										<td class="h1 t1">
											<xsl:value-of select="$lng/agentname"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/method"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/brand"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/model"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/description"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/createdon"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/price"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/position"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/status"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/message"/>
										</td>
									</tr>
								<xsl:for-each select="tenderiteminfo/quote_response">
									<tr>
										<td><br/></td>
										<td class="h2b t2" align="left" valign="top">
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./userid)"/>
												</xsl:attribute>
												<xsl:value-of select="name"/><xsl:value-of select="' '"/><xsl:value-of select="surname"/>
											</a>
										</td>
										<td class="h2c t2" align="left" valign="top">
											<xsl:value-of select="method"/>
										</td>
										<td class="h2c t2" align="left" valign="top">
											<xsl:value-of select="brand"/>
										</td>
										<td class="h2c t2" align="left" valign="top">
											<xsl:value-of select="model"/>
										</td>
										<td class="h2c t2" align="left" valign="top">
											<pre class="t2">
												<xsl:value-of select="description"/>
											</pre>
										</td>
										<td class="h2c t2" align="left" valign="top">
											<xsl:value-of select="created_date"/>
										</td>
										<td class="h2c t2" align="left"  valign="top">
											<xsl:value-of select="../localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="../localpostcurrency"/>
										</td>
										<td class="h2c t2" align="left" valign="top">
											<xsl:call-template name="position_icon">
												<xsl:with-param name="position" select="quote_position"/>
											</xsl:call-template>
										</td>
										<td class="h2c t2" align="left" valign="top">
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=procure&amp;function=quote_profile&amp;id=',./id)"/>
												</xsl:attribute>
												<xsl:call-template name="tender_quote_icon">
													<xsl:with-param name="classification" select="classification"/>
													<xsl:with-param name="status" select="status"/>
													<xsl:with-param name="tenderclassification" select="tenderclassification"/>
													<xsl:with-param name="itemclassification" select="itemclassification"/>
												</xsl:call-template>
											</a>
											<xsl:if test="error!=''">
												<textarea type="text" class="t readonly" cols="25" readonly="readonly">
													<xsl:value-of select="error"/>
												</textarea>
											</xsl:if>
										</td>
										<td class="h2c t1" valign="top">
											<xsl:if test="quote_message!='' and quote_message!='0'">
											<a>
												<xsl:attribute name="href">./main.php?module=generic&amp;function=message&amp;id=<xsl:value-of select="quote_message"/></xsl:attribute>
												<img src="./theme/{$theme}/icon/mail_view.gif" border="0">
													<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/message"/></xsl:attribute>
												</img>
											</a>
											</xsl:if>
											<xsl:if test="quote_message='' or quote_message='0'">
												<xsl:value-of select="$lng/none"/>
											</xsl:if>
										</td>
									</tr>
								</xsl:for-each>
								</table>
							</td>
						</tr>
					</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script language="javascript">
		function alertremove() {	
			var del = document.report.deletetender.checked;
			if(del) {
				if(!confirm("<xsl:value-of select="$lng/alertdeletetender"/>")) {
					document.report.deletetender.checked = false;
				}
			}
		}
		
		function alertsend(id,email) {	
			if(confirm("<xsl:value-of select="$lng/resendemail"/>")) {
				parent.main.location.href = "main.php?module=generic&amp;function=resend&amp;id="+id+"&amp;email="+email;
			}
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
