<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>

<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
		<style type="text/css">
			html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
			#wrapper {height: 78%; background-color: #FFFFFF; align: left; padding-left: 2px; padding-top: 2px;}
		</style>
	</head>
<body>
	<table id="wrapper" height="100%" border="0" align="center" cellpadding="2" cellspacing="0" width="100">
		<tr>
			<td align="left" valign="top" width="100">
				<div id="left">
				<form enctype="multipart/form-data" action="left.php?module=useradmin&amp;function=search" method="post" name="report">
					<table border="0" align="left" cellpadding="0" cellspacing="1" width="100%" bgcolor="FFFFFF">
						<tr>
							<td>
								<b><xsl:value-of select="$lng/tenderadmin"/></b>
							</td>
						</tr>
						<tr>
							<td>
								<a href="#" onclick="show_tender()"><xsl:value-of select="$lng/tender"/></a>
								<select name="tender" onchange="show_tender()" class="t1">
									<option value=""><xsl:value-of select="$lng/all"/></option>
									<option value="0"><xsl:value-of select="$lng/error"/></option>
									<option value="1"><xsl:value-of select="$lng/approval"/></option>
									<option value="2"><xsl:value-of select="$lng/open"/></option>
									<option value="4"><xsl:value-of select="$lng/uncompleted"/></option>
									<option value="6"><xsl:value-of select="$lng/completed"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td>
								<a href="#" onclick="show_tender_item()"><xsl:value-of select="$lng/tenderitem"/></a>
								<select name="tenderitem" onchange="show_tender_item()" class="t1">
									<option value=""><xsl:value-of select="$lng/all"/></option>
									<option value="0"><xsl:value-of select="$lng/error"/></option>
									<option value="2"><xsl:value-of select="$lng/open"/></option>
									<option value="4"><xsl:value-of select="$lng/closed"/></option>
									<option value="6"><xsl:value-of select="$lng/awarded"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td>
								<a href="#" onclick="show_tender_quote()"><xsl:value-of select="$lng/tenderquote"/></a>
								<select name="tenderquote" onchange="show_tender_quote()" class="t1">
									<option value=""><xsl:value-of select="$lng/all"/></option>
									<option value="0"><xsl:value-of select="$lng/error"/></option>
									<option value="2"><xsl:value-of select="$lng/open"/></option>
									<option value="4"><xsl:value-of select="$lng/closed"/></option>
									<option value="6"><xsl:value-of select="$lng/awarded"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td>
								<a href="#" onclick="show_purchase_order()"><xsl:value-of select="$lng/purchaseorder"/></a>
							</td>
						</tr>
						<tr>
							<td>
								<ul>
								<!-- dynamic -->
								<xsl:if test="link">
									<xsl:for-each select="link">
									<li>
										<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
											<xsl:if test="script_alert">
												<xsl:attribute name="href">#</xsl:attribute>
												<xsl:attribute name="onclick">script_alert('<xsl:value-of select="script_alert"/>','<xsl:value-of select="frame"/>','<xsl:value-of select="module"/>','<xsl:value-of select="function"/>')</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="name"/>
										</a>
									</li>
									</xsl:for-each>
								</xsl:if>
								</ul>						
							</td>
						</tr>
					</table>
				</form>
				<script language="javascript">
					function show_tender() {
						parent.main.location.href ="main.php?module=procure&amp;function=show_tender&amp;tenderstatus="+document.report.tender.value+"";
					}
					function show_tender_item() {
						parent.main.location.href ="main.php?module=procure&amp;function=show_tender_item&amp;tenderitemstatus="+document.report.tenderitem.value+"";
					}
					function show_tender_quote() {
						parent.main.location.href ="main.php?module=procure&amp;function=show_tender_quote&amp;tenderquotestatus="+document.report.tenderquote.value+"";
					}
					function show_purchase_order() {
						parent.main.location.href ="main.php?module=procure&amp;function=show_purchase_order";
					}
					
					function script_alert(myMessage,myFrame,myModule,myFunction) {
						if(confirm(myMessage+"")) {
							parent.main.location.href = myFrame+".php?module="+myModule+"&amp;function="+myFunction;
						}
					}
					parent.main.location.href="main.php?module=procure&amp;function=show_tender";
				</script>
				</div>
			</td>
		</tr>
	</table>
	<xsl:call-template name="footer_left"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>