<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="itempopulate_script">
	<xsl:param name="brandfield" select="'brand'"/>
	<xsl:param name="modelfield" select="'model'"/>
	<xsl:param name="descriptionfield" select="'description'"/>
	function populate(myBrand,myModel,myMessage) {
		document.report.<xsl:value-of select="$brandfield"/>.value = myBrand;
		document.report.<xsl:value-of select="$modelfield"/>.value = myModel;
		document.report.<xsl:value-of select="$descriptionfield"/>.value = myMessage;
	}
</xsl:template>

<xsl:template name="model_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'model'"/>
	<xsl:param name="model" select="procure/model"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
		<xsl:if test="$empty_td='1' or empty_td='yes'">
			<td><br/></td>
		</xsl:if>
		<td class="t1"><xsl:value-of select="$lng/model"/></td>
		<td class="t2"><input type="text" name="{$fieldname}" size="20" class="t2" value="{$model}" onChange="{$onchange}"/></td>
	</tr>
</xsl:template>

<xsl:template name="quantity_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'quantity'"/>
	<xsl:param name="quantity" select="procure/quantity"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
		<xsl:if test="$empty_td='1' or empty_td='yes'">
			<td ><br/></td>
		</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/quantity"/><xsl:value-of select="'  '"/>
		</td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="4" class="t2" value="{$quantity}" onChange="{$onchange}"/>
			<input type="hidden" name="{$fieldname}message" value="{$lng/quantitymessage}"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="commodity_field">
	<xsl:param name="quantity" select="procure/quantity"/>
	<xsl:param name="model" select="procure/model"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
		<xsl:if test="$empty_td='1' or empty_td='yes'">
			<td ><br/></td>
		</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/quantity"/><xsl:value-of select="'  '"/>
		</td>
		<td class="t2">
			<input type="text" name="quantity" size="4" class="t2" value="{$quantity}"/>
			<input type="hidden" name="quantitymessage" value="{$lng/quantitymessage}"/>
			<select name="modelselect" class="t2" onchange="brandupdate(model,this)">
				<option value="">
					<xsl:value-of select="$lng/selectunit"/>
				</option>
				<xsl:for-each select="commodity/item">
					<option value="{value}">
						<xsl:value-of select="name"/>
					</option>
				</xsl:for-each>
			</select>
			<input type="text" name="model" size="20" class="t2" value="{$model}"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="description_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'description'"/>
	<xsl:param name="description" select="procure/description"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
		<xsl:if test="$empty_td='1' or empty_td='yes'">
			<td ><br/></td>
		</xsl:if>
		<td class="t1"><xsl:value-of select="$lng/description"/></td>
		<td class="t2"><textarea name="{$fieldname}" rows="3" cols="50" class="t2" onChange="{$onchange}"><xsl:value-of select="$description"/></textarea></td>
	</tr>
</xsl:template>

<xsl:template name="add_description_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'add_des'"/>
	<xsl:param name="empty_td" select="'no'"/>
	<xsl:for-each select="add_des">
		<xsl:choose>
			<xsl:when test="type='checkbox'">
				<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
					<td class="t1"><xsl:value-of select="question"/></td>
					<td class="t2">
						<input type="checkbox" value="{value}" name="{$fieldname}[{count}]">
							<xsl:variable name="current" select="value"/>
							<xsl:if test="/response/procure/additional_des">
								<xsl:for-each select="/response/procure/additional_des">
									<xsl:if test=".=$current">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</xsl:for-each>
							</xsl:if>
						</input>
					</td>
				</tr>
			</xsl:when>
			<xsl:when test="type='select'">
				<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
					<td class="t1"><xsl:value-of select="question"/></td>
					<td class="t2">
						<select class="t2" name="{$fieldname}[{count}]">
							<xsl:for-each select="option">
								<option value="{value}">
									<xsl:variable name="current" select="value"/>
									<xsl:if test="/response/procure/additional_des">
										<xsl:for-each select="/response/procure/additional_des">
											<xsl:if test=".=$current">
												<xsl:attribute name="selected"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:if>
									<xsl:value-of select="name"/>
								</option>
							</xsl:for-each>
						</select>
					</td>
				</tr>
			</xsl:when>
			<xsl:when test="type='text'">
				<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
					<td class="t1"><xsl:value-of select="question"/></td>
					<td class="t2">
						<input type="hidden" value="{prepend}" name="{$fieldname}[{count}][0]"/>
						<input type="text" class="t2" name="{$fieldname}[{count}][1]"/>
					</td>
				</tr>
			</xsl:when>
			<xsl:when test="type='radio'">
				<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
					<td class="t1"><xsl:value-of select="question"/></td>
					<td class="t2">
						<xsl:variable name="count" select="count"/>
						<xsl:for-each select="option">
							<input value="{value}" type="radio" name="{$fieldname}[{$count}]">
								<xsl:if test="default">
									<xsl:attribute name="checked"/>
								</xsl:if>
								<xsl:variable name="current" select="value"/>
								<xsl:if test="/response/procure/additional_des">
									<xsl:for-each select="/response/procure/additional_des">
										<xsl:if test=".=$current">
											<xsl:attribute name="checked"/>
										</xsl:if>
									</xsl:for-each>
								</xsl:if>
							</input>
							<xsl:value-of select="name"/>
						</xsl:for-each>
					</td>
				</tr>
			</xsl:when>
			<xsl:otherwise>
				<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
					<td class="t1"><xsl:value-of select="question"/></td>
					<td class="t2">(<xsl:value-of select="type"/>)</td>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>		
</xsl:template>

<xsl:template name="quote_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'quote'"/>
	<xsl:param name="quote" select="procure/quote"/>
	<xsl:param name="quotemessage" select="$lng/notdisplayed"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/quote"/>
		</td>
		<td class="t2">
			<xsl:value-of select="/response/localprecurrency"/>
			<input type="text" name="{$fieldname}" size="8" class="t2" value="{$quote}" onChange="{$onchange}"/>
			<xsl:value-of select="/response/localpostcurrency"/>
			<xsl:value-of select="' '"/><xsl:value-of select="$quotemessage"/>				
		</td>
	</tr>
</xsl:template>

<xsl:template name="budget_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'budget'"/>
	<xsl:param name="budget" select="procure/budget"/>
	<xsl:param name="budgetmessage" select="$lng/displayed"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/budget"/>
		</td>
		<td class="t2">
			<xsl:value-of select="/response/localprecurrency"/>
			<input type="text" name="{$fieldname}" size="8" class="t2" value="{$budget}"/>
			<xsl:value-of select="' '"/><xsl:value-of select="$budgetmessage"/>
			<xsl:value-of select="/response/localpostcurrency"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="rfq_number_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'rfq_number'"/>
	<xsl:param name="rfq_number" select="procure/rfq_number"/>
	<xsl:param name="rfq_number_done" select="rfq_number_done"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1"><xsl:value-of select="$lng/rfqnumber"/></td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="30" class="t2" value="{$rfq_number}" onChange="{$onchange}">
				<xsl:if test="autorfq='1'">
					<xsl:attribute name="value"><xsl:value-of select="$lng/autorfq"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="autorfq='1' or rfq_number_done='yes' or rfq_number_done='1'">
					<xsl:attribute name="class">readonly t2</xsl:attribute>
					<xsl:attribute name="readonly"/>
				</xsl:if>
			</input>
		</td>
	</tr>
</xsl:template>

<xsl:template name="rfq_reference_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'rfq_reference'"/>
	<xsl:param name="rfq_reference" select="procure/rfq_reference"/>
	<xsl:param name="rfq_reference_done" select="rfq_reference_done"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1"><xsl:value-of select="$lng/rfqreference"/></td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="30" class="t2" value="{$rfq_reference}" onChange="{$onchange}">
				<xsl:if test="rfq_reference_done='yes' or rfq_reference_done='1'">
					<xsl:attribute name="class">readonly t2</xsl:attribute>
					<xsl:attribute name="readonly"/>
				</xsl:if>
			</input>
		</td>
	</tr>
</xsl:template>

<xsl:template name="attachment_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'attachment'"/>
	<xsl:param name="attachmentname" select="procure/attachmentname"/>
	<xsl:param name="showattachment" select="attachment"/>
	<xsl:param name="empty_td" select="'no'"/>
	<xsl:if test="$showattachment='true'or $showattachment='1'">
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1"><xsl:value-of select="$lng/attachment"/></td>
		<td class="t2">
	<xsl:choose>
		<xsl:when test="$attachmentname">
			<input type="hidden" name="{$fieldname}name" value="{$attachmentname}"/>
			<xsl:value-of select="$attachmentname"/>
		</xsl:when>
		<xsl:otherwise>
			<input type="file" name="{$fieldname}" size="20" class="t2" onChange="{$onchange}"/>
		</xsl:otherwise>
	</xsl:choose>
		</td>
	</tr>
	</xsl:if>
</xsl:template>

<xsl:template name="submit_button">
	<xsl:param name="fieldname" select="'action'"/>
	<xsl:param name="showaddproduct" select="'yes'"/>
	<xsl:param name="submit" select="'yes'"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
		<td align="center" colspan="2">
			<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
			<xsl:if test="$submit='yes' or $submit='1'">
				<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
					<td align="right" class="t2" colspan="3">
						<input type="submit" name="{$fieldname}[submit]" value="{$lng/submit}" class="t2"/>
					</td>
				</tr>
			</xsl:if>
		<xsl:if test="$showaddproduct='yes' or $showaddproduct='1'">
				<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
					<td align="right" class="t2" colspan="3">
						<input type="submit" name="{$fieldname}[product]" value="{$lng/addproduct}" class="t2"/>
					</td>
				</tr>
			<xsl:if test="product/name">
				<tr>
					<td colspan="3"><br/></td>
				</tr>
				<tr>
				<xsl:if test="$empty_td='1' or empty_td='yes'">
					<td ><br/></td>
				</xsl:if>
					<td align="center" colspan="2">
						<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
							<xsl:for-each select="product[position() mod 3 = 1]">
								<tr>
								<xsl:for-each select=".|following-sibling::product[position() &lt; 3]">
									<td class="g" align="center">
										<input type="submit" name="{$fieldname}[{name}]" value="{value}" class="t2" />
									</td>
								</xsl:for-each>
								</tr>
							</xsl:for-each>
						</table>
					</td>
				</tr>
			</xsl:if>
		</xsl:if>
			</table>
		</td>
	</tr>
</xsl:template>

<xsl:template name="right_intstruction">
	<xsl:param name="showaddproduct" select="'yes'"/>
	<div id="right_header">
		<xsl:choose>
			<xsl:when test="product_name">
				<xsl:value-of select="$lng/add"/><xsl:value-of select="' '"/><xsl:value-of select="product_name"/>
			</xsl:when>	
			<xsl:otherwise>
				<xsl:value-of select="$lng/addproduct"/>
			</xsl:otherwise>
		</xsl:choose>
	</div>
	<div id="right_content">
		<xsl:for-each select="$lng/prodinst">
			<xsl:value-of select="."/><br/>
		</xsl:for-each>
	<xsl:if test="$showaddproduct='yes' or $showaddproduct='1'">
		<xsl:if test="product/name">
			<xsl:value-of select="$lng/instselect"/><br/>
			<ul>
			<xsl:for-each select="product">
				<xsl:variable name="product" select="name"/>
				<xsl:variable name="button">
					<xsl:value-of select="$lng/*[local-name(.)=$product]"/>
				</xsl:variable>
				<xsl:if test="status='true'">
					<li><xsl:value-of select="$button"/><br/></li>
				</xsl:if>
			</xsl:for-each>
			</ul>
		</xsl:if>
	</xsl:if>
	</div>
</xsl:template>

<xsl:template name="quick_product">
	<xsl:param name="showaddproduct" select="'yes'"/>
	<div id="right_header"><xsl:value-of select="$lng/quickpad"/></div>
	<div id="right_content">
		<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
			<xsl:for-each select="quick_product">
				<tr>
					<td colspan="5" align="left" class="h1 t1"><xsl:value-of select="name"/></td>
				</tr>
				<xsl:for-each select="item[position() mod 5 = 1]">
					<tr>
						<xsl:for-each select=".|following-sibling::item[position() &lt; 5]">
							<td align="left">
								<xsl:attribute name="onClick">populate('<xsl:value-of select="brand"/>','<xsl:value-of select="model"/>','<xsl:value-of select="description"/>')</xsl:attribute>
								<b><xsl:value-of select="model"/></b>
							</td>
						</xsl:for-each>
					</tr>
				</xsl:for-each>
			</xsl:for-each>
		</table>
	</div>
</xsl:template>

<xsl:template name="basket">
	<xsl:if test="shopping/product">
		<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
			<tr>
				<td align="left" class="h t1" colspan="5">
					<xsl:value-of select="$lng/shopheader"/><xsl:value-of select="' '"/><xsl:value-of select="shopping/rfq_number"/>
				</td>
			</tr>
			<tr>
				<td align="left" class="h1b t1">
					<xsl:value-of select="$lng/brand"/>
				</td>
				<td align="left" class="h1c t1">
					<xsl:value-of select="$lng/model"/>
				</td>
				<td align="left" class="h1c t1">
					<xsl:value-of select="$lng/description"/>
				</td>
			</tr>
			<xsl:for-each select="shopping/product">
				<tr>
					<td align="left" class="h2b t">
						<xsl:value-of select="brand"/>
					</td>
					<td align="left" class="h2c t">
						<xsl:value-of select="model"/>
					</td>
					<td align="left" class="h2c t">
						<xsl:value-of select="description"/>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:if>
</xsl:template>

<xsl:template name="clienttitle_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'title'"/>
	<xsl:param name="title" select="procure/title"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/clienttitle"/>
		</td>
		<td class="t2">
			<xsl:call-template name="client_title_select">
				<xsl:with-param name="onchange" select="$onchange"/>
				<xsl:with-param name="fieldname" select="$fieldname"/>
				<xsl:with-param name="title" select="$title"/>
			</xsl:call-template>
		</td>
	</tr>
</xsl:template>

<xsl:template name="clientidno_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'id_number'"/>
	<xsl:param name="id_number" select="procure/id_number"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/clientidno"/>
		</td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="20" class="t2" value="{$id_number}" onChange="{$onchange}"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="clientsurname_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'surname'"/>
	<xsl:param name="surname" select="procure/surname"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/clientsurname"/>
		</td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="20" class="t2" value="{$surname}" onChange="{$onchange}"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="clientphonework_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'phone_work'"/>
	<xsl:param name="phone_work" select="procure/phone_work"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/clientphonework"/>
		</td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="20" class="t2" value="{$phone_work}" onChange="{$onchange}"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="clientphonefax_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'phone_fax'"/>
	<xsl:param name="phone_fax" select="procure/phone_fax"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/clientphonefax"/>
		</td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="20" class="t2" value="{$phone_fax}" onChange="{$onchange}"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="clientphonemobile_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'phone_mobile'"/>
	<xsl:param name="phone_mobile" select="procure/phone_mobile"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/clientphonemobile"/>
		</td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="20" class="t2" value="{$phone_mobile}" onChange="{$onchange}"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="clientemail_field">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'email'"/>
	<xsl:param name="email" select="procure/email"/>
	<xsl:param name="empty_td" select="'no'"/>
	<tr>
	<xsl:if test="$empty_td='1' or empty_td='yes'">
		<td ><br/></td>
	</xsl:if>
		<td class="t1">
			<xsl:value-of select="$lng/clientemail"/>
		</td>
		<td class="t2">
			<input type="text" name="{$fieldname}" size="20" class="t2" value="{$email}" onChange="{$onchange}"/>
		</td>
	</tr>
</xsl:template>

<xsl:template name="transport_value">
	<xsl:param name="transport" select="transport"/>
	<xsl:choose>
		<xsl:when test="$transport='c'">
			<xsl:value-of select="$lng/collect"/>
		</xsl:when>
		<xsl:when test="$transport='d'">
			<xsl:value-of select="$lng/deliver"/>
		</xsl:when>
		<xsl:when test="$transport='i'">
			<xsl:value-of select="$lng/install"/>
		</xsl:when>
		<xsl:when test="$transport='n' or $transport='0'  or $transport=''">
			<xsl:value-of select="$lng/none"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$lng/unknown"/><xsl:value-of select="'('"/><xsl:value-of select="$transport"/><xsl:value-of select="')'"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
	
<xsl:template name="client_title_select">
	<xsl:param name="onchange" select="''"/>
	<xsl:param name="fieldname" select="'title'"/>
	<xsl:param name="id" select="'title'"/>
	<xsl:param name="title" select="''"/>
	<select name="{$fieldname}" id="{$id}" class="t2" onchange="{$onchange}">
		<option value=""><xsl:value-of select="$lng/selecttitle"/></option>
		<option value="{$lng/ms}">
			<xsl:if test="$lng/ms=$title"><xsl:attribute name="selected"/></xsl:if>
			<xsl:value-of select="$lng/ms"/>
		</option>
		<option value="{$lng/mrs}">
			<xsl:if test="$lng/mrs=$title"><xsl:attribute name="selected"/></xsl:if>
			<xsl:value-of select="$lng/mrs"/>
		</option>
		<option value="{$lng/mr}">
			<xsl:if test="$lng/mr=$title"><xsl:attribute name="selected"/></xsl:if>
			<xsl:value-of select="$lng/mr"/>
		</option>
		<option value="{$lng/dr}">
			<xsl:if test="$lng/dr=$title"><xsl:attribute name="selected"/></xsl:if>
			<xsl:value-of select="$lng/dr"/>
		</option>
		<option value="{$lng/prof}">
			<xsl:if test="$lng/prof=$title"><xsl:attribute name="selected"/></xsl:if>
			<xsl:value-of select="$lng/prof"/>
		</option>
	</select>
</xsl:template>

</xsl:stylesheet>