<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
<xsl:template name="tender_icon">
	<xsl:param name="classification" select="'unknown'"/>
	<xsl:param name="status" select="'unknown'"/>
	<xsl:choose>
		<xsl:when test="$classification='unknown' or $status='unknown'">
			<img border="0" align="top" src="./theme/{$theme}/icon/unknown/unknown.gif">
				<xsl:attribute name="alt"><xsl:value-of select="$lng/unknown"/></xsl:attribute>
				<xsl:attribute name="title"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
			</img>
		</xsl:when>
		<xsl:otherwise>
			<img border="0" align="top" src="./theme/{$theme}/icon/{$classification}/{$status}.gif">
				<xsl:attribute name="alt"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
				<xsl:attribute name="title"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
			</img>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
	
<xsl:template name="tender_item_icon">
	<xsl:param name="tenderclassification" select="'unknown'"/>
	<xsl:param name="classification" select="'unknown'"/>
	<xsl:param name="status" select="'unknown'"/>
	<xsl:param name="completestatus" select="'unknown'"/>
	<xsl:choose>
		<xsl:when test="$tenderclassification='unknown' or $status='unknown' or $classification='unknown'">
			<img border="0" align="top" src="./theme/{$theme}/icon/unknown/unknown.gif">
				<xsl:attribute name="alt"><xsl:value-of select="$lng/unknown"/></xsl:attribute>
				<xsl:attribute name="title"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
			</img>
		</xsl:when>
		<xsl:when test="$status!='6'">
			<img border="0" align="top" src="./theme/{$theme}/icon/{$tenderclassification}/item/class_{$classification}/{$status}.gif">
				<xsl:attribute name="alt"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
				<xsl:attribute name="title"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
			</img>			
		</xsl:when>
		<xsl:otherwise>
			<img border="0" align="top" src="./theme/{$theme}/icon/{$tenderclassification}/item/class_{$classification}/complete/{$completestatus}.gif">
				<xsl:attribute name="alt"><xsl:value-of select="concat($tenderclassification,'(',$classification,')(',$completestatus,')')"/></xsl:attribute>
				<xsl:attribute name="title"><xsl:value-of select="concat($tenderclassification,'(',$classification,')(',$completestatus,')')"/></xsl:attribute>
			</img>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
	
<xsl:template name="tender_quote_icon">
	<xsl:param name="tenderclassification" select="'unknown'"/>
	<xsl:param name="itemclassification" select="'unknown'"/>
	<xsl:param name="classification" select="'unknown'"/>
	<xsl:param name="status" select="'unknown'"/>
	<xsl:choose>
		<xsl:when test="$tenderclassification='unknown' or $status='unknown' or $classification='unknown' or $itemclassification='unknown'">
			<img border="0" align="top" src="./theme/{$theme}/icon/unknown/unknown.gif">
				<xsl:attribute name="alt"><xsl:value-of select="$lng/unknown"/></xsl:attribute>
				<xsl:attribute name="title"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
			</img>
		</xsl:when>
		<xsl:otherwise>
			<img border="0" align="top" src="./theme/{$theme}/icon/{$tenderclassification}/item/class_{$itemclassification}/quote/class_{$classification}/{$status}.gif">
				<xsl:attribute name="alt"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
				<xsl:attribute name="title"><xsl:value-of select="concat($classification,'(',$status,')')"/></xsl:attribute>
			</img>			
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
	
<xsl:template name="position_icon">
	<xsl:param name="position" select="'0'"/>
	<xsl:choose>
		<xsl:when test="$position>=0 and $position!='0'">
			<img border="0" align="top" src="./theme/{$theme}/icon/position/{$position}.gif">
				<xsl:attribute name="alt"><xsl:value-of select="$position"/></xsl:attribute>
				<xsl:attribute name="title"><xsl:value-of select="$position"/></xsl:attribute>
			</img>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$lng/na"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>