<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="./procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/procureprofile"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="profile"/>
					<input type="hidden" name="id" value="{tenderinfo/id}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
					<xsl:if test="updated='1'">
						<tr>
							<td colspan="5" class="t1">
								<xsl:value-of select="$lng/updated"/>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/tenderinfo"/>:
								<xsl:value-of select="tenderinfo/rfq_number"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/rfq_number"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/rfq_reference"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/classification"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/classification"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/transport"/>
							</td>
							<td align="left" class="t2">
								<xsl:choose>
									<xsl:when test="tenderinfo/transport='c'">
										<xsl:value-of select="$lng/collect"/>
									</xsl:when>
									<xsl:when test="tenderinfo/transport='d'">
										<xsl:value-of select="$lng/deliver"/>
									</xsl:when>
									<xsl:when test="tenderinfo/transport='i'">
										<xsl:value-of select="$lng/install"/>
									</xsl:when>
									<xsl:when test="tenderinfo/transport='v'">
										<xsl:value-of select="$lng/voucher"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/statename"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/areaname"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" class="t2">
								<xsl:call-template name="tender_icon">
									<xsl:with-param name="classification" select="tenderinfo/classification"/>
									<xsl:with-param name="status" select="tenderinfo/status"/>
								</xsl:call-template>
								<xsl:value-of select="tenderinfo/error"/>
							</td>
						<xsl:if test="tenderinfo/attachment!='0' and tenderinfo/attachment!=''">
							<td align="left" class="t1">
								<xsl:value-of select="$lng/attachment"/>
							</td>
							<td align="left" colspan="3" class="t2">
								<img alt="clip" src="./theme/{$theme}/icon/attach.gif">
									<xsl:attribute name="href">#</xsl:attribute>
								</img>
							</td>
						</xsl:if>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/created_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderinfo/created_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="localdisplay"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/closeon"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/close_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderinfo/close_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="localdisplay"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/requested"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',tenderinfo/usersid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderinfo/name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderinfo/surname"/>
									<xsl:value-of select="' '"/>
									(<a target="main">
										<xsl:attribute name="href">mailto:<xsl:value-of select="tenderinfo/email"/>?subject=<xsl:value-of select="$lng/rfqnumber"/>: <xsl:value-of select="tenderinfo/rfq_number"/> (<xsl:value-of select="tenderinfo/rfq_reference"/>)</xsl:attribute>
										<xsl:value-of select="$lng/email"/>
									</a>)
								</a>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/createdby"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',tenderinfo/creatorid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderinfo/creatorname"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderinfo/creatorsurname"/>
								</a>
							</td>
						</tr>
						<tr>
							<td colspan="5"><br/></td>
						</tr>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/clientinfo"/>:
								<xsl:value-of select="tenderinfo/client_title"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderinfo/client_surname"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/client"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/client_title"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderinfo/client_surname"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/email"/>
							</td>
							<td align="left" class="t2">
								<a href="mailto:{tenderinfo/client_email}">
									<xsl:value-of select="tenderinfo/client_email"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phoneprefix"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/client_phone_prefix"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonefax"/>
							</td>
							<td align="left" class="t2">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="'callto://+'"/>
										<xsl:value-of select="tenderinfo/client_phone_fax"/>
										<xsl:number value="tenderinfo/client_phone_fax" format="1"/>
									</xsl:attribute>
									<xsl:value-of select="tenderinfo/client_phone_fax"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td align="left" class="t2">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="'callto://+'"/>
										<xsl:value-of select="tenderinfo/client_phone_prefix"/>
										<xsl:number value="tenderinfo/client_phone_work" format="1"/>
									</xsl:attribute>
									<xsl:value-of select="tenderinfo/client_phone_work"/>
								</a>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/phonemobile"/>
							</td>
							<td align="left" class="t2">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="'callto://+'"/>
										<xsl:value-of select="tenderinfo/client_phone_prefix"/>
										<xsl:number value="tenderinfo/client_phone_mobile" format="1"/>
									</xsl:attribute>
									<xsl:value-of select="tenderinfo/client_phone_mobile"/>
								</a>
							</td>
						</tr>
					<xsl:if test="tenderinfo/client_address!=''">
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/address"/>
							</td>
							<td align="left" class="t2" colspan="3">
								<textarea class="t2" readonly="" cols="50">
									<xsl:value-of select="tenderinfo/client_address"/>
								</textarea>
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td colspan="5"><br/></td>
						</tr>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/otherinfo"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tenderitems"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/item_count"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=show_tender_item&amp;tenderid=',tenderinfo/id)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/list"/>
								</a>
							</td>
						</tr>
					<xsl:if test="tenderinfo/quote_count &gt; 0">
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tenderquotes"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/quote_count"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=show_tender_quote&amp;tenderid=',tenderinfo/id)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/list"/>
								</a>
							</td>
						</tr>
					</xsl:if>
			<xsl:choose>
				<xsl:when test="tenderinfo/order_count &gt; 0">
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/purhcaseorders"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderinfo/order_count"/>
							</td>
							<td align="left" colspan="3" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=show_purchase_order&amp;tenderid=',tenderinfo/id)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/list"/>
								</a>
							</td>
						</tr>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="tenderinfo/status = 4">
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/purhcaseorders"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="$lng/none"/>
							</td>
							<td align="left" colspan="3" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=report&amp;function=company&amp;reporttype=tender_group_by_quote&amp;tenderid=',tenderinfo/id,'&amp;organisationid=',tenderinfo/organisation)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/award"/>
								</a>
							</td>
						</tr>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
				<xsl:if test="editable='1'">
					<xsl:if test="tenderinfo/status &lt; 5">
						<tr>
							<td colspan="5"><br/></td>
						</tr>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/edit"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:choose>
									<xsl:when test="tenderinfo/status=2">
										<xsl:value-of select="$lng/closein"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/extendtime"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="left" class="t2" colspan="3">
								<input class="t2" type="text" size="3" name="extendtime" value="0"/>
								<input type="radio" name="extendunit" value="day"/>
								<xsl:value-of select="$lng/days"/>
								<input type="radio" name="extendunit" value="hour"/>
								<xsl:value-of select="$lng/hours"/>
								<input type="radio" name="extendunit" value="minute"/>
								<xsl:value-of select="$lng/minutes"/>
								<xsl:if test="tenderinfo/status=2">
									<input type="radio" name="extendunit" value="now"/>
									<xsl:value-of select="$lng/closenow"/>
								</xsl:if>
							</td>							
						</tr>
						<tr>
							<td><br/></td>
							<td><br/></td>
							<td align="left" class="t2" colspan="3">							
								<input type="radio" name="extendunit" value="date"/>
								<xsl:value-of select="$lng/dateandtime"/>
							</td>
						</tr>	
						<tr>
							<td><br/></td>
							<td><br/></td>
							<td align="left" class="t2" colspan="3">
								<xsl:value-of select="$lng/date"/>
								<xsl:value-of select="' '"/>
								<input type="text" name="tenderdate" id="tenderdate" value="{today}" class="t2" size="10" maxlength="10" onchange="seloption()" />
								<xsl:value-of select="' '"/>
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_startdate" style="cursor: pointer; border: 0px;" alt="Date selector" />
								<xsl:value-of select="'  '"/>
								<xsl:value-of select="$lng/time"/>
								<xsl:value-of select="' '"/>
								<input type="text" name="hour" id="hour" value="{hour}" class="t2" size="1" maxlength="2" onchange="seloption()" />:
								<input type="text" name="min" id="min" value="{min}" class="t2" size="1" maxlength="2" onchange="seloption()" />
							</td>
						</tr>	
					</xsl:if>
				</xsl:if>
						<xsl:if test="editable='1' and tenderinfo/status &lt; 5">
							<tr>
								<td colspan="5"><br/></td>
							</tr>
							<tr>
								<td align="right" width="270" colspan="5">
									<input type="submit" name="changetender" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/submit"/>
										</xsl:attribute>
										<xsl:attribute name="onClick">return dateCheck();</xsl:attribute>
									</input>
									<input type="checkbox" name="deletetender" class="t2" onchange="alertremove()"/>
									<xsl:value-of select="$lng/delete"/>
									<xsl:value-of select="' '"/>
									<select name="notify" class="t2">
										<option value=""><xsl:value-of select="$lng/notifynone"/></option>
										<option value="all"><xsl:value-of select="$lng/notifyall"/></option>
										<option value="notresponded"><xsl:value-of select="$lng/notifynotresponded"/></option>
										<option value="subscriber"><xsl:value-of select="$lng/notifysubscriber"/></option>
									</select>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="right" class="t1">
									<xsl:value-of select="$lng/notifymessage"/>
								</td>
								<td class="t2" colspan="3">
									<textarea name="message" cols="45" rows="2" class="t2"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="tenderinfo/agent">
							<tr colspan="5">
								<td><br/></td>
							</tr>
							<tr>
								<td colspan="5" class="h t1">
									<xsl:value-of select="$lng/agentinfo"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td colspan="4">
									<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
										<tr>
											<td class="h1 t1">
												<xsl:value-of select="$lng/supplier"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/agentname"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/method"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/email"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/phonework"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/phonemobile"/>
											</td>
										<xsl:if test="/response/user/classification='3'">
											<td class="h1a t1">
												<xsl:value-of select="$lng/sendsms"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/message"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/quote"/>
											</td>
										</xsl:if>
										</tr>
									<xsl:for-each select="tenderinfo/agent">
										<tr>
											<td class="h2b t2" align="left" valign="top" nowrap="nowrap">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./organisation)"/>
													</xsl:attribute>
													<xsl:value-of select="suppliername"/>
												</a>
											</td>
											<td class="h2c t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',id)"/>
													</xsl:attribute>
													<xsl:value-of select="name"/>
													<xsl:value-of select="' '"/>
													<xsl:value-of select="surname"/>
												</a>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="method"/>
											</td>
											<td class="h2c t2">
												<a target="main">
													<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="$lng/rfqnumber"/>: <xsl:value-of select="../rfq_number"/></xsl:attribute>
													<xsl:value-of select="email"/>
												</a>
											</td>
											<td class="h2c t2">
												<a>
													<xsl:attribute name="href">
														<xsl:value-of select="'callto://+'"/>
														<xsl:value-of select="phone_prefix"/>
														<xsl:number value="phone_work" format="1"/>
													</xsl:attribute>
													<xsl:value-of select="phone_work"/>
												</a>
											</td>
											<td class="h2c t2">
												<a>
													<xsl:attribute name="href">
														<xsl:value-of select="'callto://+'"/>
														<xsl:value-of select="phone_prefix"/>
														<xsl:number value="phone_mobile" format="1"/>
													</xsl:attribute>
													<xsl:value-of select="phone_mobile"/>
												</a>
											</td>
									<xsl:if test="/response/user/classification='3'">
											<td class="h2c t2">
												<a>
													<xsl:attribute name="href">./main.php?module=messenger&amp;function=utilities&amp;usersid=<xsl:value-of select="usersid"/>&amp;body=<xsl:value-of select="$lng/rfqnumber"/>: <xsl:value-of select="../rfq_number"/></xsl:attribute>
													<img src="./theme/{$theme}/icon/sms.gif" border="0">
														<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/sms"/></xsl:attribute>
													</img>
												</a>
											</td>
											<td class="h2c t2" valign="top">
										<xsl:if test="request_message!='' and request_message!='0'">
												<a>
													<xsl:attribute name="href">./main.php?module=generic&amp;function=message&amp;id=<xsl:value-of select="request_message"/></xsl:attribute>
													<img src="./theme/{$theme}/icon/mail_view.gif" border="0">
														<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/message"/></xsl:attribute>
													</img>
												</a>
											<xsl:if test="/response/user/classification='3'">
												<a onclick="alertsend('{request_message}','{email}')">
													<img src="./theme/{$theme}/icon/resubmit.gif" border="0">
														<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/send"/></xsl:attribute>
													</img>
												</a>
											</xsl:if>
										</xsl:if>
										<xsl:if test="request_message='' or request_message='0'">
												<xsl:value-of select="$lng/none"/>
										</xsl:if>
											</td>
											<td class="h2c t2" align="left" valign="top">
										<xsl:choose>
											<xsl:when test="/response/tenderinfo/status = 6">
												<xsl:value-of select="$lng/completed"/>
											</xsl:when>
											<xsl:when test="/response/tenderinfo/status > 3">	
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=',/response/tenderinfo/classification,'&amp;function=add_quote&amp;usersid=',id,'&amp;tender=',/response/tenderinfo/id)"/>
													</xsl:attribute>
													<xsl:value-of select="$lng/add"/>
												</a>
											</xsl:when>
											<xsl:otherwise>
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=',/response/tenderinfo/classification,'&amp;function=quote&amp;usersid=',id,'&amp;tender=',/response/tenderinfo/id)"/>
													</xsl:attribute>
													<xsl:value-of select="$lng/submit"/>
												</a>
											</xsl:otherwise>
										</xsl:choose>
											</td>
									</xsl:if>
										</tr>
									</xsl:for-each>
									</table>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<xsl:if test="editable='1' and tenderinfo/status &lt; 5">
		<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
		<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
		<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>
		<script type="text/javascript">
			Calendar.setup({inputField:"tenderdate",ifFormat:"%Y-%m-%d",button:"trigger_startdate",singleClick:true});
			function seloption() {			
				var len = document.report.extendunit.length;
				document.report.extendunit[len-1].checked = true; 
			}
		
			function dateCheck() {
				var len = document.report.extendunit.length;
				if(document.report.extendunit[len-1].checked) {
					var datevalue = document.report.tenderdate.value;
					var year = datevalue.substr(0, 4);
					var month = datevalue.substr(5, 2);
					var day = datevalue.substr(8, 2);
					var hour = document.report.hour.value;
					var min = document.report.min.value;
					var dateObj = new Date(year, month-1, day, hour, min);
					var currentdate = new Date();
					if (currentdate >= dateObj) {
						alert("Date and time are invalid.");
						return false;
					} else {
						return true;
					}
				} else {
					return true;
				}	
			}
		</script>		
	</xsl:if>	
	<script language="javascript">
		function alertremove() {	
			var del = document.report.deletetender.checked;
			if(del) {
				if(!confirm("<xsl:value-of select="$lng/alertdeletetender"/>")) {
					document.report.deletetender.checked = false;
				}
			}
		}

		function update() {	
	<xsl:if test="state/stateid">
			var stateIndex = document.report.state.selectedIndex;
			var stateValue = document.report.state.value;
		<xsl:if test="area/areaid">
			var areaSelect = document.report.area;
			var areaOptions = areaSelect.options;
			var counter = 0;
			areaSelect.length = 0;
			areaOptions[counter++] = new Option("<xsl:value-of select="$lng/selectarea"/>","");
			<xsl:for-each select="area">
			if (stateValue == "<xsl:value-of select="./stateid"/>" || stateValue == "0") {
				areaOptions[counter++] = new Option("<xsl:value-of select="areaname"/>","<xsl:value-of select="areaid"/>");
			}
			</xsl:for-each>
		</xsl:if>
	</xsl:if>
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
