<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/authenticate"/><xsl:value-of select="' '"/><xsl:value-of select="$lng/purchaseorder"/>
		</div>
	<xsl:if test="purchase_order/status='2'">
		<div id="header">
			<input class="e readonly" value="{$lng/purchaseorderhasbeencanceled}" name="{$lng/purchaseorderhasbeencanceled}" readonly="" type="text" size="100"/>
		</div>
	</xsl:if>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="purchase_order"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="invalid='1'">
							<tr>
								<td><br/></td>
								<td class="e" align="left">
									<xsl:value-of select="$lng/notvalidpurchaseorder"/>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="invalid='0'">
							<tr>
								<td><br/></td>
								<td class="h t1" align="left" colspan="2">
									<xsl:value-of select="$lng/purchaseorder"/>
								</td>
							</tr>
						<xsl:if test="purchase_order/status='2'">
							<tr>
								<td><br/></td>
								<td class="e" align="left" colspan="2">
									<xsl:value-of select="$lng/purchaseorderhasbeencanceled"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="t1" colspan="2">
									<xsl:value-of select="$lng/reason"/>
									<pre class="e"><xsl:value-of select="purchase_order/reason"/></pre>
								</td>
							</tr>
						</xsl:if>
							<tr>
								<td><br/></td>
								<td class="t1" align="left">
									<xsl:value-of select="$lng/subscriber"/> : 
									<a target="main">
										<!-- check if user is logon -->
										<xsl:if test="online='1'">
											<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',purchase_order/usersid)"/></xsl:attribute>
										</xsl:if>
										<xsl:value-of select="purchase_order/name"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="purchase_order/surname"/>
									</a>
								</td>
								<td class="t1" align="right">
									<input name="print" type="button" value="{$lng/print}" onclick="window.print()" class="t2"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="t1" align="left">
									<xsl:value-of select="$lng/agent"/> :
									<a target="main">
										<!-- check if user is logon -->
										<xsl:if test="online='1'">
											<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',purchase_order/agentid)"/></xsl:attribute>
										</xsl:if>
										<xsl:value-of select="purchase_order/agentname"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="purchase_order/agentsurname"/>
									</a>
									<xsl:value-of select="' '"/>
									<a target="main">
										<!-- check if user is logon -->
										<xsl:if test="online='1'">
											<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',purchase_order/supplierid)"/></xsl:attribute>
										</xsl:if>
										(<xsl:value-of select="purchase_order/suppliername"/>)
									</a>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="t1" align="left">
									<xsl:value-of select="$lng/date"/> :
									<xsl:value-of select="purchase_order/created_date"/><xsl:value-of select="' '"/><xsl:value-of select="purchase_order/created_time"/>
								</td>
							</tr>
							<xsl:if test="online='1' and link">
								<xsl:for-each select="link">
									<tr>
										<td><br/></td>
										<td class="t1" align="left">
											<a href="./{frame}.php?module={module}&amp;function={function}" target="{frame}">
												<xsl:value-of select="name"/>
											</a>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:if>
							<tr>
								<td><br/></td>
								<td class="h1 t1" align="left" colspan="2">
									<xsl:value-of select="$lng/conditions"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="t1" align="left" colspan="2">
									<xsl:value-of select="$lng/purchaseordercorrect"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="t2" align="left" colspan="2">
									<ul>
										<li><xsl:value-of select="$lng/urlattop"/><xsl:value-of select="url"/></li>
										<li><xsl:value-of select="$lng/purchaseordermatch"/></li>
										<li><xsl:value-of select="$lng/lockbelow"/></li>
										<li><xsl:value-of select="$lng/certifiedby"/></li>
									</ul>
								</td>
							</tr>
							<xsl:if test="purchase_order/old='t' or purchase_order/old='1'">
								<tr>
									<td><br/></td>
									<td class="e" align="left" colspan="2">
										<xsl:value-of select="$lng/twodaysold"/><br/>
										<xsl:value-of select="$lng/contactnow"/>
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td><br/></td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="h1 t1" align="left" colspan="2">
									<xsl:value-of select="$lng/subject"/> :
									&lt;<xsl:value-of select="purchase_order/subject"/>&gt;
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td colspan="4">
									<xsl:value-of disable-output-escaping="yes" select="string(purchase_order/body)"/>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>