<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="./procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderquoteprofile"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="quote_profile"/>
					<input type="hidden" name="id" value="{tenderquoteinfo/id}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
					<xsl:if test="updated='1'">
						<tr>
							<td colspan="4" class="t1">
								<xsl:value-of select="$lng/updated"/>						
							</td>
						</tr>
					</xsl:if>
						<tr>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/tenderinfo"/>:
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderquoteinfo/tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderquoteinfo/rfq_number"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderquoteinfo/tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderquoteinfo/rfq_number"/>
								</a>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/rfq_reference"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/statename"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/areaname"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:call-template name="tender_icon">
									<xsl:with-param name="classification" select="tenderquoteinfo/tenderclassification"/>
									<xsl:with-param name="status" select="tenderquoteinfo/tenderstatus"/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/tenderiteminfo"/>:
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',tenderquoteinfo/tenderitemid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderquoteinfo/tenderitemid"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/tenderitem"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',tenderquoteinfo/tenderitemid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderquoteinfo/tenderitemid"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/classification"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/classification"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/category"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/categoryname"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/category_sub"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/category_subname"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/areaname"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/itembrand"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/itemmodel"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1" valign="top">
								<xsl:value-of select="$lng/description"/>
							</td>
							<td align="left" class="t2">
								<pre class="t2">
									<xsl:value-of select="tenderquoteinfo/itemdescription"/>
								</pre>
							</td>
							<td align="left" class="t1" valign="top">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" class="t2" valign="top">
								<xsl:call-template name="tender_item_icon">
									<xsl:with-param name="classification" select="tenderquoteinfo/classification"/>
									<xsl:with-param name="status" select="tenderquoteinfo/status"/>
									<xsl:with-param name="completestatus" select="tenderquoteinfo/complete_status"/>
									<xsl:with-param name="tenderclassification" select="tenderquoteinfo/tenderclassification"/>
								</xsl:call-template>
							</td>
						</tr>
						<xsl:if test="tenderquoteinfo/itemstatus='6'">
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/completedate"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<xsl:value-of select="tenderquoteinfo/complete_date"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderquoteinfo/complete_time"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="localdisplay"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td><br/></td>
							<td colspan="5" class="h t1">
								<xsl:value-of select="$lng/tenderquoteinfo"/>:
								<xsl:value-of select="tenderquoteinfo/id"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/agentname"/>
							</td>
							<td align="left" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',tenderquoteinfo/usersid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderquoteinfo/name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderquoteinfo/surname"/>
								</a>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/method"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="tenderquoteinfo/method"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="brand" class="t2" value="{tenderquoteinfo/brand}">
									<xsl:if test="editable='0' or (tenderquoteinfo/status!='2' and tenderquoteinfo/status!='4')">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="model" class="t2" value="{tenderquoteinfo/model}">
									<xsl:if test="editable='0' or (tenderquoteinfo/status!='2' and tenderquoteinfo/status!='4')">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1" valign="top">
								<xsl:value-of select="$lng/description"/>
							</td>
							<td align="left" class="t2">
								<textarea type="text" name="description" class="t2" cols="40">
									<xsl:if test="editable='0' or (tenderquoteinfo/status!='2' and tenderquoteinfo/status!='4')">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
									<xsl:value-of select="tenderquoteinfo/description"/>
								</textarea>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/price"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="price" class="t2" size="8" value="{tenderquoteinfo/price}">
									<xsl:if test="editable='0' or (tenderquoteinfo/status!='2' and tenderquoteinfo/status!='4')">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/stock"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="stock" class="t2" size="2" value="{tenderquoteinfo/stock}">
									<xsl:if test="editable='0' or (tenderquoteinfo/status!='2' and tenderquoteinfo/status!='4')">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/days"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/validuntil"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="valid_until" class="t2" size="12" value="{tenderquoteinfo/valid_until}">
									<xsl:if test="editable='0' or (tenderquoteinfo/status!='2' and tenderquoteinfo/status!='4')">
										<xsl:attribute name="readonly"/>
										<xsl:attribute name="class">t2 readonly</xsl:attribute>
									</xsl:if>
								</input>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" class="t2">
								<xsl:call-template name="tender_quote_icon">
									<xsl:with-param name="classification" select="tenderquoteinfo/quoteclass"/>
									<xsl:with-param name="status" select="tenderquoteinfo/status"/>
									<xsl:with-param name="tenderclassification" select="tenderquoteinfo/tenderclassification"/>
									<xsl:with-param name="itemclassification" select="tenderquoteinfo/classification"/>
								</xsl:call-template>
								<xsl:if test="tenderquoteinfo/error!=''">
									<textarea type="text" class="t2 readonly" cols="30" readonly="readonly">
										<xsl:value-of select="tenderquoteinfo/error"/>
									</textarea>
								</xsl:if>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/position"/>
							</td>
							<td align="left" class="t2">
								<xsl:call-template name="position_icon">
									<xsl:with-param name="position" select="tenderquoteinfo/quote_position"/>
								</xsl:call-template>
							</td>	
						</tr>
						<tr>
							<td><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td align="left"  class="t2">
								<xsl:value-of select="tenderquoteinfo/created_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderquoteinfo/created_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="localdisplay"/>
							</td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/createdby"/>
							</td>
							<td align="left" colspan="3" class="t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',tenderquoteinfo/creatorid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderquoteinfo/creatorname"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderquoteinfo/creatorsurname"/>
								</a>
							</td>
						</tr>
						<xsl:if test="editable='1' and (tenderquoteinfo/status='2' or tenderquoteinfo/status='4')">
							<tr>
								<td align="right" colspan="6">
									<input type="submit" name="changetender" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/submit"/>
										</xsl:attribute>
									</input>
									<input type="checkbox" name="notify" class="t2"/>
									<xsl:value-of select="$lng/notify"/>
									<input type="checkbox" name="delete" class="t2"/>
									<xsl:value-of select="$lng/delete"/>
								<xsl:if test="tenderquoteinfo/quoteclass='5'">
									<input type="checkbox" name="classification" value="1" class="t2"/>
									<xsl:value-of select="$lng/addlatequote"/>
								</xsl:if>
								</td>
							</tr>
							<tr>
								<td></td>
								<td align="right" class="t1">
									<xsl:value-of select="$lng/notifymessage"/>
								</td>
								<td class="t2" align="left" colspan="5">
									<textarea name="message" cols="60" rows="3" class="t2"/>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script language="javascript">
		function alertremove() {	
			var del = document.report.deletetender.checked;
			if(del) {
				if(!confirm("<xsl:value-of select="$lng/alertdeletetender"/>")) {
					document.report.deletetender.checked = false;
				}
			}
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
