<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="./procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderquoteprofile"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="quote_profile"/>
					<input type="hidden" name="id" value="{tenderquoteinfo/id}"/>
					<xsl:for-each select="tenderquoteinfo">
						<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="updated='1'">
							<tr>
								<td colspan="4" class="t1">
									<xsl:value-of select="$lng/updated"/>						
								</td>
							</tr>
						</xsl:if>
							<tr>
								<td colspan="5" class="h t1">
									<xsl:value-of select="$lng/tenderinfo"/>:
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderid)"/>
										</xsl:attribute>
										<xsl:value-of select="rfq_number"/>
									</a>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td align="left" class="t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',tenderid)"/>
										</xsl:attribute>
										<xsl:value-of select="rfq_number"/>
									</a>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/rfqreference"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="rfq_reference"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/state"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="statename"/>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/area"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="areaname"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/status"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<xsl:call-template name="tender_icon">
										<xsl:with-param name="classification" select="tenderclassification"/>
										<xsl:with-param name="status" select="tenderstatus"/>
									</xsl:call-template>
								</td>
							</tr>
							<tr>
								<td colspan="2"><br/></td>
							</tr>
							<tr>
								<td><br/></td>
								<td colspan="5" class="h t1">
									<xsl:value-of select="$lng/tenderiteminfo"/>:
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',tenderitemid)"/>
										</xsl:attribute>
										<xsl:value-of select="tenderitemid"/>
									</a>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/tenderitem"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',tenderitemid)"/>
										</xsl:attribute>
										<xsl:value-of select="tenderitemid"/>
									</a>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/classification"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="classification"/>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/category"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="categoryname"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/category_sub"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="category_subname"/>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/area"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="areaname"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/brand"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="itembrand"/>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/model"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="itemmodel"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1" valign="top">
									<xsl:value-of select="$lng/description"/>
								</td>
								<td align="left" class="t2">
									<pre class="t2">
										<xsl:value-of select="itemdescription"/>
									</pre>
								</td>
								<td align="left" class="t1" valign="top">
									<xsl:value-of select="$lng/status"/>
								</td>
								<td align="left" class="t2" valign="top">
									<xsl:call-template name="tender_item_icon">
										<xsl:with-param name="classification" select="classification"/>
										<xsl:with-param name="status" select="status"/>
										<xsl:with-param name="completestatus" select="complete_status"/>
										<xsl:with-param name="tenderclassification" select="tenderclassification"/>
									</xsl:call-template>
								</td>
							</tr>
							<xsl:if test="itemstatus='6'">
								<tr>
									<td><br/></td>
									<td align="left" class="t1">
										<xsl:value-of select="$lng/completedate"/>
									</td>
									<td align="left" colspan="2" class="t2">
										<xsl:value-of select="complete_date"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="complete_time"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="localdisplay"/>
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td><br/></td>
								<td colspan="5" class="h t1">
									<xsl:value-of select="$lng/tenderquoteinfo"/>:
									<xsl:value-of select="id"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/agentname"/>
								</td>
								<td align="left" class="t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',usersid)"/>
										</xsl:attribute>
										<xsl:value-of select="name"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="surname"/>
									</a>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/method"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="method"/>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/brand"/>
								</td>
								<td align="left" class="t2">
									<input type="text" name="brand[{id}]" class="t2" value="{brand}">
										<xsl:if test="editable='0' or (status!='2' and status!='4')">
											<xsl:attribute name="readonly"/>
											<xsl:attribute name="class">t2 readonly</xsl:attribute>
										</xsl:if>
									</input>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/model"/>
								</td>
								<td align="left" class="t2">
									<input type="text" name="model[{id}]" class="t2" value="{model}">
										<xsl:if test="editable='0' or (status!='2' and status!='4')">
											<xsl:attribute name="readonly"/>
											<xsl:attribute name="class">t2 readonly</xsl:attribute>
										</xsl:if>
									</input>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1" valign="top">
									<xsl:value-of select="$lng/description"/>
								</td>
								<td align="left" class="t2">
									<textarea type="text" name="description[{id}]" class="t2" cols="40">
										<xsl:if test="editable='0' or (status!='2' and status!='4')">
											<xsl:attribute name="readonly"/>
											<xsl:attribute name="class">t2 readonly</xsl:attribute>
										</xsl:if>
										<xsl:value-of select="description"/>
									</textarea>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/price"/>
								</td>
								<td align="left" class="t2">
									<input type="text" name="price[{id}]" class="t2" size="8" value="{price}">
										<xsl:if test="editable='0' or (status!='2' and status!='4')">
											<xsl:attribute name="readonly"/>
											<xsl:attribute name="class">t2 readonly</xsl:attribute>
										</xsl:if>
									</input>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/stock"/>
								</td>
								<td align="left" class="t2">
									<input type="text" name="stock[{id}]" class="t2" size="2" value="{stock}">
										<xsl:if test="editable='0' or (status!='2' and status!='4')">
											<xsl:attribute name="readonly"/>
											<xsl:attribute name="class">t2 readonly</xsl:attribute>
										</xsl:if>
									</input>
									<xsl:value-of select="$lng/days"/>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/validuntil"/>
								</td>
								<td align="left" class="t2">
									<input type="text" name="date[{id}]" class="t2" size="12" value="{valid_until}">
										<xsl:if test="editable='0' or (status!='2' and status!='4')">
											<xsl:attribute name="readonly"/>
											<xsl:attribute name="class">t2 readonly</xsl:attribute>
										</xsl:if>
									</input>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/status"/>
								</td>
								<td align="left" class="t2">
									<xsl:call-template name="tender_quote_icon">
										<xsl:with-param name="classification" select="quoteclass"/>
										<xsl:with-param name="status" select="status"/>
										<xsl:with-param name="tenderclassification" select="tenderclassification"/>
										<xsl:with-param name="itemclassification" select="classification"/>
									</xsl:call-template>
									<xsl:if test="error!=''">
										<textarea type="text" class="t2 readonly" cols="30" readonly="readonly">
											<xsl:value-of select="error"/>
										</textarea>
									</xsl:if>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/position"/>
								</td>
								<td align="left" class="t2">
									<xsl:call-template name="position_icon">
										<xsl:with-param name="position" select="quote_position"/>
									</xsl:call-template>
								</td>	
							</tr>
							<tr>
								<td><br/></td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/createdon"/>
								</td>
								<td align="left"  class="t2">
									<xsl:value-of select="created_date"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="created_time"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="localdisplay"/>
								</td>
								<td align="left" class="t1">
									<xsl:value-of select="$lng/createdby"/>
								</td>
								<td align="left" colspan="3" class="t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',creatorid)"/>
										</xsl:attribute>
										<xsl:value-of select="creatorname"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="creatorsurname"/>
									</a>
								</td>
							</tr>
							<xsl:if test="editable='1' and (status='2' or status='4')">
								<tr>
									<td align="right" colspan="6">
										<input type="checkbox" name="notify[{id}]" class="t2"/>
										<xsl:value-of select="$lng/notify"/>
										<input type="checkbox" name="delete[{id}]" class="t2"/>
										<xsl:value-of select="$lng/delete"/>
									<xsl:if test="quoteclass='5'">
										<input type="checkbox" name="classification[{id}]" value="1" class="t2"/>
										<xsl:value-of select="$lng/addlatequote"/>
									</xsl:if>
									</td>
								</tr>
								<tr>
									<td></td>
									<td align="right" class="t1">
										<xsl:value-of select="$lng/notifymessage"/>
									</td>
									<td class="t2" align="left" colspan="5">
										<textarea name="message[{id}]" cols="60" rows="3" class="t2"/>
									</td>
								</tr>
							</xsl:if>
						</table>
						<br/>
						<br/>
					</xsl:for-each>
					<xsl:if test="editable='1'">
						<input type="submit" name="changeall" class="t2">
							<xsl:attribute name="value">
								<xsl:value-of select="$lng/submitall"/>
							</xsl:attribute>
						</input>
					</xsl:if>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script language="javascript">
		function alertremove() {	
			var del = document.report.deletetender.checked;
			if(del) {
				if(!confirm("<xsl:value-of select="$lng/alertdeletetender"/>")) {
					document.report.deletetender.checked = false;
				}
			}
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>

