<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/procuresettings"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="settings"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/changedsuccess"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/procureautorfqenable"/>
							<xsl:with-param name="input_name" select="'procureautorfqenable'"/>
							<xsl:with-param name="input_value" select="settings/procureautorfqenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/procureautorfqsetting"/>
							</td>
							<td align="left" class="t2">
								<select class="t2" name="rfqformatselector" onchange="changerfqformat()">
									<option value="{settings/tenderautorfqsetting}">--</option>
									<option value="[u]-[ui]">{<xsl:value-of select="$lng/username"/>}-{<xsl:value-of select="$lng/userinc"/>}</option>
									<option value="[b]-[bi]">{<xsl:value-of select="$lng/branchname"/>}-{<xsl:value-of select="$lng/branchinc"/>}</option>
									<option value="[o]-[oi]">{<xsl:value-of select="$lng/organisationname"/>}-{<xsl:value-of select="$lng/organisationinc"/>}</option>
									<option value="[d]-[di]">{<xsl:value-of select="$lng/date"/>}-{<xsl:value-of select="$lng/dateinc"/>}</option>
									<option value="[uu]-[ti]">{<xsl:value-of select="$lng/userid"/>}-{<xsl:value-of select="$lng/tenderid"/>}</option>
									<option value="[bb]-[ii]">{<xsl:value-of select="$lng/branchid"/>}-{<xsl:value-of select="$lng/tenderitemid"/>}</option>
									<option value="[oo]-[ts]">{<xsl:value-of select="$lng/organisationid"/>}-{<xsl:value-of select="$lng/timestamp"/>}</option>
									<option value="zeropad([ui])length(5)">{<xsl:value-of select="$lng/userincpadded"/>}</option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								
							</td>
							<td align="left" class="t2">
								<input type="text" name="procureautorfqsetting" size="40" class="t2" value="{settings/procureautorfqsetting}"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/procuretenderadminlog"/>
							</td>
							<td align="left" class="t2">
								<input name="procuretenderadminlog" value="{settings/procuretenderadminlog}" size="3"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/procureattachmentenable"/>
							<xsl:with-param name="input_name" select="'procureattachmentenable'"/>
							<xsl:with-param name="input_value" select="settings/procureattachmentenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/procuresupplierrequired"/>
							<xsl:with-param name="input_name" select="'procuresupplierrequired'"/>
							<xsl:with-param name="input_value" select="settings/procuresupplierrequired"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/procureapproveenable"/>
							<xsl:with-param name="input_name" select="'procureapproveenable'"/>
							<xsl:with-param name="input_value" select="settings/procureapproveenable"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/procureapproveemail"/>
							<xsl:with-param name="input_name" select="'procureapproveemail'"/>
							<xsl:with-param name="input_value" select="settings/procureapproveemail"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/procureapproveurl"/>
							</td>
							<td align="left" class="t2">
								<input type="text" name="procureapproveurl" size="40" class="t2" value="{settings/procureapproveurl}"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/procureclientphoneprefix"/>
							<xsl:with-param name="input_name" select="'procureclientphone_prefix'"/>
							<xsl:with-param name="input_value" select="settings/procureclientphone_prefix"/>
							<xsl:with-param name="true" select="$lng/yes"/>
							<xsl:with-param name="false" select="$lng/no"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/procurequoteduplicatecompare"/>
							</td>
							<td align="left" class="t2">
								<select class="t2" name="procurequoteduplicatecompare">
									<option value="1"><xsl:value-of select="$lng/procurequoteduplicatecompare1"/></option>
									<option value="2">
										<xsl:if test="settings/procurequoteduplicatecompare='2'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequoteduplicatecompare2"/>
									</option>
									<option value="3">
										<xsl:if test="settings/procurequoteduplicatecompare='3'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequoteduplicatecompare3"/>
									</option>
									<option value="4">
										<xsl:if test="settings/procurequoteduplicatecompare='4'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequoteduplicatecompare4"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/procurequoteduplicatekeep"/>
							</td>
							<td align="left" class="t2">
								<select class="t2" name="procurequoteduplicatekeep">
									<option value="a">
										<xsl:value-of select="$lng/procurequoteduplicatekeep0"/>
									</option>
									<option value="f">
										<xsl:if test="settings/procurequoteduplicatekeep='f'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequoteduplicatekeep1"/>
									</option>
									<option value="l">
										<xsl:if test="settings/procurequoteduplicatekeep='l'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequoteduplicatekeep2"/>
									</option>
									<option value="i">
										<xsl:if test="settings/procurequoteduplicatekeep='i'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequoteduplicatekeep3"/>
									</option>
									<option value="e">
										<xsl:if test="settings/procurequoteduplicatekeep='e'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequoteduplicatekeep4"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/procurequotepositionprimary"/>
							</td>
							<td align="left" class="t2">
								<select class="t2" name="procurequotepositionprimary">
									<option value="p">
										<xsl:value-of select="$lng/procurequotepositionprimary1"/>
									</option>
									<option value="t">
										<xsl:if test="settings/procurequotepositionprimary='t'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequotepositionprimary4"/>
									</option>
									<option value="s">
										<xsl:if test="settings/procurequotepositionprimary='s'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequotepositionprimary5"/>
									</option>
									<option value="v">
										<xsl:if test="settings/procurequotepositionprimary='v'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequotepositionprimary6"/>
									</option>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/procurequotepositionsecondary"/>
							</td>
							<td align="left" class="t2">
								<select class="t2" name="procurequotepositionsecondary">
									<option value="p">
										<xsl:value-of select="$lng/procurequotepositionprimary1"/>
									</option>
									<option value="t">
										<xsl:if test="settings/procurequotepositionsecondary='t'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequotepositionprimary4"/>
									</option>
									<option value="s">
										<xsl:if test="settings/procurequotepositionsecondary='s'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequotepositionprimary5"/>
									</option>
									<option value="v">
										<xsl:if test="settings/procurequotepositionsecondary='v'">
											<xsl:attribute name="selected"/>
										</xsl:if>
										<xsl:value-of select="$lng/procurequotepositionprimary6"/>
									</option>
								</select>
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/procuresettinginstruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function changerfqformat() {
			document.report.procureautorfqsetting.value = document.report.rfqformatselector.value;
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
