<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/purchaseorders"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="show_phurchase_order"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="600" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/purchaseorder"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/agent"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/subscriber"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/createdby"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/message"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/status"/>
							</td>
						<xsl:if test="user/classification='3'">
							<td class="ha t1">
								<xsl:value-of select="$lng/action"/>
							</td>							
						</xsl:if>
						</tr>
						<xsl:if test="purchase_order/id">
							<xsl:for-each select="purchase_order">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=authenticate_purchase_order&amp;auth_string=',authentication,'&amp;tenderid=',tenderid,'&amp;language=',/response/user/language)"/>
											</xsl:attribute>
											<xsl:value-of select="id"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./agentid)"/>
											</xsl:attribute>
											<xsl:value-of select="agentname"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="agentsurname"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="surname"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="created_date"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="created_time"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="../localdisplay"/>
									</td>
									<td class="h2c t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./created_by)"/>
											</xsl:attribute>
											<xsl:value-of select="cname"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="csurname"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="agent_message"/>
									</td>
									<td class="h2c t2" align="center">
									<xsl:choose>
										<xsl:when test="status='1'">
											<xsl:value-of select="$lng/good"/>
										</xsl:when>
										<xsl:when test="status='2'">
											<xsl:value-of select="$lng/canceled"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$lng/unknown"/>
										</xsl:otherwise>
									</xsl:choose>
									</td>
								<xsl:if test="../user/classification='3' and status='1'">
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=cancel_purchase_order&amp;id=',./id)"/>
											</xsl:attribute>
											<xsl:value-of select="$lng/cancel"/>
										</a>
										
									</td>							
								</xsl:if>
								<xsl:if test="../user/classification='3' and status='2'">
									<td class="h2c t2">
										<xsl:value-of select="$lng/none"/>
									</td>							
								</xsl:if>
								</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td class="h2b" colspan="11">
									<xsl:if test="display &gt; 0">
										<xsl:variable name="previous" select="display - 1"/>
										<a href="main.php?module=procure&amp;function=show_purchase_order&amp;displaypage={$previous}&amp;id={id}&amp;tenderitemid={tenderitemid}&amp;tenderid={tenderid}">
											<img src="./theme/{$theme}/icon/left.gif" border="0" alt="Previous" hspace="1" align="absmiddle"/>
										</a>
									</xsl:if>
									<xsl:if test="more='1'">
										<xsl:variable name="next" select="display + 1"/>
										<a href="main.php?module=procure&amp;function=show_purchase_order&amp;displaypage={$next}&amp;id={id}&amp;tenderitemid={tenderitemid}&amp;tenderid={tenderid}">
											<img src="./theme/{$theme}/icon/right.gif" border="0" alt="Next" hspace="1" align="absmiddle" />
										</a>
									</xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
