<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>
<xsl:include href="../../procure/templates/procure_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenders"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'procure'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="procure"/>
					<input type="hidden" name="function" value="show_tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h t1">#</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/classification"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/subscriber"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/closeon"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/timeleft"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/items"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/quotes"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/status"/>
							</td>
						</tr>
						<xsl:if test="tender/tenderid">
							<xsl:for-each select="tender">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="left">
										<xsl:value-of select="tenderid"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="classification"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="rfq_number"/><br/>
										<xsl:value-of select="rfq_reference"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:value-of select="user_name"/><br/>
										<xsl:value-of select="user_surname"/>
									</td>
									<td class="h2c t2" align="left" nowrap="nowrap">
										<xsl:value-of select="areaname"/><br/>
										(<xsl:call-template name="transport_value">
											<xsl:with-param name="transport" select="transport"/>
										</xsl:call-template>)
									</td>
									<td class="h2c t2" align="left" nowrap="nowrap">
										<xsl:value-of select="created_date"/><br/>
										<xsl:value-of select="created_time"/>
									</td>
									<td class="h2c t2" align="left" nowrap="nowrap">
										<xsl:value-of select="close_date"/><br/>
										<xsl:value-of select="close_time"/>
									</td>
					<xsl:choose>
						<xsl:when test="seconds_left and close_time!=''">
							<xsl:choose>
								<xsl:when test="seconds_left &lt; 0">
									<td class="h2c e" align="left">
										<xsl:value-of select="$lng/none"/>
										<xsl:value-of select="'('"/>
										<xsl:value-of select="$lng/closing"/>
										<xsl:value-of select="')'"/>
									</td>
								</xsl:when>
								<xsl:when test="seconds_left &lt; 900">
									<td class="h2c e" align="left">
										<xsl:value-of select="format-number(floor(seconds_left div 3600),'00')"/>:<xsl:value-of select="format-number(floor((seconds_left mod 3600) div 60),'00')"/>:<xsl:value-of select="format-number(floor((seconds_left mod 3600) mod 60),'00')"/>
									</td>
								</xsl:when>
								<xsl:when test="seconds_left &lt; 1800">
									<td class="h2c t1" align="left">
										<xsl:value-of select="format-number(floor(seconds_left div 3600),'00')"/>:<xsl:value-of select="format-number(floor((seconds_left mod 3600) div 60),'00')"/>:<xsl:value-of select="format-number(floor((seconds_left mod 3600) mod 60),'00')"/>
									</td>
								</xsl:when>
								<xsl:when test="seconds_left &lt; 86401">
									<td class="h2c t2" align="left">
										<xsl:value-of select="format-number(floor(seconds_left div 3600),'00')"/>:<xsl:value-of select="format-number(floor((seconds_left mod 3600) div 60),'00')"/>:<xsl:value-of select="format-number(floor((seconds_left mod 3600) mod 60),'00')"/>
									</td>
								</xsl:when>
								<xsl:otherwise>
									<td class="h2c t2" align="left">
										<xsl:value-of select="floor(seconds_left div 86400)"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="$lng/days"/><br/>
										<xsl:value-of select="format-number(floor((seconds_left mod 86400) div 3600),'00')"/>:<xsl:value-of select="format-number(floor(((seconds_left mod 86400) mod 3600) div 60),'00')"/>:<xsl:value-of select="format-number(floor(((seconds_left mod 86400) mod 3600) mod 60),'00')"/>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="status=4">
							<td class="h2c t2" align="left">
								<xsl:value-of select="$lng/closed"/>
							</td>
						</xsl:when>
						<xsl:when test="status=6">
							<td class="h2c t2" align="left">
								<xsl:value-of select="$lng/completed"/>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td class="h2c t2" align="left">
								<xsl:value-of select="$lng/na"/>
							</td>
						</xsl:otherwise>
					</xsl:choose>
									<td class="h2c t2" align="left">
										<a target="main">
											<xsl:if test="tenderitemcount > 0">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=procure&amp;function=show_tender_item&amp;tenderid=',./tenderid)"/>
												</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="tenderitemcount"/>
										</a>
									</td>
									<td class="h2c t2" align="left">
										<a target="main">
											<xsl:if test="tenderquotecount > 0">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=procure&amp;function=show_tender_quote&amp;tenderid=',./tenderid)"/>
												</xsl:attribute>
											</xsl:if>
											<xsl:value-of select="tenderquotecount"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
											</xsl:attribute>
											<xsl:call-template name="tender_icon">
												<xsl:with-param name="classification" select="classification"/>
												<xsl:with-param name="status" select="status"/>
											</xsl:call-template>
										</a>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td class="h2b" colspan="8">
									<xsl:if test="display &gt; 0">
										<xsl:variable name="previous" select="display - 1"/>
										<a href="main.php?module=procure&amp;function=show_tender&amp;displaypage={$previous}&amp;tenderstatus={tenderstatus}">
											<img src="./theme/{$theme}/icon/left.gif" border="0" alt="Previous" hspace="1" align="absmiddle"/>
										</a>
									</xsl:if>
									<xsl:if test="more='1'">
										<xsl:variable name="next" select="display + 1"/>
										<a href="main.php?module=procure&amp;function=show_tender&amp;displaypage={$next}&amp;tenderstatus={tenderstatus}">
											<img src="./theme/{$theme}/icon/right.gif" border="0" alt="Next" hspace="1" align="absmiddle" />
										</a>
									</xsl:if>
								</td>
								<td class="h2c" colspan="3" align="right">
									<form enctype="multipart/form-data" action="main.php" method="post" name="report">
										<input type="hidden" name="module" value="procure"/>
										<input type="hidden" name="function" value="show_tender"/>
										<input type="hidden" name="tenderstatus" value="{tenderstatus}"/>
										<input type="submit" value="{$lng/refresh}" class="t2"/>
									</form>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
