<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Create organisation
* @package TenderSystem
* @subpackage public
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'createorg'	=> array()		
);
get_request($fields_request,$action,$error,$cfg);
if($action['createorg']) {
	// field request errors and type 
	$fields_request = array (
		'organisationname'			=> array("e16",	REQUEST_ANY,		FORMAT_UCWORDS),
		'registered_name'			=> array("e17",	REQUEST_ANY,		FORMAT_NONE),
		'classification'			=> array("e14",	REQUEST_NUMBER,		FORMAT_NONE,		"e15"),
		'transaction_fee'			=> array("e18",	REQUEST_PERCENTAGE,	FORMAT_NONE,		"e19"),
		'transaction_min'			=> array("e20",	REQUEST_MONEY,		FORMAT_MONEY,		"e21"),
		'vat_number'				=> array("e22"),
		'registration_number'		=> array("e23"),
		'user_fee'					=> array("e24",	REQUEST_MONEY,		FORMAT_MONEY,		"e25"),
		'sms_fee'					=> array("e26",	REQUEST_MONEY,		FORMAT_MONEY,		"e27"),
		'repusername'				=> array("e29",	REQUEST_USERNAME,	FORMAT_USERNAME,	"e30"),
		'repname'					=> array("e31",	REQUEST_ANY,		FORMAT_UCWORDS),
		'repsurname'				=> array("e32",	REQUEST_ANY,		FORMAT_UCWORDS),
		'repphone_work'				=> array("e33",	REQUEST_PHONE,		FORMAT_PHONE,		"e34"),
		'repphone_prefix'			=> array("e35",	REQUEST_NUMBER,		FORMAT_NONE,		"e36"),
		'repphone_fax'				=> array("e37",	REQUEST_PHONE,		FORMAT_PHONE,		"e38"),
		'repphone_mobile'			=> array("e39",	REQUEST_PHONE,		FORMAT_PHONE,		"e40"),
		'repemail'					=> array("e41",	REQUEST_EMAIL,		FORMAT_NONE,		"e42"),
		'reppreference'				=> array("e43",	REQUEST_CHAR,		FORMAT_NONE,		"e44"),
		'reppermission'				=> array("e45",	REQUEST_NUMBER,		FORMAT_NONE,		"e46"),
		'reptheme'					=> array("e47",	REQUEST_THEME,		FORMAT_NONE,		"e48"),
		'replang'					=> array("e49",	REQUEST_LANG,		FORMAT_NONE,		"e50"),
		'repposition'				=> array("e51",	REQUEST_ANY,		FORMAT_UCWORDS),
		'repmandate'				=> array(),
		'branchname'				=> array("e52",	REQUEST_ANY,		FORMAT_UCWORDS),
		'branchphone_work'			=> array("e53",	REQUEST_PHONE,		FORMAT_PHONE,		"e54"),
		'branchphone_fax'			=> array("e55",	REQUEST_PHONE,		FORMAT_PHONE,		"e56"),
		'branchphone_prefix'		=> array("e57",	REQUEST_NUMBER,		FORMAT_NONE,		"e58"),
		'branchemail'				=> array("e59",	REQUEST_EMAIL,		FORMAT_NONE,		"e60"),
		'branchcomment'				=> array("e61"),
		'primary_address_street'	=> array("e62"),
		'primary_address_city'		=> array("e63",	REQUEST_ANY,		FORMAT_UCWORDS),
		'primary_address_state'		=> array("e64",	REQUEST_ANY,		FORMAT_UCWORDS),
		'primary_address_postalcode'=> array("e65"),
		'address_country'			=> array("e66",	REQUEST_ANY,		FORMAT_UCWORDS),
		'alt_address_street'		=> array("e67"),
		'alt_address_city'			=> array("e68",	REQUEST_ANY,		FORMAT_UCWORDS),
		'alt_address_state'			=> array("e69",	REQUEST_ANY,		FORMAT_UCWORDS),
		'alt_address_postalcode'	=> array("e70"),
		'areaselect'				=> array(),
		'category_sub'				=> array(),
		'rating'					=> array("e71",	REQUEST_CHAR,		FORMAT_UCWORDS,		"e59")
	);
	// get data
	if(get_request($fields_request,$currentinfo[0],$error,$cfg)) {
		$params = array(
			'module'			=> 'public',
			'function'			=> 'create',
			'currentinfo'		=> $currentinfo,
			'classification'	=> $currentinfo[0]['classification']
		);
		// get the themes
		$params['theme'] = get_themes();
		// get the languages
		$params['language'] = get_languages();
		// send the message to app
		send_message($params,$cfg);
	} else {
		xml_generator("public","error",$error,$params,$cfg);	
	}
}
?>