<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/viewbycategory"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'public'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="public"/>
					<input type="hidden" name="function" value="category"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<xsl:if test="updated='1'">
							<tr>
								<td colspan="2" class="t1">
									<xsl:value-of select="$lng/updated"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td class="h t1">
									<xsl:value-of select="$lng/categories"/>
							</td>
							<td class="ha t1" align="left">
							</td>
						</tr>
						<xsl:for-each select="category">
							<tr>
								<td class="h1b t1">
									<xsl:value-of select="categoryname"/>
								</td>
								<td class="h1c t1" align="right">
									<a href="main.php?module=public&amp;function=show_tender_item&amp;category={categoryid}">
									<xsl:value-of select="item_count"/>
									</a>
								</td>
							</tr>
							<xsl:attribute name="id">site<xsl:value-of select="categoryid"/>div</xsl:attribute>
							<xsl:variable name="currentid" select="categoryid"/>
							<xsl:for-each select="../subcategory">
								<xsl:if test="categoryid=$currentid">
									<tr>
										<td class="h2b t2">
											<xsl:value-of select="category_subname"/>
										</td>
										<td class="h2c t2" align="right">
											<a href="main.php?module=public&amp;function=show_tender_item&amp;category_sub={category_subid}">
											<xsl:value-of select="item_count"/>
											</a>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each> 
						</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">

	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
