<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer_left.xsl"/>
<!-- category java script -->
<xsl:include href="../../category/templates/category_script.xsl"/>

<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/menu.css"/>
		<style type="text/css">
			html, body {height: 98%; margin: 0; border: none; text-align: left; font-family: arial, helvetica, sans-serif;  font-size: 11px; color: #000066; white-space: nowrap;}
			#wrapper {height: 78%; background-color: #FFFFFF; align: left; padding-left: 2px; padding-top: 2px;}
		</style>
	</head>
<body>
	<table id="wrapper" height="100%" border="0" align="center" cellpadding="2" cellspacing="0" width="100">
		<tr>
			<td align="left" valign="top" width="100">
				<div id="left">
					<form enctype="multipart/form-data" action="left.php?module=useradmin&amp;function=search" method="post" name="report">
						<table border="0" align="left" cellpadding="0" cellspacing="1" width="100%" bgcolor="FFFFFF">
							<tr>
								<td class="t1">
									<xsl:value-of select="$lng/category"/>
								</td>
							</tr>
							<tr>
								<td class="t2">
									<select name="category" class="t1" onchange="update_category()">
                                        <option value="0"><xsl:value-of select="$lng/selectcategory"/></option>
                                        <xsl:for-each select="category">
                                            <option value="{categoryid}">
                                                <xsl:value-of select="categoryname"/>
                                            </option>
                                        </xsl:for-each>
                                    </select>
								</td>
							</tr>
							<tr>
								<td class="t1">
									<xsl:value-of select="$lng/category_sub"/>
								</td>
							</tr>
							<tr>
								<td class="t2">
									<select name="category_sub" onchange="update_category_sub()" class="t1"/>
								</td>
							</tr>
							<tr>
								<td class="t2">
									<a href="#" onclick="display_items()">
										<xsl:value-of select="$lng/displayitems"/>
									</a>
								</td>
							</tr>
						</table>
					</form>
				<script language="javascript">
					<xsl:call-template name="category_script"/>
					update_category();
					
					function display_items() {
						var cat = document.report.category.value;
						var sub = document.report.category_sub.value;
						parent.main.location.href = "main.php?module=public&amp;function=show_tender_item&amp;category="+cat+"&amp;category_sub="+sub;
					}

					parent.main.location.href = "main.php?module=public&amp;function=category";
				</script>
			</div>
			</td>
		</tr>
	</table>
	<xsl:call-template name="footer_left"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>