<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderquote"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'public'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="quote"/>
					<input type="hidden" name="usersid" value="{usersid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
					<xsl:if test="not(tenderitems) and not(quoted)">
						<tr>
							<td><br/></td>
							<td class="t2">
								<xsl:value-of select="$lng/nothingtoquote"/>
							</td>
						</tr>
					</xsl:if>
					<!-- completed quotes -->
					<xsl:if test="quoted">
						<tr>
							<td><br/></td>
							<td class="h t2">
								<xsl:value-of select="$lng/tenderitem"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="$lng/price"/>
							</td>
						</tr>
						<xsl:for-each select="quoted">
							<tr>
								<td><br/></td>
								<td class="h2b t2">
									<xsl:value-of select="id"/>
								</td>
								<td class="h2c t2">
									<xsl:value-of select="brand"/>
								</td>
								<td class="h2c t2">
									<xsl:value-of select="model"/>
								</td>
								<td class="h2c t2">
									<xsl:value-of select="price"/>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
					<!--tenderitems -->
					<xsl:if test="tenderitems">
						<tr>
							<td><br/></td>
							<td colspan="4">
								<table border="0" width="100%" cellpadding="2" cellspacing="0" bgcolor="FFFFFF">
									<tr>
										<td class="h1 t1">
											<xsl:value-of select="$lng/item"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/category_sub"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/brand"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/model"/>
										</td>
										<td class="h1a t1" colspan="4">
											<xsl:value-of select="$lng/description"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/stock"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/valid"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/price"/>
										</td>
										<td class="h1a t1">
											<xsl:value-of select="$lng/noquote"/>
										</td>
									</tr>
									<xsl:for-each select="tenderitems">
										<tr>
											<td class="e" colspan="12"><xsl:value-of select="error"/></td>
										</tr>
										<tr>
											<td class="h2b t1" valign="top">
												<xsl:value-of select="id"/>
											</td>
											<td class="h2c t2" valign="top">
												<xsl:value-of select="category_subname"/>
											</td>
											<td class="h2c t2" valign="top">
												<xsl:if test="../brand/brandname">
													<select class="t2">
														<xsl:attribute name="name">brandselector[<xsl:value-of select="id"/>]</xsl:attribute>
														<xsl:attribute name="id">brandselector<xsl:value-of select="id"/></xsl:attribute>
														<xsl:attribute name="onchange">changebrand(brand<xsl:value-of select="id"/>,brandselector<xsl:value-of select="id"/>)</xsl:attribute>
														<option value="0"></option>
														<xsl:for-each select="../brand">
															<option>
																<xsl:attribute name="value"><xsl:value-of select="brandname"/></xsl:attribute>
																<xsl:value-of select="brandname"/>
															</option>
														</xsl:for-each>
													</select>
												</xsl:if>
												<input type="text" class="t2" size="10">
													<xsl:attribute name="value"><xsl:value-of select="brand"/></xsl:attribute>
													<xsl:attribute name="name">brand[<xsl:value-of select="id"/>]</xsl:attribute>
													<xsl:attribute name="id">brand<xsl:value-of select="id"/></xsl:attribute>
												</input>
											</td>
											<td class="h2c t2" valign="top">
												<input type="text" class="t2" size="10">
													<xsl:attribute name="value"><xsl:value-of select="model"/></xsl:attribute>
													<xsl:attribute name="name">model[<xsl:value-of select="id"/>]</xsl:attribute>
													<xsl:attribute name="id">model<xsl:value-of select="id"/></xsl:attribute>
												</input>
											</td>
											<td class="h2c t2" colspan="4" valign="top">
												<textarea class="t2" cols="30" rows="1">
													<xsl:attribute name="name">description[<xsl:value-of select="id"/>]</xsl:attribute>
													<xsl:attribute name="id">description<xsl:value-of select="id"/></xsl:attribute>
													<xsl:value-of select="description"/>
												</textarea>
											</td>
											<td class="h2c t2" valign="top">
												<select class="t2">
													<xsl:attribute name="name">stock[<xsl:value-of select="id"/>]</xsl:attribute>
													<option value="0">
														<xsl:value-of select="$lng/available"/>
													</option>
													<option value="1">
														<xsl:if test="stock='1'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/oneday"/>
													</option>
													<option value="2">
														<xsl:if test="stock='2'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/twoday"/>
													</option>
													<option value="3">
														<xsl:if test="stock='3'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/threeday"/>
													</option>
													<option value="7">
														<xsl:if test="stock='7'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/week"/>
													</option>
												</select>
											</td>
											<td class="h2c t2" valign="top">
												<select class="t2">
													<xsl:attribute name="name">valid[<xsl:value-of select="id"/>]</xsl:attribute>
													<option value="1">
														<xsl:if test="valid='1'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/oneday"/>
													</option>
													<option value="2">
														<xsl:if test="valid='2'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/twoday"/>
													</option>
													<option value="3">
														<xsl:if test="valid='3'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/threeday"/>
													</option>
													<option value="7">
														<xsl:if test="valid='7'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/week"/>
													</option>
													<option value="14">
														<xsl:if test="valid='14'"><xsl:attribute name="selected"/></xsl:if>
														<xsl:value-of select="$lng/twoweek"/>
													</option>
												</select>
											</td>
											<td class="h2c t2" valign="top">
												<input type="text" class="t2" size="8" value="0.00">
													<xsl:attribute name="name">price[<xsl:value-of select="id"/>]</xsl:attribute>
												</input>
											</td>
											<td class="h2c t2" valign="top">
												<input type="checkbox" class="t2" size="20">
													<xsl:attribute name="name">noquote[<xsl:value-of select="id"/>]</xsl:attribute>
													<xsl:attribute name="id">noquote<xsl:value-of select="id"/></xsl:attribute>
												</input>
												<input type="hidden">
													<xsl:attribute name="value"><xsl:value-of select="type"/></xsl:attribute>
													<xsl:attribute name="name">type[<xsl:value-of select="id"/>]</xsl:attribute>
													<xsl:attribute name="id">type<xsl:value-of select="id"/></xsl:attribute>
												</input>
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="8" class="t1" align="right">
								<input type="submit" name="submit" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submitquote"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					<!-- tenders to quote on -->
					</table>
				</form>
			</div>
			<div id="right">
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
