<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/settings"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'public'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="public"/>
					<input type="hidden" name="function" value="settings"/>
					<input type="hidden" name="display_type" value="tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/changedsuccess"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicenable"/>
							</td>
							<td align="left" class="t2">
								<input name="publicenable" value="TRUE" type="radio">
									<xsl:if test="settings/publicenable='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publicenable" value="FALSE" type="radio">
									<xsl:if test="settings/publicenable='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publictender"/>
							</td>
							<td align="left" class="t2">
								<input name="publictender" value="TRUE" type="radio">
									<xsl:if test="settings/publictender='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publictender" value="FALSE" type="radio">
									<xsl:if test="settings/publictender='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicquote"/>
							</td>
							<td align="left" class="t2">
								<input name="publicquote" value="TRUE" type="radio">
									<xsl:if test="settings/publicquote='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publicquote" value="FALSE" type="radio">
									<xsl:if test="settings/publicquote='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicprice"/>
							</td>
							<td align="left" class="t2">
								<input name="publicprice" value="TRUE" type="radio">
									<xsl:if test="settings/publicprice='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publicprice" value="FALSE" type="radio">
									<xsl:if test="settings/publicprice='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publiclimit"/>
							</td>
							<td align="left" class="t2">
								<input class="t2" name="publiclimit" type="text" value="{settings/publiclimit}" size="3"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicstatistics"/>
							</td>
							<td align="left" class="t2">
								<input name="publicstatistics" value="TRUE" type="radio">
									<xsl:if test="settings/publicstatistics='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publicstatistics" value="FALSE" type="radio">
									<xsl:if test="settings/publicstatistics='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicgenerate"/>
							</td>
							<td align="left" class="t2">
								<input name="publicgenerate" value="TRUE" type="radio">
									<xsl:if test="settings/publicgenerate='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publicgenerate" value="FALSE" type="radio">
									<xsl:if test="settings/publicgenerate='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publiccompanyregistration"/>
							</td>
							<td align="left" class="t2">
								<input name="publiccompanyregistration" value="TRUE" type="radio">
									<xsl:if test="settings/publiccompanyregistration='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publiccompanyregistration" value="FALSE" type="radio">
									<xsl:if test="settings/publiccompanyregistration='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicsupplierregistration"/>
							</td>
							<td align="left" class="t2">
								<input name="publicsupplierregistration" value="TRUE" type="radio">
									<xsl:if test="settings/publicsupplierregistration='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publicsupplierregistration" value="FALSE" type="radio">
									<xsl:if test="settings/publicsupplierregistration='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicapprovereg"/>
							</td>
							<td align="left" class="t2">
								<input name="publicapprove_reg" value="TRUE" type="radio">
									<xsl:if test="settings/publicapprove_reg='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publicapprove_reg" value="FALSE" type="radio">
									<xsl:if test="settings/publicapprove_reg='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicsetarea"/>
							</td>
							<td align="left" class="t2">
								<input name="publicsetarea" value="TRUE" type="radio">
									<xsl:if test="settings/publicsetarea='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="publicsetarea" value="FALSE" type="radio">
									<xsl:if test="settings/publicsetarea='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="h1 t1" colspan="2">
								<xsl:value-of select="$lng/organisationdefault"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicuserfee"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="localprecurrency"/>
								<input class="t2" name="publicuser_fee" type="text" value="{settings/publicuser_fee}" size="3"/>
								<xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publicsmsfee"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="localprecurrency"/>
								<input class="t2" name="publicsms_fee" type="text" value="{settings/publicsms_fee}" size="3"/>
								<xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publictransactionmin"/>
							</td>
							<td align="left" class="t2">
								<xsl:value-of select="localprecurrency"/>
								<input class="t2" name="publictransaction_min" type="text" value="{settings/publictransaction_min}" size="3"/>
								<xsl:value-of select="localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/publictransactionfee"/>
							</td>
							<td align="left" class="t2">
								<input class="t2" name="publictransaction_fee" type="text" value="{settings/publictransaction_fee}" size="3"/><xsl:value-of select="'%'"/>
							</td>
						</tr>
						<tr>
							<td align="right" width="270" colspan="2">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/changesettings"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/publicinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
