<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/selectareas"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'organisation'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="public"/>
					<input type="hidden" name="function" value="show_area"/>
					<input type="hidden" name="organisationid" value="{organisationid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF" id="sitediv">
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/updated"/>
								</xsl:if>
							</td>
						</tr>
						<xsl:if test="needcategory='1'">
							<tr>
								<td colspan="4" class="e">
									<xsl:value-of select="$lng/remember"/> : 
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=public&amp;function=show_category&amp;organisationid=',organisationid)"/>
										</xsl:attribute>
										<xsl:value-of select="$lng/needcategory"/>
									</a>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td class="h t1">
								<xsl:value-of select="$lng/states"/>
							</td>
							<td class="ha t1">
								<input type="checkbox" class="t2" id="site" name="checkall" onchange="CheckAll(this)"/>
								<xsl:value-of select="$lng/check"/>
							</td>
						</tr>
						<xsl:for-each select="state">
								<tr>
									<td class="h1b t1">
										<xsl:value-of select="statename"/>
									</td>
									<td class="h1c t1">
										<input type="checkbox" class="t2" onchange="CheckAll(this)">
											<xsl:attribute name="name">checkstate<xsl:value-of select="stateid"/></xsl:attribute>
											<xsl:attribute name="id">site<xsl:value-of select="stateid"/></xsl:attribute>
										</input>
										<xsl:value-of select="$lng/checkarea"/>
									</td>
								</tr>
								<tr>
									<td colspan="2" class="h2b">
										<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
											<xsl:attribute name="id">site<xsl:value-of select="stateid"/>div</xsl:attribute>
											<xsl:variable name="currentid" select="stateid"/>
									 		<xsl:for-each select="../area"><xsl:if test="stateid=$currentid">
												<tr>
													<td class="t1"><br/></td>
													<td class="t2">
														<xsl:value-of select="areaname"/>
													</td>
													<td class="t1" align="right">
														<input type="checkbox" class="t2" name="areaselect[{areaid}]">
															<xsl:variable name="currentareaid" select="areaid"/>
									 						<xsl:for-each select="../selectedarea"><xsl:if test="areaid=$currentareaid">
																<xsl:attribute name="checked">checked</xsl:attribute>
															</xsl:if></xsl:for-each> 
														</input>
													</td>
												</tr>
											</xsl:if></xsl:for-each> 
										</table>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:if test="editable='1'">
								<tr>
									<td class="t1" colspan="2" align="right">
										<input type="submit" class="t2" name="change">
											<xsl:attribute name="value"><xsl:value-of select="$lng/submit"/></xsl:attribute>
										</input>
									</td>
								</tr>
							</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function CheckAll(parent) {
			var allChildren = document.getElementById(parent.id+'div').getElementsByTagName("input");
			for (var i = 0; i &lt; allChildren.length; i++) {
				allChildren[i].checked = parent.checked;
			}
		}
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
