<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/quotepublic"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'public'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="public"/>
					<input type="hidden" name="function" value="show_tender_item"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/quote"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/tenderitem"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/agent"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/valid"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/price"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/status"/>
							</td>
						</tr>
						<xsl:if test="tender_quote/id">
							<xsl:for-each select="tender_quote">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="center">
										<xsl:value-of select="id"/>
									</td>
									<td class="h2c t2" align="center">
										<a>
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=public&amp;function=tender_item&amp;id=',./tenderitemid)"/>
											</xsl:attribute>
											<xsl:value-of select="tenderitemid"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<a>
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=public&amp;function=tender&amp;id=',./tenderid)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="name"/><xsl:value-of select="' '"/><xsl:value-of select="surname"/>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="valid_until"/>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="brand"/>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="model"/>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="created_date"/>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="price"/>
									</td>
									<td class="h2c t2" align="left">
										<xsl:call-template name="tender_quote_icon">
											<xsl:with-param name="classification" select="classification"/>
											<xsl:with-param name="status" select="status"/>
											<xsl:with-param name="tenderclassification" select="tenderclassification"/>
											<xsl:with-param name="itemclassification" select="itemclassification"/>
										</xsl:call-template>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td class="h2b" colspan="11">
									<xsl:if test="display &gt; 0">
										<xsl:variable name="previous" select="display - 1"/>
										<a href="main.php?module=procure&amp;function=show_tender_quote&amp;displaypage={$previous}&amp;tenderquotestatus={tenderquotestatus}&amp;tenderid={tenderid}&amp;tenderitemid={tenderitemid}">
											<img src="./theme/{$theme}/icon/left.gif" border="0" alt="Previous" hspace="1" align="absmiddle"/>
										</a>
									</xsl:if>
									<xsl:if test="more='1'">
										<xsl:variable name="next" select="display + 1"/>
										<a href="main.php?module=procure&amp;function=show_tender_quote&amp;displaypage={$next}&amp;tenderquotestatus={tenderquotestatus}&amp;tenderid={tenderid}&amp;tenderitemid={tenderitemid}">
											<img src="./theme/{$theme}/icon/right.gif" border="0" alt="Next" hspace="1" align="absmiddle" />
										</a>
									</xsl:if>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
