<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderprofile"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'public'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="public"/>
					<input type="hidden" name="function" value="profile"/>
					<input type="hidden" name="id" value="{tenderinfo/id}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="6" class="h t1">
								<xsl:value-of select="$lng/tenderinfo"/>:
								<xsl:value-of select="tenderinfo/rfq_number"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderinfo/rfq_number"/>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderinfo/rfq_reference"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/type"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderinfo/type"/>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderinfo/statename"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderinfo/areaname"/>
							</td>
						<xsl:if test="tenderinfo/attachment!='0' and tenderinfo/attachment!=''">
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/attachment"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<img alt="clip" src="./theme/{$theme}/img/icon/attach.gif">
									<xsl:attribute name="href">#</xsl:attribute>
								</img>
							</td>
						</xsl:if>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/transport"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:choose>
									<xsl:when test="editable='1' and tenderinfo/status &lt; 0">
										<select name="transport" class="t2">
											<option value="c">
												<xsl:if test="tenderinfo/transport='c'">
													<xsl:attribute name="selected"/>
												</xsl:if>
												<xsl:value-of select="$lng/collect"/>
											</option>
											<option value="d">
												<xsl:if test="tenderinfo/transport='d'">
													<xsl:attribute name="selected"/>
												</xsl:if>
												<xsl:value-of select="$lng/deliver"/>
											</option>
											<option value="i">
												<xsl:if test="tenderinfo/transport='i'">
													<xsl:attribute name="selected"/>
												</xsl:if>
												<xsl:value-of select="$lng/install"/>
											</option>
										</select>
									</xsl:when>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="tenderinfo/transport='c'">
												<xsl:value-of select="$lng/collect"/>
											</xsl:when>
											<xsl:when test="tenderinfo/transport='d'">
												<xsl:value-of select="$lng/deliver"/>
											</xsl:when>
											<xsl:when test="tenderinfo/transport='i'">
												<xsl:value-of select="$lng/install"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:call-template name="tender_icon">
									<xsl:with-param name="classification" select="tenderinfo/classification"/>
									<xsl:with-param name="status" select="tenderinfo/status"/>
								</xsl:call-template>
								<xsl:value-of select="tenderinfo/error"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/subscriber"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderinfo/name"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderinfo/surname"/>
							</td>
						<xsl:if test="tenderinfo/error!=''">
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/error"/>
							</td>
							<td align="left" colspan="2" class="e">
								<xsl:value-of select="tenderinfo/error"/>
							</td>
						</xsl:if>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/closeon"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderinfo/close_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderinfo/close_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="localdisplay"/>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/createdon"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderinfo/created_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="tenderinfo/created_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="localdisplay"/>
							</td>
						</tr>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<xsl:if test="tenderinfo/status='6'">
							<tr>
								<td colspan="5" class="h t1">
									<xsl:value-of select="$lng/clientinfo"/>:
									<xsl:value-of select="tenderinfo/client_title"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderinfo/client_surname"/>
								</td>
							</tr>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/name"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="tenderinfo/client_title"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderinfo/client_surname"/>
								</td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/idno"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="tenderinfo/client_id"/>
								</td>
							</tr>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/phonework"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="tenderinfo/client_phone_work"/>
								</td>
								<td align="right" class="t1">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="'callto://+'"/>
											<xsl:value-of select="tenderinfo/client_phone_prefix"/>
											<xsl:number value="tenderinfo/client_phone_work" format="1"/>
										</xsl:attribute>
										<img src="./theme/{$theme}/icon/call.gif" border="0">
											<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/call"/></xsl:attribute>
										</img>
									</a>
								</td>
							</tr>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/phonemobile"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="tenderinfo/client_phone_mobile"/>
								</td>
								<td align="right"  class="t1">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="'callto://+'"/>
											<xsl:value-of select="tenderinfo/client_phone_prefix"/>
											<xsl:number value="tenderinfo/client_phone_mobile" format="1"/>
										</xsl:attribute>
										<img src="./theme/{$theme}/icon/call.gif" border="0">
											<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/call"/></xsl:attribute>
										</img>
									</a>
								</td>
							</tr>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/email"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="tenderinfo/client_email"/>
								</td>
								<td align="right"  class="t1">
									<a href="mailto:{tenderinfo/client_email}">
										<img src="./theme/{$theme}/icon/mail_replay.gif" border="0">
											<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/call"/></xsl:attribute>
										</img>
									</a>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<tr>
							<td colspan="4" class="h t1">
								<xsl:value-of select="$lng/otherinfo"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/tenderitems"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a >
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=public&amp;function=show_tender_item&amp;tenderid=',tenderinfo/id)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/list"/>
								</a>
							</td>
						</tr>
						<xsl:if test="publicquote='1'">
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/tenderquotes"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a >
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=public&amp;function=show_tender_quote&amp;id=',tenderinfo/id)"/>
									</xsl:attribute>
									<xsl:value-of select="$lng/list"/>
								</a>
							</td>
						</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
