<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderitemprofile"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'public'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="tender"/>
					<input type="hidden" name="function" value="item_profile"/>
					<input type="hidden" name="id" value="{tenderiteminfo/id}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="6" class="h t1">
								<xsl:value-of select="$lng/tenderiteminfo"/>:
								<xsl:value-of select="tenderiteminfo/id"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/type"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:choose>
									<xsl:when test="tenderiteminfo/classification='4'">
										<xsl:value-of select="$lng/install"/>
									</xsl:when>
									<xsl:when test="tenderiteminfo/classification='3'">
										<xsl:value-of select="$lng/deliver"/>
									</xsl:when>
									<xsl:when test="tenderiteminfo/classification='2'">
										<xsl:value-of select="$lng/voucher"/>
									</xsl:when>
									<xsl:when test="tenderiteminfo/classification='1'">
										<xsl:value-of select="$lng/item"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/unknown"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/category"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/categoryname"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/category_sub"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/category_subname"/>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/brand"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/model"/>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/description"/>
							</td>
							<td align="left" colspan="3" class="t2">
								<xsl:value-of select="tenderiteminfo/description"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/quote"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/quote"/>
							</td>
						<xsl:if test="tenderbudget='1'">
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/budget"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/budget"/>
							</td>
						</xsl:if>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/sent"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/sent"/>
							</td>
							<xsl:if test="publicquote">
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/received"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<xsl:value-of select="tenderiteminfo/received"/>
								</td>
							</xsl:if>
						</tr>
						<tr>
							<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/subscriber"/>
								</td>
								<td align="left" class="t2">
									<xsl:value-of select="tenderiteminfo/name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderiteminfo/surname"/>
								</td>
							<xsl:if test="tenderinfo/error!=''">
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/errors"/>
								</td>
								<td align="left" class="e">
									<xsl:value-of select="tenderiteminfo/error"/>
								</td>
							</xsl:if>
							</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" colspan="2" class="t2">
								
							</td>
						</tr>
						<xsl:if test="tenderiteminfo/status='6'">
							<tr>
								<td colspan="5" class="h t1">
									<xsl:value-of select="$lng/completeinfo"/>
								</td>
							</tr>
							<tr>
								<td ><br/></td>
							<xsl:if test="publicquote">
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/tenderquote"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=public&amp;function=tender_quote&amp;id=',tenderiteminfo/complete_quote)"/>
										</xsl:attribute>
										<xsl:value-of select="tenderiteminfo/complete_quote"/>
									</a>
								</td>
							</xsl:if>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/reason"/>
								</td>
								<td align="left" colspan="3" class="t2">
									<xsl:value-of select="tenderiteminfo/complete_reason"/>
								</td>
							</tr>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/completedate"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<xsl:value-of select="tenderiteminfo/complete_date"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="tenderiteminfo/complete_time"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="localdisplay"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="6" class="h t1">
								<xsl:value-of select="$lng/tenderinfo"/>:
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=public&amp;function=tender&amp;id=',tenderiteminfo/tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/rfq_number"/>
								</a>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=public&amp;function=tender&amp;id=',tenderiteminfo/tenderid)"/>
									</xsl:attribute>
									<xsl:value-of select="tenderiteminfo/rfq_number"/>
								</a>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/rfq_reference"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/statename"/>
							</td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<xsl:value-of select="tenderiteminfo/areaname"/>
							</td>
						</tr>
						<tr>
							<td ><br/></td>
							<td align="left"  class="t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td align="left" colspan="2" class="t2">
								<a>
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=public&amp;function=tender&amp;id=',tenderiteminfo/tenderid)"/>
									</xsl:attribute>

								</a>
							</td>
						</tr>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<xsl:if test="tenderiteminfo/agent">
							<tr>
								<td colspan="6" class="h t1">
									<xsl:value-of select="$lng/agentinfo"/>
								</td>
							</tr>
							<tr>
								<td colspan="6">
									<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
										<tr>
											<td class="h1 t1">
												<xsl:value-of select="$lng/agent"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/email"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/phonework"/>
											</td>
											<td class="h1a t1">
												<xsl:value-of select="$lng/phonemobile"/>
											</td>
										</tr>
										<xsl:for-each select="tenderiteminfo/agent">
											<tr>
												<td class="h2b t1">
													<xsl:value-of select="name"/>
													<xsl:value-of select="' '"/>
													<xsl:value-of select="surname"/>
												</td>
												<td class="h2c t1">
													<a>
														<xsl:attribute name="href">mailto:<xsl:value-of select="email"/>?subject=<xsl:value-of select="../rfq_number"/></xsl:attribute>
														<xsl:value-of select="email"/>
													</a>
												</td>
												<td class="h2c t1">
													<a>
														<xsl:attribute name="href">
															<xsl:value-of select="'callto://+'"/>
															<xsl:value-of select="phone_prefix"/>
															<xsl:number value="phone_work" format="1"/>
														</xsl:attribute>
														<xsl:value-of select="phone_work"/>
													</a>
												</td>
												<td class="h2c t1">
													<a>
														<xsl:attribute name="href">
															<xsl:value-of select="'callto://+'"/>
															<xsl:value-of select="phone_prefix"/>
															<xsl:number value="phone_mobile" format="1"/>
														</xsl:attribute>
														<xsl:value-of select="phone_mobile"/>
													</a>
												</td>
											</tr>
										</xsl:for-each>
									</table>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="2"><br/></td>
						</tr>
						<xsl:if test="publicquote='1'">
							<tr>
								<td colspan="4" class="h t1">
									<xsl:value-of select="$lng/otherinfo"/>
								</td>
							</tr>
							<tr>
								<td ><br/></td>
								<td align="left"  class="t1">
									<xsl:value-of select="$lng/tenderquotes"/>
								</td>
								<td align="left" colspan="2" class="t2">
									<a>
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=public&amp;function=show_tender_quote&amp;tenderitemid=',tenderiteminfo/id)"/>
										</xsl:attribute>
										<xsl:value-of select="$lng/list"/>
									</a>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
