<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/supplierrating"/>
			<xsl:if test="user/usersid!=userinfo/id">
				<xsl:value-of select="' '"/>
				<xsl:value-of select="$lng/onbehalfof"/>
				<xsl:value-of select="' '"/>
				<a target="main">
					<xsl:attribute name="href">
					<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./userinfo/id)"/>
					</xsl:attribute>
					<xsl:value-of select="userinfo/name"/>
					<xsl:value-of select="' '"/>
					<xsl:value-of select="userinfo/surname"/>
				</a>
			</xsl:if>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="$lng/forsupplier"/>
			<xsl:value-of select="' '"/>
			<a target="main">
				<xsl:attribute name="href">
				<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./supplierinfo/id)"/>
				</xsl:attribute>
				<xsl:value-of select="supplierinfo/name"/>
			</a>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'rating'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="rating"/>
					<input type="hidden" name="function" value="add_view"/>
					<input type="hidden" name="usersid" value="{userinfo/id}"/>
					<input type="hidden" name="supplierid" value="{supplierinfo/id}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/ratings"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
					<xsl:if test="$lng/ratecatfirst!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfirst"/>
							</td>
							<td class="h2c t2">
								<xsl:choose>
									<xsl:when test="ratinginfo/first_sum!='' and ratinginfo/first_count &gt; minimum - 1">
										<xsl:value-of select="ratinginfo/first_avg"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/notyetrated"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatsecond!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatsecond"/>
							</td>
							<td class="h2c t2">
								<xsl:choose>
									<xsl:when test="ratinginfo/second_sum!='' and ratinginfo/second_count &gt; minimum - 1">
										<xsl:value-of select="ratinginfo/second_avg"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/notyetrated"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatthird!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatthird"/>
							</td>
							<td class="h2c t2">
								<xsl:choose>
									<xsl:when test="ratinginfo/third_sum!='' and ratinginfo/third_count &gt; minimum - 1">
										<xsl:value-of select="ratinginfo/third_avg"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/notyetrated"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatfourth!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfourth"/>
							</td>
							<td class="h2c t2">
								<xsl:choose>
									<xsl:when test="ratinginfo/fourth_sum!='' and ratinginfo/fourth_count &gt; minimum - 1">
										<xsl:value-of select="ratinginfo/fourth_avg"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/notyetrated"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatfifth!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfifth"/>
							</td>
							<td class="h2c t2">
								<xsl:choose>
									<xsl:when test="ratinginfo/fifth_sum!='' and ratinginfo/fifth_count &gt; minimum - 1">
										<xsl:value-of select="ratinginfo/fifth_avg"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$lng/notyetrated"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</xsl:if>
					<tr><td><br/></td></tr>
				<xsl:if test="canadd='1'">
						<tr>
							 <td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/addratings"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
					<xsl:if test="$lng/ratecatfirst!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfirst"/>
							</td>
							<td class="h2c t2">
								<select class="t2" name="first_rate">
									<option value="0"><xsl:value-of select="$lng/dontrate"/></option>
									<xsl:for-each select="ratinginfo/rating">
										<option value="{.}"><xsl:value-of select="."/></option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatsecond!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatsecond"/>
							</td>
							<td class="h2c t2">
								<select class="t2" name="second_rate">
									<option value="0"><xsl:value-of select="$lng/dontrate"/></option>
									<xsl:for-each select="ratinginfo/rating">
										<option value="{.}"><xsl:value-of select="."/></option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatthird!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatthird"/>
							</td>
							<td class="h2c t2">
								<select class="t2" name="third_rate">
									<option value="0"><xsl:value-of select="$lng/dontrate"/></option>
									<xsl:for-each select="ratinginfo/rating">
										<option value="{.}"><xsl:value-of select="."/></option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatfourth!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfourth"/>
							</td>
							<td class="h2c t2">
								<select class="t2" name="fourth_rate">
									<option value="0"><xsl:value-of select="$lng/dontrate"/></option>
									<xsl:for-each select="ratinginfo/rating">
										<option value="{.}"><xsl:value-of select="."/></option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatfifth!=''">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfifth"/>
							</td>
							<td class="h2c t2">
								<select class="t2" name="fifth_rate">
									<option value="0"><xsl:value-of select="$lng/dontrate"/></option>
									<xsl:for-each select="ratinginfo/rating">
										<option value="{.}"><xsl:value-of select="."/></option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td><br/></td>
						<td class="hb t1" colspan="2">
							<xsl:value-of select="$lng/comment"/>
						</td>
					</tr>
					<tr>
						<td><br/></td>
						<td class="h2b t1" colspan="2">
							<textarea class="t2" name="rating_comment" cols="60" rows="5"/>
						</td>
					</tr>
					<tr>
						<td><br/></td>
						<td align="right" colspan="2">
							<input type="submit" name="add" value="{$lng/submit}" class="t2"/>
						</td>
					</tr>
				</xsl:if>
					<tr><td><br/></td></tr>
					<tr>
						<td><br/></td>
						<td class="h t1" colspan="2">
							<xsl:value-of select="$lng/subscriberratingscomments"/>
						</td>
					</tr>
					<xsl:for-each select="ratinginfo/all">
						<tr><td><br/></td></tr>
						<tr>
							<td><br/></td>
							<td class="h1 t1">
								<xsl:value-of select="$lng/subscriber"/>
							</td>
							<td class="h2a t2">
								<a target="main">
									<xsl:attribute name="href">
									<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/submmitteddate"/>
							</td>
							<td class="h2c t2">
								<xsl:value-of select="created_time"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="created_date"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="../localdisplay"/>
							</td>
						</tr>
					<xsl:if test="$lng/ratecatfirst!='' and first_rate!='' and first_rate!='0'">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfirst"/>
							</td>
							<td class="h2c t2">
								<xsl:value-of select="first_rate"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatsecond!='' and second_rate!='' and second_rate!='0'">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatsecond"/>
							</td>
							<td class="h2c t2">
								<xsl:value-of select="second_rate"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatthird!='' and third_rate!='' and third_rate!='0'">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatthird"/>
							</td>
							<td class="h2c t2">
								<xsl:value-of select="third_rate"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatfourth!='' and fourth_rate!='' and fourth_rate!='0'">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfourth"/>
							</td>
							<td class="h2c t2">
								<xsl:value-of select="fourth_rate"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$lng/ratecatfifth!='' and fifth_rate!='' and fifth_rate!='0'">
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/ratecatfifth"/>
							</td>
							<td class="h2c t2">
								<xsl:value-of select="fifth_rate"/>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td><br/></td>
						<td class="h1b t1">
							<xsl:value-of select="$lng/comment"/>
						</td>
						<td class="h2c t2">
							<xsl:choose>
								<xsl:when test="rating_comment!=''">
									<textarea class="readonly t2" cols="40" rows="5" readonly="readonly">
										<xsl:value-of select="rating_comment"/>
									</textarea>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$lng/nocomment"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
					</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
