<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/supplierrating"/>
			<xsl:if test="user/usersid!=userinfo/id">
				<xsl:value-of select="' '"/>
				<xsl:value-of select="$lng/onbehalfof"/>
				<xsl:value-of select="' '"/>
				<xsl:value-of select="userinfo/name"/>
				<xsl:value-of select="' '"/>
				<xsl:value-of select="userinfo/surname"/>
			</xsl:if>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'rating'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="rating"/>
					<input type="hidden" name="function" value="rate_supplier"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							 <td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/supplier"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/ratingoutof"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="outof"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/ratesupplerviewcomments"/>
							</td>
						</tr>
						<xsl:for-each select="supplier">
							<tr>
								 <td><br/></td>
								<td class="h2b t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./id)"/>
										</xsl:attribute>
										<xsl:value-of select="name"/>
									</a>
								</td>
						<xsl:choose>
							<xsl:when test="supplier_rating='' or supplier_rating='0'">
								<td class="h2c t2">	
									<xsl:value-of select="$lng/notyetrated"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="h2c t2">	
									<xsl:value-of select="supplier_rating"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
								<td class="h2c t2">
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=rating&amp;function=add_view&amp;usersid=',../userinfo/id,'&amp;supplierid=',./id)"/>
										</xsl:attribute>
										<xsl:value-of select="$lng/rateview"/>
									</a>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
