<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>
<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/ratingsettings"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'rating'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="rating"/>
					<input type="hidden" name="function" value="settings"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<xsl:if test="updated='1'">
						<tr>
							<td colspan="4" class="t1">
								<xsl:value-of select="$lng/changedsuccess"/>
							</td>
						</tr>
						</xsl:if>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<xsl:call-template name="radio_true_false">
							<xsl:with-param name="setting_name" select="$lng/ratingenable"/>
							<xsl:with-param name="input_name" select="'ratingenable'"/>
							<xsl:with-param name="input_value" select="settings/ratingenable"/>
						</xsl:call-template>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/ratingoutof"/>
							</td>
							<td align="left" class="t2">
								<input name="ratingoutof" value="{settings/ratingoutof}" type="text" size="4" class="t2"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/ratingmincount"/>
							</td>
							<td align="left" class="t2">
								<input name="ratingmincount" value="{settings/ratingmincount}" type="text" size="4" class="t2"/>
							</td>
						</tr>
						<tr>
							<xsl:call-template name="radio_true_false">
								<xsl:with-param name="setting_name" select="$lng/sendemail"/>
								<xsl:with-param name="input_name" select="'ratingsendemail'"/>
								<xsl:with-param name="input_value" select="settings/ratingsendemail"/>
							</xsl:call-template>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/instsetting">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
