<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Company report page
* @package TenderSystem
* @subpackage report
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// field request errors and type 
$fields_request = array (
	'organisationid'	=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e10"),
	'display'			=> array()	
);
if(!get_request($fields_request,$action,$error,$cfg)) {
	// display error
	xml_generator("report","error",$error,$params,$cfg);
}
if($action['display']) {
	// field request errors and type 
	$fields_request = array (
		'reporttype'	=> array("e2"),
		'tenderstatus'	=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e11"),
		'startdate'		=> array("",	REQUEST_DATE,	FORMAT_NONE,	"e12"),
		'enddate'		=> array("",	REQUEST_DATE,	FORMAT_NONE,	"e13"),
		'rfqnumber'		=> array(),
		'rfqreference'	=> array(),
		'stateid'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e14"),
		'areaid'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e15"),
		'branchid'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e16"),
		'usersid'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e17"),
		'firstsort'		=> array(),
		'secondsort'	=> array(),
		'reportformat'	=> array(),
		'group'			=> array()
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$params = array(
			'module'		=> 'report',
			'function'		=> 'company',
			'reportinfo'	=> $info,
			'organisationid'=> $action['organisationid']
		);
		if($info['reportformat'] != "online") {
			$cfg['api_request'] = TRUE;
			// send the message to app
			$xml = send_message($params,$cfg);
			$data = unserialize(event_parser("<data>","</data>",$xml));
			if(is_array($data)) {
				$file_data = "";
				// get language for headings
				$default = file_get_contents("modules/report/language/".$_SESSION['ts_lang']."/default.xml");
				// get headings
				$headings =  array("rfqnumber","tenderitem","closedate",
					"area","category","brand","model","status","invoice",
					"paid","quote","bestprice","saving","savingpercent",
					"percentofmax","stddev");
				if($info['reportformat'] == "csv") {
					foreach($headings as $value) {
						$file_data.= event_parser("<".$value.">","</".$value.">",$default).",";
					}
					$file_data.="\n";
					foreach($data as $key => $value) {
						$file_data.=$value['rfq_number'].",";
						$file_data.=$value['id'].",";
						$file_data.=$value['close_date']." ".$value['close_time'].",";
						$file_data.=$value['statename']." ".$value['areaname'].",";
						$file_data.=$value['categoryname']." ".$value['category_subname'].",";
						$file_data.=$value['brand'].",";
						$file_data.=$value['model'].",";
						if($value['complete_status'] == "1") {
							$file_data.= event_parser("<awarded>","</awarded>",$default).",";
						} elseif($value['complete_status'] == "2") {
							$file_data.= event_parser("<nontendersupplier>","</nontendersupplier>",$default).",";
						} elseif($value['complete_status'] == "3") {
							$file_data.= event_parser("<cashsettlement>","</cashsettlement>",$default).",";
						} elseif($value['complete_status'] == "4") {
							$file_data.= event_parser("<invalidate>","</invalidate>",$default).",";
						} else {
							$file_data.= event_parser("<unknown>","</unknown>",$default).",";
						}
						if($value['invoice_user'] == "0") {
							$file_data.= event_parser("<no>","</no>",$default).",";
						} else {
							$file_data.= event_parser("<yes>","</yes>",$default).",";
						}
						if($value['payment_user'] == "0") {
							$file_data.= event_parser("<no>","</no>",$default).",";
						} else {
							$file_data.= event_parser("<yes>","</yes>",$default).",";
						}
						$file_data.=$value['quote'].",";
						$file_data.=$value['saving'].",";
						$file_data.=$value['saving_percent'].",";
						$file_data.=($value['worstprice']/$value['bestprice'] * 100).",";
						$file_data.=$value['std_dev'].",";
						$file_data.="\n";	
					}
					// set the header and display
					$header_name = "Content-Disposition: attachment; filename=\"report.".$info['reportformat']."\"";
					header($header_name);
					header("Content-Type: application/octet-stream");
					header("Content-Length: ".strlen($file_data));
					header("Pragma: no-cache");
					header("Expires: 0");
					echo $file_data;
				} elseif($info['reportformat'] == "xls") {
					echo "Not Available";
				}
			} else {
				echo $xml;	
			}
		} else {
			send_message($params,$cfg);
		}
	} else {
		$params = array(
			'module'		=> 'report',
			'function'		=> 'company',
			'error'			=> $error,
			'organisationid'=> $action['organisationid']
		);
		// send the message to app
		send_message($params,$cfg);
	}
} else {
	// field request errors and type 
	$fields_request = array (
		'reporttype'	=> array(),
		'tenderid'		=> array("",	REQUEST_NUMBER,	FORMAT_NONE,	"e18")
	);
	if(get_request($fields_request,$info,$error,$cfg)) {
		$params = array(
			'module'			=> 'report',
			'function'			=> 'company',
			'reportinfo'		=> $info,
			'organisationid'	=> $action['organisationid']
		);
		// send the message to app
		send_message($params,$cfg);
	} else {
		$params = array(
			'module'			=> 'report',
			'function'			=> 'company',
			'error'				=> $error,
			'organisationid'	=> $action['organisationid']
		);
		// send the message to app
		send_message($params,$cfg);
		// display error
		xml_generator("organisation","error",$error,$params,$cfg);	
	}
}
?>