<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/auditreport"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="$lng/oftendersbetween"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="startdate"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="$lng/and"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="enddate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="show_tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>								
							<td class="h t1" align="right" colspan="14">
								<xsl:choose>
									<xsl:when test="branch">
										<xsl:attribute name="colspan">12</xsl:attribute>
									</xsl:when>
									<xsl:when test="users">
										<xsl:attribute name="colspan">12</xsl:attribute>
									</xsl:when>
								</xsl:choose>	
							
								<xsl:value-of select="$lng/selectotherreport"/><xsl:value-of select="': '"/>

								<select name="reporttype" class="t1" onchange="gotoreport()">
									<xsl:if test="reporttype">
										<xsl:for-each select="reporttype">
											<option value="{value}">
												<xsl:value-of select="name"/>
											</option>
										</xsl:for-each>
									</xsl:if>
									<option value="audit"><xsl:attribute name="selected"/><xsl:value-of select="$lng/audittrail"/></option>
									<option value="close"><xsl:value-of select="$lng/closedtenders"/></option>
									<option value="awarded"><xsl:value-of select="$lng/awardedtenders"/></option>
									<option value="bordereaux"><xsl:value-of select="$lng/bordereaux"/></option>
									<option value="balance"><xsl:value-of select="$lng/balancescorecard"/></option>
									<option value="user_fees"><xsl:value-of select="$lng/fees"/></option>
								</select>
								<xsl:value-of select="' '"/>
								<input name="print" type="button" value="{$lng/print}" onclick="window.print()" class="t2"/>
							</td>
						</tr>
						<xsl:choose>
							<xsl:when test="branch">
								<xsl:for-each select="branch">
									<tr>
										<td><br/></td>
										<td class="hb t1" colspan="12">
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=branch&amp;function=profile&amp;id=',./branchid)"/>
												</xsl:attribute>
												<xsl:value-of select="branchname"/>
											</a>
										</td>
									</tr>
									<tr>
										<td><br/></td>
										<td class="h1b t1">
											<xsl:value-of select="$lng/subscriber"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/rfqnumber"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/tenderitem"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/startdate"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/area"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/category"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/brand"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/model"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/quoteposition"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/sent"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/response"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/status"/>
										</td>
									</tr>
									<xsl:variable name="branchid" select="branchid"/>
									<xsl:if test="../tender/tenderid">
										<xsl:for-each select="../tender">
											<xsl:if test="branchid=$branchid">
												<tr>
													<td><br/></td>
													<td class="h2b t2" align="center">
														<a target="main">
															<xsl:attribute name="href">
																<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
															</xsl:attribute>
															<xsl:value-of select="name"/>
															<xsl:value-of select="' '"/>
															<xsl:value-of select="surname"/>
														</a>
													</td>
													<td class="h2c t2" align="center">
														<a target="main">
															<xsl:attribute name="href">
																<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
															</xsl:attribute>
															<xsl:value-of select="rfq_number"/>
														</a>
													</td>
													<td class="h2c t2" align="center">
														<a target="main">
															<xsl:attribute name="href">
																<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
															</xsl:attribute>
															<xsl:value-of select="id"/>
														</a>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="created_on"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="areaname"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="category_subname"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="brand"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="model"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:choose>
															<xsl:when test="quote_position &gt; 0">
																<xsl:call-template name="position_icon">
																	<xsl:with-param name="position" select="quote_position"/>
																</xsl:call-template>													
															</xsl:when>
															<xsl:otherwise>
																<img src="./theme/{$theme}/icon/no.gif">
																	<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
																	<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
																</img>
															</xsl:otherwise>
														</xsl:choose>													
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="sent"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="received"/>
													</td>
													<td class="h2c t2" align="center">
														<a target="main">
															<xsl:attribute name="href">
																<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
															</xsl:attribute>
															<xsl:call-template name="tender_item_icon">
																<xsl:with-param name="classification" select="classification"/>
																<xsl:with-param name="status" select="status"/>
																<xsl:with-param name="completestatus" select="complete_status"/>
																<xsl:with-param name="tenderclassification" select="tenderclassification"/>
															</xsl:call-template>
														</a>
													</td>
												</tr>
											</xsl:if>
										</xsl:for-each>
										<tr><td><br/></td></tr>
									</xsl:if>
								</xsl:for-each>
							</xsl:when>
							<xsl:when test="users">
								<xsl:for-each select="users">
									<tr>
										<td><br/></td>
										<td class="hb t1" colspan="11">
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=branch&amp;function=profile&amp;id=',./branchid)"/>
												</xsl:attribute>
												<xsl:value-of select="branchname"/>
											</a> : 
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=users&amp;function=profile&amp;id=',./usersid)"/>
												</xsl:attribute>
												<xsl:value-of select="name"/>
												<xsl:value-of select="' '"/>
												<xsl:value-of select="surname"/>
											</a>
										</td>
									</tr>
									<tr>
										<td><br/></td>
										<td class="h1b t1">
											<xsl:value-of select="$lng/rfqnumber"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/tenderitem"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/startdate"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/area"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/category"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/brand"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/model"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/quoteposition"/>
										</td>				
										<td class="h1c t1">
											<xsl:value-of select="$lng/sent"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/response"/>
										</td>
										<td class="h1c t1">
											<xsl:value-of select="$lng/status"/>
										</td>
									</tr>
									<xsl:variable name="usersid" select="usersid"/>
									<xsl:if test="../tender/tenderid">
										<xsl:for-each select="../tender">
											<xsl:if test="usersid=$usersid">
												<tr>
													<td><br/></td>
													<td class="h2b t2" align="center">
														<a target="main">
															<xsl:attribute name="href">
																<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
															</xsl:attribute>
															<xsl:value-of select="rfq_number"/>
														</a>
													</td>
													<td class="h2c t2" align="center">
														<a target="main">
															<xsl:attribute name="href">
																<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
															</xsl:attribute>
															<xsl:value-of select="id"/>
														</a>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="created_on"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="areaname"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="category_subname"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="brand"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="model"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:choose>
															<xsl:when test="quote_position &gt; 0">
																<xsl:call-template name="position_icon">
																	<xsl:with-param name="position" select="quote_position"/>
																</xsl:call-template>													
															</xsl:when>
															<xsl:otherwise>
																<img src="./theme/{$theme}/icon/no.gif">
																	<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
																	<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
																</img>
															</xsl:otherwise>
														</xsl:choose>													
													</td>	
													<td class="h2c t2" align="center">
														<xsl:value-of select="sent"/>
													</td>
													<td class="h2c t2" align="center">
														<xsl:value-of select="received"/>
													</td>
													<td class="h2c t2" align="center">
														<a target="main">
															<xsl:attribute name="href">
																<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
															</xsl:attribute>
															<xsl:call-template name="tender_item_icon">
																<xsl:with-param name="classification" select="classification"/>
																<xsl:with-param name="status" select="status"/>
																<xsl:with-param name="completestatus" select="complete_status"/>
																<xsl:with-param name="tenderclassification" select="tenderclassification"/>
															</xsl:call-template>
														</a>
													</td>
												</tr>
											</xsl:if>
										</xsl:for-each>
										<tr><td><br/></td></tr>
									</xsl:if>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<td><br/></td>
									<td class="hb t1">
										<xsl:value-of select="$lng/branch"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/subscriber"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/rfqnumber"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/tenderitem"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/startdate"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/area"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/category"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/brand"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/model"/>
									</td>									
									<td class="hc t1">
										<xsl:value-of select="$lng/quoteposition"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/sent"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/response"/>
									</td>
									<td class="hc t1">
										<xsl:value-of select="$lng/status"/>
									</td>
								</tr>
								<xsl:if test="tender/tenderid">
									<xsl:for-each select="tender">
										<tr>
											<td><br/></td>
											<td class="h2b t2" align="center">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=branch&amp;function=profile&amp;id=',./branchid)"/>
													</xsl:attribute>
													<xsl:value-of select="branchname"/>
												</a>
											</td>
											<td class="h2c t2" align="center">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
													</xsl:attribute>
													<xsl:value-of select="name"/>
													<xsl:value-of select="' '"/>
													<xsl:value-of select="surname"/>
												</a>
											</td>
											<td class="h2c t2" align="center">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
													</xsl:attribute>
													<xsl:value-of select="rfq_number"/>
												</a>
											</td>
											<td class="h2c t2" align="center">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
													</xsl:attribute>
													<xsl:value-of select="id"/>
												</a>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="created_on"/>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="areaname"/>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="category_subname"/>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="brand"/>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="model"/>
											</td>
											<td class="h2c t2" align="center">
												<xsl:choose>
													<xsl:when test="quote_position &gt; 0">
														<xsl:call-template name="position_icon">
															<xsl:with-param name="position" select="quote_position"/>
														</xsl:call-template>													
													</xsl:when>
													<xsl:otherwise>
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="sent"/>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="received"/>
											</td>
											<td class="h2c t2" align="center">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
													</xsl:attribute>
													<xsl:call-template name="tender_item_icon">
														<xsl:with-param name="classification" select="classification"/>
														<xsl:with-param name="status" select="status"/>
														<xsl:with-param name="completestatus" select="complete_status"/>
														<xsl:with-param name="tenderclassification" select="tenderclassification"/>
													</xsl:call-template>
												</a>
											</td>
										</tr>
									</xsl:for-each>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function gotoreport() {
			var otherreport = document.report.reporttype.value;
			var startdate = "<xsl:value-of select="reportinfo/startdate"/>";
			var enddate = "<xsl:value-of select="reportinfo/enddate"/>";
			var URL = "./main.php?module=report&amp;function=company&amp;reporttype=" + otherreport+"&amp;display=1"+"&amp;reportformat=online"+"&amp;startdate=" + startdate + "&amp;enddate=" + enddate;
			<xsl:if test="reportinfo/stateid != 0">
				URL += "&amp;stateid=" + <xsl:value-of select="reportinfo/stateid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/areaid != 0">
				URL += "&amp;areaid=" + <xsl:value-of select="reportinfo/areaid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/branchid != 0">
				URL += "&amp;branchid=" + <xsl:value-of select="reportinfo/branchid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/usersid != 0">
				URL += "&amp;usersid=" + <xsl:value-of select="reportinfo/usersid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/firstsort">
				URL += "&amp;firstsort=" + "<xsl:value-of select="reportinfo/firstsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/secondsort">
				URL += "&amp;secondsort=" + "<xsl:value-of select="reportinfo/secondsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/group">
				URL += "&amp;group=" + "<xsl:value-of select="reportinfo/group"/>";
			</xsl:if>
			<xsl:if test="reportinfo/organisationid">
				URL += "&amp;organisationid=" + <xsl:value-of select="reportinfo/organisationid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/rfqnumber">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqnumber"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/rfqreference">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqreference"/>";
			</xsl:if>
			parent.main.location.href = URL;
		}		
	</script>	
</body>
</html>

</xsl:template>

</xsl:stylesheet>