<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<xsl:variable name="localprecurrency" select="localprecurrency"/>
<xsl:variable name="localpostcurrency" select="localpostcurrency"/>
<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/awardedtenders"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="$lng/oftendersbetween"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="startdate"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="$lng/and"/>
			<xsl:value-of select="' '"/>
			<xsl:value-of select="enddate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="show_tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>								
							<td class="h t1" align="right" colspan="21">
								<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
									<xsl:attribute name="colspan">22</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="$lng/selectotherreport"/><xsl:value-of select="': '"/>

								<select name="reporttype" class="t1" onchange="gotoreport()">
									<xsl:if test="reporttype">
										<xsl:for-each select="reporttype">
											<option value="{value}">
												<xsl:value-of select="name"/>
											</option>
										</xsl:for-each>
									</xsl:if>
									<option value="audit"><xsl:value-of select="$lng/audittrail"/></option>
									<option value="close"><xsl:value-of select="$lng/closedtenders"/></option>
									<option value="awarded"><xsl:attribute name="selected"/><xsl:value-of select="$lng/awardedtenders"/></option>
									<option value="bordereaux"><xsl:value-of select="$lng/bordereaux"/></option>
									<option value="balance"><xsl:value-of select="$lng/balancescorecard"/></option>
									<option value="user_fees"><xsl:value-of select="$lng/fees"/></option>
								</select>
								<xsl:value-of select="' '"/>
								<input name="print" type="button" value="{$lng/print}" onclick="window.print()" class="t2"/>
							</td>
						</tr>	
				<xsl:choose>
					<xsl:when test="branch">
						<xsl:for-each select="branch">
							<tr>
								<td><br/></td>
								<td class="hb t1" colspan="21">
								<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
									<xsl:attribute name="colspan">22</xsl:attribute>
								</xsl:if>
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=branch&amp;function=profile&amp;id=',./branchid)"/>
										</xsl:attribute>
										<xsl:value-of select="branchname"/>
									</a>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="h1b t1">
									<xsl:value-of select="$lng/branch"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/subscriber"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/rfqreference"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/itemno"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/closedate"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/location"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/category"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/brand"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/model"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/rfqssent"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/quotesreceived"/>
								</td>							
								<td class="h1c t1">
									<xsl:value-of select="$lng/status"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/lowestprice"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/highestprice"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/spreadpercentage"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/saving"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/savingpercent"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/awardedposition"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/awardedprice"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/client"/>
								</td>
								<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
									<td class="h1c t1">
										<xsl:value-of select="$lng/transaction_fee"/>
									</td>
								</xsl:if>
							</tr>
							<xsl:variable name="branchid" select="branchid"/>
							<xsl:if test="../tender/tenderid">
								<xsl:for-each select="../tender">
									<xsl:if test="branchid=$branchid">
										<tr>
											<td><br/></td>
											<td class="h2b t2">
												<xsl:value-of select="branchname"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="subscriber"/>
											</td>										
											<td class="h2c t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
													</xsl:attribute>
													<xsl:value-of select="rfq_number"/>
												</a>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="rfq_reference"/>
											</td>																				
											<td class="h2c t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
													</xsl:attribute>
													<xsl:value-of select="id"/>
												</a>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="close_date"/><br/>
												<xsl:value-of select="close_time"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="statename"/><br/>
												<xsl:value-of select="areaname"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="categoryname"/><br/>
												<xsl:value-of select="category_subname"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="brand"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="model"/>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="sent"/>
											</td>								
											<td class="h2c t2" align="center">
												<xsl:value-of select="received"/>
											</td>												
											<td class="h2c t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
													</xsl:attribute>
													<xsl:call-template name="tender_item_icon">
														<xsl:with-param name="classification" select="classification"/>
														<xsl:with-param name="status" select="status"/>
														<xsl:with-param name="completestatus" select="complete_status"/>
														<xsl:with-param name="tenderclassification" select="tenderclassification"/>
													</xsl:call-template>
												</a>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="bestprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="worstprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="spread"/>%
											</td>
											<td class="h2c t2">
												<xsl:choose>
													<xsl:when test="quote='N/Q'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$localprecurrency"/><xsl:value-of select="saving"/><xsl:value-of select="$localpostcurrency"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2">
												<xsl:choose>
													<xsl:when test="quote='N/Q'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="saving_percent"/>%
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2" align="center">
												<xsl:choose>
													<xsl:when test="price='N/A'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="position_icon">
															<xsl:with-param name="position" select="quote_position"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2">
												<xsl:choose>
													<xsl:when test="price='N/A'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="$localpostcurrency"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2">
												<xsl:choose>
													<xsl:when test="price='N/A'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="client_title"/><xsl:value-of select="' '"/><xsl:value-of select="client_surname"/>
													</xsl:otherwise>
												</xsl:choose>											
											</td>
											<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
												<td class="h2c t2">
													<xsl:value-of select="$localprecurrency"/><xsl:value-of select="transaction_fee"/><xsl:value-of select="$localpostcurrency"/>
												</td>
											</xsl:if>
										</tr>
									</xsl:if>
								</xsl:for-each>
								<xsl:for-each select="../branch_calc">
									<xsl:if test="id=$branchid">
										<tr>
											<td><br/></td>
											<td colspan="9" class="h1b"><br/></td>
											<td class="h1c t1">
												<xsl:value-of select="$lng/total"/>
											</td>
											<td class="h1c t1" align="center">
												<xsl:value-of select="rfqcount"/> 
											</td>
											<td class="h1c t1" align="center">
												<xsl:value-of select="quotecount"/> 
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$lng/na"/> 
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="bestprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="worstprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h1c t1">
												<xsl:value-of select="spread"/>%
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="saving"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h1c t1">
												<xsl:value-of select="all/saving_percent"/>%
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$lng/na"/> 
											</td>							
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="awardedprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$lng/na"/> 
											</td>
										<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="format-number(transaction_fee,'#.##')"/><xsl:value-of select="$localpostcurrency"/>
											</td>
										</xsl:if>
										</tr>
									<xsl:if test="saving_project!=0 or saving_project!='NaN'">
										<tr>
											<td><br/></td>
											<td colspan="9" class="h1b"><br/></td>
											<td class="h1c t1" colspan="7">
												<xsl:value-of select="$lng/totalproject"/>
											</td>
											<td class="h1c t1" colspan="1">
												<xsl:value-of select="$localprecurrency"/><xsl:number value="saving_project" format="1"/><xsl:value-of select="$localpostcurrency"/>
											</td>
										</tr>
									</xsl:if>
									</xsl:if>
								</xsl:for-each>
								<tr><td><br/><br/></td></tr>
							</xsl:if>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="users">
						<xsl:for-each select="users">
							<tr>
								<td><br/></td>
								<td class="hb t1" colspan="21">
							<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
								<xsl:attribute name="colspan">22</xsl:attribute>
							</xsl:if>
									<a target="main">
										<xsl:attribute name="href">
											<xsl:value-of select="concat('./main.php?module=users&amp;function=profile&amp;id=',./usersid)"/>
										</xsl:attribute>
										<xsl:value-of select="name"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="surname"/>
									</a>
								</td>
							</tr>
							<tr>
								<td><br/></td>
								<td class="h1b t1">
									<xsl:value-of select="$lng/branch"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/subscriber"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/rfqreference"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/itemno"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/closedate"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/location"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/category"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/brand"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/model"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/rfqssent"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/quotesreceived"/>
								</td>							
								<td class="h1c t1">
									<xsl:value-of select="$lng/status"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/lowestprice"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/highestprice"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/spreadpercentage"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/saving"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/savingpercent"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/awardedposition"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/awardedprice"/>
								</td>
								<td class="h1c t1">
									<xsl:value-of select="$lng/client"/>
								</td>
								<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
									<td class="h1c t1">
										<xsl:value-of select="$lng/transaction_fee"/>
									</td>
								</xsl:if>
							</tr>
							<xsl:variable name="usersid" select="usersid"/>
							<xsl:if test="../tender/tenderid">
								<xsl:for-each select="../tender">
									<xsl:if test="usersid=$usersid">
										<tr>
											<td><br/></td>
											<td class="h2b t2">
												<xsl:value-of select="branchname"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="subscriber"/>
											</td>										
											<td class="h2c t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
													</xsl:attribute>
													<xsl:value-of select="rfq_number"/>
												</a>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="rfq_reference"/>
											</td>																				
											<td class="h2c t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
													</xsl:attribute>
													<xsl:value-of select="id"/>
												</a>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="close_date"/><br/>
												<xsl:value-of select="close_time"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="statename"/><br/>
												<xsl:value-of select="areaname"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="categoryname"/><br/>
												<xsl:value-of select="category_subname"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="brand"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="model"/>
											</td>
											<td class="h2c t2" align="center">
												<xsl:value-of select="sent"/>
											</td>								
											<td class="h2c t2" align="center">
												<xsl:value-of select="received"/>
											</td>												
											<td class="h2c t2">
												<a target="main">
													<xsl:attribute name="href">
														<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
													</xsl:attribute>
													<xsl:call-template name="tender_item_icon">
														<xsl:with-param name="classification" select="classification"/>
														<xsl:with-param name="status" select="status"/>
														<xsl:with-param name="completestatus" select="complete_status"/>
														<xsl:with-param name="tenderclassification" select="tenderclassification"/>
													</xsl:call-template>
												</a>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="bestprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="worstprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h2c t2">
												<xsl:value-of select="spread"/>%
											</td>
											<td class="h2c t2">
												<xsl:choose>
													<xsl:when test="quote='N/Q'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$localprecurrency"/><xsl:value-of select="saving"/><xsl:value-of select="$localpostcurrency"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2">
												<xsl:choose>
													<xsl:when test="quote='N/Q'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="saving_percent"/>%
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2" align="center">
												<xsl:choose>
													<xsl:when test="price='N/A'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="position_icon">
															<xsl:with-param name="position" select="quote_position"/>
														</xsl:call-template>						
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2">
												<xsl:choose>
													<xsl:when test="price='N/A'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="$localpostcurrency"/>
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td class="h2c t2">
												<xsl:choose>
													<xsl:when test="price='N/A'">
														<img src="./theme/{$theme}/icon/no.gif">
															<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
															<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
														</img>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="client_title"/><xsl:value-of select="' '"/><xsl:value-of select="client_surname"/>
													</xsl:otherwise>
												</xsl:choose>											
											</td>
											<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
												<td class="h2c t2">
													<xsl:value-of select="$localprecurrency"/><xsl:value-of select="transaction_fee"/><xsl:value-of select="$localpostcurrency"/>
												</td>
											</xsl:if>
										</tr>
									</xsl:if>
								</xsl:for-each>
								<xsl:for-each select="../users_calc">
									<xsl:if test="id=$usersid">
										<tr>
											<td><br/></td>
											<td colspan="9" class="h1b"><br/></td>
											<td class="h1c t1">
												<xsl:value-of select="$lng/total"/>
											</td>
											<td class="h1c t1" align="center">
												<xsl:value-of select="rfqcount"/>
											</td>
											<td class="h1c t1" align="center">
												<xsl:value-of select="quotecount"/> 
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$lng/na"/> 
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="bestprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="worstprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h1c t1">
												<xsl:value-of select="spread"/>%
											</td>
											<td class="h1c t1">											
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="saving"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h1c t1">
												<xsl:value-of select="saving_percent"/>%
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$lng/na"/> 
											</td>							
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="awardedprice"/><xsl:value-of select="$localpostcurrency"/>
											</td>
											<td class="h1c t1">
												<xsl:value-of select="$lng/na"/> 
											</td>								
										<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
											<td class="h1c t1">
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="format-number(transaction_fee,'#.##')"/><xsl:value-of select="$localpostcurrency"/>
											</td>
										</xsl:if>
										</tr>
									<xsl:if test="saving_project!=0 or saving_project!='NaN'">
										<tr>
											<td><br/></td>
											<td colspan="9" class="h1b"><br/></td>
											<td class="h1c t1" colspan="7">
												<xsl:value-of select="$lng/totalproject"/>
											</td>
											<td class="h1c t1" colspan="1">
												<xsl:value-of select="$localprecurrency"/><xsl:number value="saving_project" format="1"/><xsl:value-of select="$localpostcurrency"/>
											</td>
										</tr>
									</xsl:if>
									</xsl:if>
								</xsl:for-each>
								<tr><td><br/><br/></td></tr>
							</xsl:if>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<tr>
							<td><br/></td>
								<td class="hb t1">
									<xsl:value-of select="$lng/branch"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/subscriber"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/rfqnumber"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/rfqreference"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/itemno"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/closedate"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/location"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/category"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/brand"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/model"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/rfqssent"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/quotesreceived"/>
								</td>							
								<td class="hc t1">
									<xsl:value-of select="$lng/status"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/lowestprice"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/highestprice"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/spreadpercentage"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/saving"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/savingpercent"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/awardedposition"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/awardedprice"/>
								</td>
								<td class="hc t1">
									<xsl:value-of select="$lng/client"/>
								</td>
								<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
									<td class="hc t1">
										<xsl:value-of select="$lng/transaction_fee"/>
									</td>
								</xsl:if>
							</tr>
						<xsl:if test="tender/tenderid">
							<xsl:for-each select="tender">
								<tr>
									<td><br/></td>
									<td class="h2b t2">
										<xsl:value-of select="branchname"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="subscriber"/>
									</td>										
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="rfq_reference"/>
									</td>																				
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
											</xsl:attribute>
											<xsl:value-of select="id"/>
										</a>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="close_date"/><br/>
										<xsl:value-of select="close_time"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="statename"/><br/>
										<xsl:value-of select="areaname"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="categoryname"/><br/>
										<xsl:value-of select="category_subname"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="brand"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="model"/>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="sent"/>
									</td>								
									<td class="h2c t2" align="center">
										<xsl:value-of select="received"/>
									</td>												
									<td class="h2c t2">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
											</xsl:attribute>
											<xsl:call-template name="tender_item_icon">
												<xsl:with-param name="classification" select="classification"/>
												<xsl:with-param name="status" select="status"/>
												<xsl:with-param name="completestatus" select="complete_status"/>
												<xsl:with-param name="tenderclassification" select="tenderclassification"/>
											</xsl:call-template>
										</a>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="$localprecurrency"/><xsl:value-of select="bestprice"/><xsl:value-of select="$localpostcurrency"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="$localprecurrency"/><xsl:value-of select="worstprice"/><xsl:value-of select="$localpostcurrency"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="spread"/>%
									</td>
									<td class="h2c t2">
										<xsl:choose>
											<xsl:when test="quote='N/Q'">
												<img src="./theme/{$theme}/icon/no.gif">
													<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
													<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
												</img>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="saving"/><xsl:value-of select="$localpostcurrency"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2">
										<xsl:choose>
											<xsl:when test="quote='N/Q'">
												<img src="./theme/{$theme}/icon/no.gif">
													<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
													<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
												</img>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="saving_percent"/>%
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2" align="center">
										<xsl:choose>
											<xsl:when test="price='N/A'">
												<img src="./theme/{$theme}/icon/no.gif">
													<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
													<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
												</img>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="position_icon">
													<xsl:with-param name="position" select="quote_position"/>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2">
										<xsl:choose>
											<xsl:when test="price='N/A'">
												<img src="./theme/{$theme}/icon/no.gif">
													<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
													<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
												</img>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="$localpostcurrency"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c t2">
									<xsl:choose>
										<xsl:when test="price='N/A'">
											<img src="./theme/{$theme}/icon/no.gif">
												<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
												<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
											</img>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="client_title"/><xsl:value-of select="' '"/><xsl:value-of select="client_surname"/>
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
									<td class="h2c t2">
										<xsl:value-of select="$localprecurrency"/><xsl:value-of select="transaction_fee"/><xsl:value-of select="$localpostcurrency"/>
									</td>
								</xsl:if>
							</tr>
						</xsl:for-each>
						<tr>
							<td><br/></td>
							<td colspan="9" class="h1b"><br/></td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/total"/>
							</td>
							<td class="h1c t1" align="center">
								<xsl:value-of select="all/rfqcount"/> 
							</td>
							<td class="h1c t1" align="center">
								<xsl:value-of select="all/quotecount"/> 
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/na"/> 
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/bestprice"/><xsl:value-of select="$localpostcurrency"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/worstprice"/><xsl:value-of select="$localpostcurrency"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="all/spread"/>%
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/saving"/><xsl:value-of select="$localpostcurrency"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="all/saving_percent"/>%
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/na"/> 
							</td>							
							<td class="h1c t1">
								<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/awardedprice"/><xsl:value-of select="$localpostcurrency"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/na"/> 
							</td>
						<xsl:if test="/response/user/classification='3' or /response/user/permission='4'">
							<td class="h1c t1">
								<xsl:value-of select="$localprecurrency"/><xsl:value-of select="format-number(all/transaction_fee,'#.##')"/><xsl:value-of select="$localpostcurrency"/>
							</td>
						</xsl:if>
						</tr>
					<xsl:if test="all/saving_project!=0">
						<tr>
							<td><br/></td>
							<td colspan="9" class="h1b"><br/></td>
							<td class="h1c t1" colspan="7">
								<xsl:value-of select="$lng/totalproject"/>
							</td>
							<td class="h1c t1" colspan="1">
								<xsl:value-of select="$localprecurrency"/><xsl:number value="all/saving_project" format="1"/><xsl:value-of select="$localpostcurrency"/>
							</td>
						</tr>
					</xsl:if>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function gotoreport() {
			var otherreport = document.report.reporttype.value;
			var startdate = "<xsl:value-of select="reportinfo/startdate"/>";
			var enddate = "<xsl:value-of select="reportinfo/enddate"/>";
			var URL = "./main.php?module=report&amp;function=company&amp;reporttype=" + otherreport+"&amp;display=1"+"&amp;reportformat=online"+"&amp;startdate=" + startdate + "&amp;enddate=" + enddate;
			<xsl:if test="reportinfo/stateid != 0">
				URL += "&amp;stateid=" + <xsl:value-of select="reportinfo/stateid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/areaid != 0">
				URL += "&amp;areaid=" + <xsl:value-of select="reportinfo/areaid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/branchid != 0">
				URL += "&amp;branchid=" + <xsl:value-of select="reportinfo/branchid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/usersid != 0">
				URL += "&amp;usersid=" + <xsl:value-of select="reportinfo/usersid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/firstsort">
				URL += "&amp;firstsort=" + "<xsl:value-of select="reportinfo/firstsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/secondsort">
				URL += "&amp;secondsort=" + "<xsl:value-of select="reportinfo/secondsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/group">
				URL += "&amp;group=" + "<xsl:value-of select="reportinfo/group"/>";
			</xsl:if>
			<xsl:if test="reportinfo/organisationid">
				URL += "&amp;organisationid=" + <xsl:value-of select="reportinfo/organisationid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/rfqnumber">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqnumber"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/rfqreference">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqreference"/>";
			</xsl:if>
			parent.main.location.href = URL;
		}		
	</script>		
</body>
</html>

</xsl:template>

</xsl:stylesheet>
