<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<xsl:variable name="localprecurrency" select="localprecurrency"/>
<xsl:variable name="localpostcurrency" select="localpostcurrency"/>
<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/balancescorereport"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/oftendersbetween"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="startdate"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/and"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="enddate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="show_tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td colspan="12" valign="top">
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
								<tr>
									<td class="h t1" align="right" colspan="6">
										<xsl:value-of select="$lng/selectotherreport"/><xsl:value-of select="': '"/>
			
										<select name="reporttype" class="t1" onchange="gotoreport()">
											<xsl:if test="reporttype">
												<xsl:for-each select="reporttype">
													<option value="{value}">
														<xsl:value-of select="name"/>
													</option>
												</xsl:for-each>
											</xsl:if>
											<option value="audit"><xsl:value-of select="$lng/audittrail"/></option>
											<option value="close"><xsl:value-of select="$lng/closedtenders"/></option>
											<option value="awarded"><xsl:value-of select="$lng/awardedtenders"/></option>
											<option value="bordereaux"><xsl:value-of select="$lng/bordereaux"/></option>
											<option value="balance"><xsl:attribute name="selected"/><xsl:value-of select="$lng/balancescorecard"/></option>
											<option value="user_fees"><xsl:value-of select="$lng/fees"/></option>
										</select>
										<xsl:value-of select="' '"/>
										<input name="print" type="button" value="{$lng/print}" onclick="window.print()" class="t2"/>
									</td>
								</tr>
								<tr>
									<td class="h t1" colspan="6">
										<xsl:value-of select="$lng/scoresummary"/>
									</td>
								</tr>
								<tr>
									<td class="h1b t1">
										<xsl:value-of select="$lng/supplier"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/arating"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/brating"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/crating"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/drating"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/erating"/>
									</td>
								</tr>
								<xsl:for-each select="supplier">
									<tr>
										<td class="h2b t2">
											<xsl:value-of select="name"/>
										</td>
										<td class="h2c t2">
											<xsl:if test="A!=''">
												<xsl:value-of select="../localprecurrency"/>
												<xsl:value-of select="A"/>
												<xsl:value-of select="../localpostcurrency"/>
											</xsl:if>
										</td>
										<td class="h2c t2">
											<xsl:if test="B!=''">
												<xsl:value-of select="../localprecurrency"/>
												<xsl:value-of select="B"/>
												<xsl:value-of select="../localpostcurrency"/>													
											</xsl:if>
										</td>
										<td class="h2c t2">
											<xsl:if test="C!=''">
												<xsl:value-of select="../localprecurrency"/>
												<xsl:value-of select="C"/>
												<xsl:value-of select="../localpostcurrency"/>
											</xsl:if>
										</td>
										<td class="h2c t2">
											<xsl:if test="D!=''">
												<xsl:value-of select="../localprecurrency"/>
												<xsl:value-of select="D"/>
												<xsl:value-of select="../localpostcurrency"/>
											</xsl:if>
										</td>
										<td class="h2c t2">
											<xsl:if test="E!=''">
												<xsl:value-of select="../localprecurrency"/>
												<xsl:value-of select="E"/>
												<xsl:value-of select="../localpostcurrency"/>
											</xsl:if>
										</td>
									</tr>
								</xsl:for-each>
								<tr>
									<td class="h2b t1">
										<xsl:value-of select="$lng/total"/>
									</td>
									<td class="h2c t1">
									<xsl:choose>
										<xsl:when test="A/total">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="A/total"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="'0.00'"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:otherwise>
									</xsl:choose>
									</td>
									<td class="h2c t1">
									<xsl:choose>
										<xsl:when test="B/total">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="B/total"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="'0.00'"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:otherwise>
									</xsl:choose>
									</td>
									<td class="h2c t1">
									<xsl:choose>
										<xsl:when test="C/total">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="C/total"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="'0.00'"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:otherwise>
									</xsl:choose>
									</td>
									<td class="h2c t1">
									<xsl:choose>
										<xsl:when test="D/total">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="D/total"/>
											<xsl:value-of select="localpostcurrency"/>	
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="'0.00'"/>
											<xsl:value-of select="localpostcurrency"/>	
										</xsl:otherwise>
									</xsl:choose>
									</td>
									<td class="h2c t1">
									<xsl:choose>
										<xsl:when test="E/total">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="E/total"/>
											<xsl:value-of select="localpostcurrency"/>											
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="'0.00'"/>
											<xsl:value-of select="localpostcurrency"/>											
										</xsl:otherwise>
									</xsl:choose>
									</td>
								</tr>
								<tr>
									<td class="h2b t1">
										<xsl:value-of select="$lng/factor"/>
									</td>
									<td class="h2c t1">
										<xsl:if test="A/factor">
											<xsl:value-of select="A/factor"/><xsl:value-of select="'%'"/>
										</xsl:if>
									</td>
									<td class="h2c t1">
										<xsl:if test="B/factor">
											<xsl:value-of select="B/factor"/><xsl:value-of select="'%'"/>
										</xsl:if>
									</td>
									<td class="h2c t1">
										<xsl:if test="C/factor">
											<xsl:value-of select="C/factor"/><xsl:value-of select="'%'"/>
										</xsl:if>
									</td>
									<td class="h2c t1">
										<xsl:if test="D/factor">
											<xsl:value-of select="D/factor"/><xsl:value-of select="'%'"/>
										</xsl:if>
									</td>
									<td class="h2c t1">
										<xsl:if test="E/factor">
											<xsl:value-of select="E/factor"/><xsl:value-of select="'%'"/>
										</xsl:if>
									</td>
								</tr>
								<tr>
									<td class="h2b t1">
										<xsl:value-of select="$lng/totalfactor"/>
									</td>
									<td class="h2c t1">
										<xsl:if test="A/total_factor">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="A/total_factor"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:if>
									</td>
									<td class="h2c t1">
										<xsl:if test="B/total_factor">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="B/total_factor"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:if>
									</td>
									<td class="h2c t1">
										<xsl:if test="C/total_factor">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="C/total_factor"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:if>
									</td>
									<td class="h2c t1">
										<xsl:if test="D/total_factor">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="D/total_factor"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:if>
									</td>
									<td class="h2c t1">
										<xsl:if test="E/total_factor">
											<xsl:value-of select="localprecurrency"/>
											<xsl:value-of select="E/total_factor"/>
											<xsl:value-of select="localpostcurrency"/>
										</xsl:if>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td><br/></td>
						<td colspan="12" valign="top">
							<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
								<tr>
									<td class="h t1" colspan="4">
										<xsl:value-of select="$lng/ratings"/>
									</td>
								</tr>
								<tr>
									<td class="h1b t1">
										<xsl:value-of select="$lng/score"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/ratings"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/des"/>
									</td>
									<td class="h1c t1">
										<xsl:value-of select="$lng/factorweighting"/>
									</td>
								</tr>
								<tr>
									<td class="h2b t2">
										<xsl:value-of select="A/start"/>
										<xsl:value-of select="' &lt; '"/>
										<xsl:value-of select="$lng/score"/>
										<xsl:value-of select="' &lt;= '"/>
										<xsl:value-of select="A/end"/>
									</td>
									<td class="h2c t2">										
										<xsl:value-of select="$lng/arating"/>
									</td>
									<td class="h2c t2">
										<textarea readonly="readonly" class="t2 readonly">
										<xsl:value-of select="$lng/aratingdes"/>
										</textarea>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="A/factor"/>
									</td>
								</tr>
								<tr>
									<td class="h2b t2">
										<xsl:value-of select="B/start"/>
										<xsl:value-of select="' &lt; '"/>
										<xsl:value-of select="$lng/score"/>
										<xsl:value-of select="' &lt;= '"/>
										<xsl:value-of select="B/end"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="$lng/brating"/>
									</td>
									<td class="h2c t2">
										<textarea readonly="readonly" class="t2 readonly">
										<xsl:value-of select="$lng/bratingdes"/>
										</textarea>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="B/factor"/>
									</td>
								</tr>
								<tr>
									<td class="h2b t2">
										<xsl:value-of select="C/start"/>
										<xsl:value-of select="' &lt; '"/>
										<xsl:value-of select="$lng/score"/>
										<xsl:value-of select="' &lt;= '"/>
										<xsl:value-of select="C/end"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="$lng/crating"/>
									</td>
									<td class="h2c t2">
										<textarea readonly="readonly" class="t2 readonly">
										<xsl:value-of select="$lng/cratingdes"/>
										</textarea>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="C/factor"/>
									</td>
								</tr>
								<tr>
									<td class="h2b t2">
										<xsl:value-of select="D/start"/>
										<xsl:value-of select="' &lt; '"/>
										<xsl:value-of select="$lng/score"/>
										<xsl:value-of select="' &lt;= '"/>
										<xsl:value-of select="D/end"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="$lng/drating"/>
									</td>
									<td class="h2c t2">
										<textarea readonly="readonly" class="t2 readonly">
										<xsl:value-of select="$lng/dratingdes"/>
										</textarea>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="D/factor"/>
									</td>
								</tr>
								<tr>
									<td class="h2b t2">
										<xsl:value-of select="E/start"/>
										<xsl:value-of select="' &lt; '"/>
										<xsl:value-of select="$lng/score"/>
										<xsl:value-of select="' &lt;= '"/>
										<xsl:value-of select="E/end"/>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="$lng/erating"/>
									</td>
									<td class="h2c t2">
										<textarea readonly="readonly" class="t2 readonly">
										<xsl:value-of select="$lng/eratingdes"/>
										</textarea>
									</td>
									<td class="h2c t2">
										<xsl:value-of select="E/factor"/>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr><td><br/></td></tr>
					<xsl:for-each select="branch">
						<tr>
							<td><br/></td>
							<td class="h t1" colspan="12">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=branch&amp;function=profile&amp;id=',./branchid)"/>
									</xsl:attribute>
									<xsl:value-of select="branchname"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/tender"/><br/>
								<xsl:value-of select="$lng/item"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/startdate"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/category"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/brand"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/model"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/status"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/quote"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/bestprice"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/saving"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/savingpercent"/>
							</td>
						</tr>
						<xsl:variable name="branchid" select="branchid"/>
						<xsl:if test="../tender/tenderid">
							<xsl:for-each select="../tender">
								<xsl:if test="branchid=$branchid">
									<tr>
										<td><br/></td>
										<td class="h2b t2" align="center">
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
												</xsl:attribute>
												<xsl:value-of select="id"/>
											</a>
										</td>
										<td class="h2c t2" align="center">
											<a target="main">
												<xsl:attribute name="href">
													<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./tenderid)"/>
												</xsl:attribute>
												<xsl:value-of select="rfq_number"/>
											</a>
										</td>
										<td class="h2c t2" align="center">
											<xsl:value-of select="close_date"/><br/>
											<xsl:value-of select="close_time"/>
										</td>
										<td class="h2c t2" align="center">
											<xsl:value-of select="statename"/><br/>
											<xsl:value-of select="areaname"/>
										</td>
										<td class="h2c t2" align="center">
											<xsl:value-of select="categoryname"/><br/>
											<xsl:value-of select="category_subname"/>
										</td>
										<td class="h2c t2" align="center">
											<xsl:value-of select="brand"/>
										</td>
										<td class="h2c t2" align="center">
											<xsl:value-of select="model"/>
										</td>
										<td class="h2c t2" align="center">
											<xsl:call-template name="tender_item_icon">
												<xsl:with-param name="classification" select="classification"/>
												<xsl:with-param name="status" select="status"/>
												<xsl:with-param name="completestatus" select="complete_status"/>
												<xsl:with-param name="tenderclassification" select="tenderclassification"/>
											</xsl:call-template>
										</td>
										<td class="h2c t2" align="center">
											<xsl:choose>
												<xsl:when test="quote='N/Q'">
													<img src="./theme/{$theme}/icon/noquote.gif">
														<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
														<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
													</img>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="$localprecurrency"/><xsl:value-of select="quote"/><xsl:value-of select="$localpostcurrency"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="h2c t2" align="center">
											<xsl:value-of select="$localprecurrency"/><xsl:value-of select="bestprice"/><xsl:value-of select="$localpostcurrency"/>
										</td>
										<td class="h2c t2" align="center">
											<xsl:choose>
												<xsl:when test="quote='N/Q'">
													<img src="./theme/{$theme}/icon/noquote.gif">
														<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
														<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
													</img>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="$localprecurrency"/><xsl:value-of select="saving"/><xsl:value-of select="$localpostcurrency"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="h2c t2" align="center">
											<xsl:choose>
												<xsl:when test="quote='N/Q'">
													<img src="./theme/{$theme}/icon/noquote.gif">
														<xsl:attribute name="alt"><xsl:value-of select="$lng/nq"/></xsl:attribute>
														<xsl:attribute name="title"><xsl:value-of select="$lng/noquote"/></xsl:attribute>
													</img>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="saving_percent"/>%
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
							<xsl:for-each select="../branch_calc">
								<xsl:if test="id=$branchid">
									<tr>
										<td><br/></td>
										<td colspan="7" class="h1b"><br/></td>
										<td class="h1c t1" align="center">
											<xsl:value-of select="$lng/total"/>
										</td>
										<td class="h1c t1" align="center">
											<xsl:value-of select="$localprecurrency"/><xsl:value-of select="quote"/><xsl:value-of select="$localpostcurrency"/>
										</td>
										<td class="h1c t1" align="center">
											<xsl:value-of select="$localprecurrency"/><xsl:value-of select="bestprice"/><xsl:value-of select="$localpostcurrency"/>
										</td>
										<td class="h1c t1" align="center">
											<xsl:value-of select="$localprecurrency"/><xsl:value-of select="saving"/><xsl:value-of select="$localpostcurrency"/>
										</td>
										<td class="h1c t1" align="center">
											<xsl:value-of select="saving_percent"/>%
										</td>
									</tr>
									<tr>
										<td><br/></td>
										<td colspan="9" class="h1b"><br/></td>
										<td class="h1c t1" align="center" colspan="5">
											<xsl:value-of select="$lng/totalproject"/> : <xsl:value-of select="$localprecurrency"/><xsl:number value="saving_project" format="1"/><xsl:value-of select="$localpostcurrency"/>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
							<tr><td><br/><br/></td></tr>
						</xsl:if>
					</xsl:for-each>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function gotoreport() {
			var otherreport = document.report.reporttype.value;
			var startdate = "<xsl:value-of select="reportinfo/startdate"/>";
			var enddate = "<xsl:value-of select="reportinfo/enddate"/>";
			var URL = "./main.php?module=report&amp;function=company&amp;reporttype=" + otherreport+"&amp;display=1"+"&amp;reportformat=online"+"&amp;startdate=" + startdate + "&amp;enddate=" + enddate;
			<xsl:if test="reportinfo/stateid != 0">
				URL += "&amp;stateid=" + <xsl:value-of select="reportinfo/stateid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/areaid != 0">
				URL += "&amp;areaid=" + <xsl:value-of select="reportinfo/areaid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/branchid != 0">
				URL += "&amp;branchid=" + <xsl:value-of select="reportinfo/branchid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/usersid != 0">
				URL += "&amp;usersid=" + <xsl:value-of select="reportinfo/usersid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/firstsort">
				URL += "&amp;firstsort=" + "<xsl:value-of select="reportinfo/firstsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/secondsort">
				URL += "&amp;secondsort=" + "<xsl:value-of select="reportinfo/secondsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/group">
				URL += "&amp;group=" + "<xsl:value-of select="reportinfo/group"/>";
			</xsl:if>
			<xsl:if test="reportinfo/organisationid">
				URL += "&amp;organisationid=" + <xsl:value-of select="reportinfo/organisationid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/rfqnumber">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqnumber"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/rfqreference">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqreference"/>";
			</xsl:if>
			parent.main.location.href = URL;
		}		
	</script>		
</body>
</html>

</xsl:template>

</xsl:stylesheet>
