<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/bordereauxreport"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/bordereauxreport"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/oftendersbetween"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="startdate"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/and"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="enddate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="bordereaux"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="t1" align="right" colspan="6">
								<xsl:value-of select="$lng/selectotherreport"/><xsl:value-of select="': '"/>
								<select name="reporttype" class="t1" onchange="gotoreport()">
									<xsl:if test="reporttype">
										<xsl:for-each select="reporttype">
											<option value="{value}">
												<xsl:value-of select="name"/>
											</option>
										</xsl:for-each>
									</xsl:if>
									<option value="audit"><xsl:value-of select="$lng/audittrail"/></option>
									<option value="close"><xsl:value-of select="$lng/closedtenders"/></option>
									<option value="awarded"><xsl:value-of select="$lng/awardedtenders"/></option>
									<option value="bordereaux"><xsl:attribute name="selected"/><xsl:value-of select="$lng/bordereaux"/></option>
									<option value="balance"><xsl:value-of select="$lng/balancescorecard"/></option>
									<option value="user_fees"><xsl:value-of select="$lng/fees"/></option>
								</select>
								<xsl:value-of select="' '"/>
								<input name="print" type="button" value="{$lng/print}" onclick="window.print()" class="t2"/>
							</td>
						</tr>
						<xsl:if test="updated='1'">
							<tr>
								<td><br/></td>
								<td class="t1" colspan="6">
									<xsl:value-of select="$lng/updatedinfo"/>
								</td>
							</tr>
						</xsl:if>
						<tr>
							<td><br/></td>
							<td class="h t1" colspan="6">
								<xsl:value-of select="$lng/bordereauxsummary"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1">
								<xsl:value-of select="$lng/agent"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/awarded"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/awaiting"/><br/>
								<xsl:value-of select="$lng/invoice"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/awaiting"/><br/>
								<xsl:value-of select="$lng/payment"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/paid"/>
							</td>
							<td class="h1c t1">
								<xsl:value-of select="$lng/check"/>
							</td>
						</tr>
						<xsl:if test="agent_sum/id">
							<xsl:for-each select="agent_sum">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./id)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="surname"/>
										</a>
									</td>
									<td class="h2c t2" align="right">
										<xsl:value-of select="awarded"/>
									</td>
									<td class="h2c t2" align="right">
										<xsl:value-of select="invoice"/>
									</td>
									<td class="h2c t2" align="right">
										<xsl:value-of select="payment"/>
									</td>
									<td class="h2c t2" align="right">
										<xsl:value-of select="paid"/>
									</td>
									<td class="h2c t2" align="center">
										<xsl:if test="(awarded - invoice - payment - paid) = 0">
											<img src="./theme/{$theme}/icon/yes.gif" border="0">
												<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/ok"/></xsl:attribute>
											</img>
										</xsl:if>
										<xsl:if test="(awarded - invoice - payment - paid) != 0">
											<img src="./theme/{$theme}/icon/no.gif" border="0">
												<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/bad"/></xsl:attribute>
											</img>
										</xsl:if>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td class="h1b t1" align="center">
									<xsl:value-of select="$lng/total"/>
								</td>
								<td class="h1c t1" align="right">
									<xsl:value-of select="total_sum/awarded"/>
								</td>
								<td class="h1c t1" align="right">
									<xsl:value-of select="total_sum/invoice"/>
								</td>
								<td class="h1c t1" align="right">
									<xsl:value-of select="total_sum/payment"/>
								</td>
								<td class="h1c t1" align="right">
									<xsl:value-of select="total_sum/paid"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:if test="(total_sum/awarded - total_sum/invoice - total_sum/payment - total_sum/paid) = 0">
										<img src="./theme/{$theme}/icon/yes.gif" border="0">
											<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/ok"/></xsl:attribute>
										</img>
									</xsl:if>
									<xsl:if test="(total_sum/awarded - total_sum/invoice - total_sum/payment - total_sum/paid) != 0">
										<img src="./theme/{$theme}/icon/no.gif" border="0">
											<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/bad"/></xsl:attribute>
										</img>
									</xsl:if>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="agent_sum/id">
							<xsl:for-each select="agent_sum">
								<tr>
									<td><br/></td>
								</tr>
								<tr>
									<td><br/></td>
									<td class="h t1" colspan="11">
										<xsl:value-of select="$lng/awarded"/>
										(<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./id)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="surname"/>
										</a>)
									</td>
								</tr>
								<tr>
									<td><br/></td>
									<td colspan="6" class="h2b">
										<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
											<tr>
												<td></td>
											</tr>
											<xsl:variable name="agentid" select="id"/>
											<xsl:for-each select="../tender_sum">
												<xsl:if test="$agentid=agentid">
													<tr>
														<td><br/></td>
														<td class="h1 t1" colspan="6" align="center">
															<xsl:value-of select="$lng/rfqnumber"/> : 
															<a target="main">
																<xsl:attribute name="href">
																	<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./id)"/>
																</xsl:attribute>
																<xsl:value-of select="rfq_number"/>
															</a>
														</td>
														<td class="h1a t1" colspan="5" align="center">
															<xsl:value-of select="$lng/purchase_order"/> : <xsl:value-of select="purchase_order"/>
														</td>
														<td><br/></td>
													</tr>
													<tr>
														<td><br/></td>
														<td class="h1b t1">
															<xsl:value-of select="$lng/tenderitem"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/dateawarded"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/category"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/brand"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/model"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/des"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/position"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/status"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/invoice"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/paid"/>
														</td>
														<td class="h1c t1">
															<xsl:value-of select="$lng/price"/>
														</td>
														<td><br/></td>
													</tr>
													<xsl:variable name="tenderid" select="id"/>
													<xsl:variable name="purchase_order" select="purchase_order"/>
													<xsl:for-each select="../tender_quote">
														<xsl:if test="tenderid=$tenderid and $purchase_order=purchase_order">
															<tr>
																<td><br/></td>
																<td class="h2b t2" align="center">
																	<a target="main">
																		<xsl:attribute name="href">
																			<xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./id)"/>
																		</xsl:attribute>
																		<xsl:value-of select="id"/>
																	</a>
																</td>
																<td class="h2c t2" align="center">
																	<xsl:value-of select="complete_date"/><br/>
																	<xsl:value-of select="complete_time"/>
																</td>
																<td class="h2c t2" align="center">
																	<xsl:value-of select="categoryname"/><br/>
																	<xsl:value-of select="category_subname"/>
																</td>
																<td class="h2c t2" align="center">
																	<xsl:value-of select="brand"/>
																</td>
																<td class="h2c t2" align="center">
																	<xsl:value-of select="model"/>
																</td>
																<td class="h2c t2" align="center">
																	<xsl:value-of select="description"/>
																</td>
																<td class="h2c t" align="left" valign="top">
																	<xsl:call-template name="position_icon">
																		<xsl:with-param name="position" select="quote_position"/>
																	</xsl:call-template>
																</td>
																<td class="h2c t2" align="center">
																	<a target="main">
																		<xsl:attribute name="href">
																			<xsl:value-of select="concat('./main.php?module=procure&amp;function=quote_profile&amp;id=',./quoteid)"/>
																		</xsl:attribute>
																		<xsl:call-template name="tender_quote_icon">
																			<xsl:with-param name="classification" select="classification"/>
																			<xsl:with-param name="status" select="status"/>
																			<xsl:with-param name="tenderclassification" select="tenderclassification"/>
																			<xsl:with-param name="itemclassification" select="itemclassification"/>
																		</xsl:call-template>
																	</a>
																</td>
																<td class="h2c t2" align="center">
																	<xsl:choose>
																		<xsl:when test="invoice_user=0 or invoice_user=''">
																			<input type="checkbox">
																				<xsl:attribute name="name">invoice_user[<xsl:value-of select="id"/>]</xsl:attribute>
																			</input>
																		</xsl:when>
																		<xsl:otherwise>
																			<img src="./theme/{$theme}/icon/yes.gif" border="0">
																				<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/ok"/></xsl:attribute>
																			</img>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td class="h2c t2" align="center">
																	<xsl:choose>
																		<xsl:when test="payment_user=0 or payment_user=''">
																			<input type="checkbox">
																				<xsl:attribute name="name">payment_user[<xsl:value-of select="id"/>]</xsl:attribute>
																			</input>
																		</xsl:when>
																		<xsl:otherwise>
																			<img src="./theme/{$theme}/icon/yes.gif" border="0">
																				<xsl:attribute name="alt"><xsl:value-of select="' '"/><xsl:value-of select="$lng/ok"/></xsl:attribute>
																			</img>
																		</xsl:otherwise>
																	</xsl:choose>
																</td>
																<td class="h2c t2" align="center">
																	<xsl:value-of select="price"/>
																</td>
																<td><br/></td>
															</tr>
														</xsl:if>
													</xsl:for-each>
													<tr>
														<td><br/></td>
														<td class="h2b t1" align="right" colspan="10">
															<xsl:value-of select="$lng/total"/>
														</td>
														<td class="h2c t1" align="center">
															<xsl:value-of select="total"/>
														</td>
														<td><br/></td>
													</tr>
													<tr>
														<td><br/></td>
														<td class="h2b t1" align="right" colspan="10">
															<xsl:value-of select="$lng/lessexcess"/>
														</td>
														<td class="h2c t1" align="center">
															<xsl:value-of select="excess"/>
														</td>
														<td><br/></td>
													</tr>
													<tr>
														<td><br/></td>
														<td class="h2b t1" align="right" colspan="10">
															<xsl:value-of select="$lng/payable"/>
														</td>
														<td class="h2c t1" align="center">
															<xsl:value-of select="payable"/>
														</td>
														<td><br/></td>
													</tr>
													<tr><td></td></tr>
												</xsl:if>
											</xsl:for-each>
										</table>
									</td>
								</tr>
								<tr>
									<td><br/></td>
									<td class="h2b t1" align="left">
										<xsl:value-of select="$lng/awarded"/>:
										<xsl:value-of select="awarded"/>
									</td>
									<td class="h2c t1" align="left">
										<xsl:value-of select="$lng/awaiting"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="$lng/invoice"/>:
										<xsl:value-of select="invoice"/>
									</td>
									<td class="h2c t1" align="left">
										<xsl:value-of select="$lng/awaiting"/>
										<xsl:value-of select="' '"/>
										<xsl:value-of select="$lng/payment"/>:
										<xsl:value-of select="payment"/>
									</td>
									<td class="h2c t1" align="left" colspan="3">
										<xsl:value-of select="$lng/paid"/>:
										<xsl:value-of select="paid"/>
									</td>
								</tr>
								<tr>
									<td><br/></td>
								</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td align="right" width="270" colspan="6">
									<input type="submit" name="submit" class="t2">
										<xsl:attribute name="value">
											<xsl:value-of select="$lng/submit"/>
										</xsl:attribute>
									</input>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function gotoreport() {
			var otherreport = document.report.reporttype.value;
			var startdate = "<xsl:value-of select="reportinfo/startdate"/>";
			var enddate = "<xsl:value-of select="reportinfo/enddate"/>";
			var URL = "./main.php?module=report&amp;function=company&amp;reporttype=" + otherreport+"&amp;display=1"+"&amp;reportformat=online"+"&amp;startdate=" + startdate + "&amp;enddate=" + enddate;
			<xsl:if test="reportinfo/stateid != 0">
				URL += "&amp;stateid=" + <xsl:value-of select="reportinfo/stateid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/areaid != 0">
				URL += "&amp;areaid=" + <xsl:value-of select="reportinfo/areaid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/branchid != 0">
				URL += "&amp;branchid=" + <xsl:value-of select="reportinfo/branchid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/usersid != 0">
				URL += "&amp;usersid=" + <xsl:value-of select="reportinfo/usersid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/firstsort">
				URL += "&amp;firstsort=" + "<xsl:value-of select="reportinfo/firstsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/secondsort">
				URL += "&amp;secondsort=" + "<xsl:value-of select="reportinfo/secondsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/group">
				URL += "&amp;group=" + "<xsl:value-of select="reportinfo/group"/>";
			</xsl:if>
			<xsl:if test="reportinfo/organisationid">
				URL += "&amp;organisationid=" + <xsl:value-of select="reportinfo/organisationid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/rfqnumber">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqnumber"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/rfqreference">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqreference"/>";
			</xsl:if>
			parent.main.location.href = URL;
		}		
	</script>	
</body>
</html>

</xsl:template>

</xsl:stylesheet>
