<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:param name="usersid" select="/response/user/usersid"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../procure/templates/procure_status.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/closedtendersreport"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/oftendersbetween"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="startdate"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/and"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="enddate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="show_tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
				<xsl:if test="tender/id">
					<xsl:for-each select="tender">
						<tr>
							<td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/rfqnumber"/><br/>
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="rfq_number"/>
								<br/>
								<xsl:value-of select="rfq_reference"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/created"/><br/><xsl:value-of select="$lng/closed"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="created_on"/><br/><xsl:value-of select="close_on"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/state"/><br/><xsl:value-of select="$lng/area"/>
							</td>
							<td class="ha t2">
								<xsl:value-of select="statename"/><br/><xsl:value-of select="areaname"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/subscriber"/><br/><xsl:value-of select="$lng/organisation"/>
							</td>
							<td class="ha t2">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a><br/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./organisationid)"/>
									</xsl:attribute>
									<xsl:value-of select="organisationname"/>
								</a>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/email"/><br/>
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td class="ha t2">
								<a>
									<xsl:attribute name="href"><xsl:value-of select="concat('mailto:',./email)"/></xsl:attribute>
									<xsl:value-of select="email"/>
								</a><br/>
								<a>
									<xsl:attribute name="href"><xsl:value-of select="'callto://+'"/><xsl:value-of select="phone_prefix"/><xsl:number value="phone_work" format="1"/></xsl:attribute>
									<xsl:value-of select="phone_work"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="10" class="h2b">
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
									<xsl:variable name="tenderid" select="id"/>
									<xsl:variable name="tenderclassification" select="classification"/>
									<xsl:for-each select="../agent">
										<xsl:if test="$tenderid=tenderid">
											<tr>
												<td class="h1 t1" align="center">
													<xsl:value-of select="$lng/agent"/>
												</td>
												<td class="h1a t2" align="center" colspan="2">
													<a target="main">
														<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=user&amp;function=item_profile&amp;id=',./id)"/></xsl:attribute>
														<xsl:if test="$usersid=id">
															<xsl:value-of select="$lng/you"/>
														</xsl:if>
														<xsl:if test="$usersid!=id">
															<xsl:value-of select="name"/>
															<xsl:value-of select="' '"/>
															<xsl:value-of select="surname"/>
														</xsl:if>
													</a>
												</td>
												<td class="h1a t1" align="center" colspan="3">
													<xsl:value-of select="$lng/product"/>
												</td>
												<td class="h1a t1" align="center" colspan="4">
													<xsl:value-of select="$lng/replacement"/>
												</td>
												<td class="h1a t1" align="center" colspan="2"/>
											</tr>
											<tr>
												<td class="h1b t1" align="center">
													<xsl:value-of select="$lng/tenderitem"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/category"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/brand"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/model"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/des"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/brand"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/model"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/des"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/position"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/status"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="$lng/price"/>
												</td>
											</tr>
											<xsl:variable name="agentid" select="id"/>
											<xsl:for-each select="../tender_quote">
												<xsl:if test="$agentid=user_id">
													<xsl:if test="$tenderid=tenderid">
														<tr>
															<td class="h2b t2" align="center">
																<a target="main">
																	<xsl:attribute name="href"><xsl:value-of select="concat('./main.php?module=procure&amp;function=item_profile&amp;id=',./tender_item)"/></xsl:attribute>
																	<xsl:value-of select="tender_item"/>
																</a>
															</td>
															<td class="h2c t2">
																<xsl:value-of select="categoryname"/><br/>
																<xsl:value-of select="category_subname"/>
															</td>
															<td class="h2c t2">
																<xsl:value-of select="brand"/>
															</td>
															<td class="h2c t2">
																<xsl:value-of select="model"/>
															</td>
															<td class="h2c t2">
																<textarea class="readonly t2" readonly=""><xsl:value-of select="description"/></textarea>
															</td>
															<td class="h2c t2">
																<xsl:value-of select="itembrand"/>
															</td>
															<td class="h2c t2">
																<xsl:value-of select="itemmodel"/>
															</td>
															<td class="h2c t2" align="center">
																<textarea class="readonly t2" readonly=""><xsl:value-of select="itemdescription"/></textarea>
															</td>
															<td class="h2c t">
																<xsl:call-template name="position_icon">
																	<xsl:with-param name="position" select="quote_position"/>
																</xsl:call-template>
															</td>
															<td class="h2c t2">
																<xsl:call-template name="tender_quote_icon">
																	<xsl:with-param name="classification" select="classification"/>
																	<xsl:with-param name="status" select="status"/>
																	<xsl:with-param name="tenderclassification" select="$tenderclassification"/>
																	<xsl:with-param name="itemclassification" select="itemclassification"/>
																</xsl:call-template>
															</td>
															<td class="h2c t2" align="center">
																<xsl:value-of select="../localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="../localpostcurrency"/>
															</td>
														</tr>
													</xsl:if>
												</xsl:if>
											</xsl:for-each>
											<tr>
												<td class="h1b t1" align="right" colspan="10">
													<xsl:value-of select="$lng/total"/>
												</td>
												<td class="h1c t1" align="center">
													<xsl:value-of select="../localprecurrency"/><xsl:value-of select="price"/><xsl:value-of select="../localpostcurrency"/>
												</td>
											</tr>
											<tr><td></td></tr>
										</xsl:if>
									</xsl:for-each>
								</table>
							</td>
						</tr>
					<xsl:if test="../tenderbudget">
						<tr>
							<td></td>
							<td class="hc t1" align="right" colspan="9">
								<xsl:value-of select="$lng/total"/>
								<xsl:value-of select="' '"/>
								<xsl:value-of select="$lng/budget"/>
							</td>
							<td class="hc t1" align="center">
								<xsl:value-of select="../localprecurrency"/><xsl:value-of select="budget"/><xsl:value-of select="../localpostcurrency"/>
							</td>
						</tr>
					</xsl:if>
						<tr><td><br/></td></tr>
					</xsl:for-each>
				</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
