<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
		<xsl:if test="reportajaxstatus='1'">
			<script type="text/javascript" src="./modules/report/templates/liverequest.js"></script>
			<style>
				#rfqresults {position: absolute; display: none; background-color: #aaa; min-width: 90px; margin: 1px 0px 20px 0px; padding: 0px;}
				#rfqresults ul {position: relative; margin-bottom: -5px; margin-top: 0px; padding-top: 0px; margin: 0px; padding: 0px;}
				#rfqresults ul li {position: relative; list-style: none; text-indent: -20px; padding: 0px 15px 3px 20px;}
				#rfqresults li {position: relative; padding-bottom: 2px; padding-top: 2px; line-height:15px; margin-bottom: 0px;}
				ul#lsShadow1 {position: relative; right: 1px; margin: 0px; padding: 0px; background-color: #666; color: inherit;}
				.lsRes {position: relative; bottom: 1px; right: 1px; background-color: white; border:  1px solid #AAA;}
				#rfqrefresults {position: absolute; display: none; background-color: #aaa; min-width: 90px; margin: 1px 0px 20px 0px; padding: 0px;}
				#rfqrefresults ul {position: relative; margin-bottom: -5px; margin-top: 0px; padding-top: 0px; margin: 0px; padding: 0px;}
				#rfqrefresults ul li {position: relative; list-style: none; text-indent: -20px; padding: 0px 15px 3px 20px;}
				#rfqrefresults li {position: relative; padding-bottom: 2px; padding-top: 2px; line-height:15px; margin-bottom: 0px;}
				ul#lsShadow2 {position: relative; right: 1px; margin: 0px; padding: 0px; background-color: #666; color: inherit;}
				.lsRes {position: relative; bottom: 1px; right: 1px; background-color: white; border:  1px solid #AAA;}				
			</style>
		</xsl:if>
	</head>
<body>
<xsl:if test="reportajaxstatus='1'">
	<xsl:attribute name="onload">lsInit();</xsl:attribute>
	<xsl:attribute name="onclick">lsHide1(); lsHide2();</xsl:attribute>
</xsl:if>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderreport"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="company"/>
					<input type="hidden" name="organisationid" id="organisationid" value="{organisationid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td class="h t1" colspan="2">
								<xsl:value-of select="$lng/reportinfo"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/reporttype"/>
							</td>
							<td class="t2">
								<select name="reporttype" class="t2" onchange="updateFormat()">
									<xsl:if test="reporttype">
										<xsl:for-each select="reporttype">
											<option value="{value}">
												<xsl:if test="value='tender_group_by_quote'">
													<xsl:attribute name="selected"/>	
												</xsl:if>
												<xsl:value-of select="name"/>
											</option>
										</xsl:for-each>
									</xsl:if>
									<option value="audit"><xsl:value-of select="$lng/audittrail"/></option>
									<option value="close"><xsl:value-of select="$lng/closedtenders"/></option>
									<option value="awarded"><xsl:value-of select="$lng/awardedtenders"/></option>
									<option value="bordereaux"><xsl:value-of select="$lng/bordereaux"/></option>
									<option value="balance"><xsl:value-of select="$lng/balancescorecard"/></option>
									<option value="user_fees"><xsl:value-of select="$lng/fees"/></option>
								</select>
								<select name="reportformat" class="t2"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/tendertype"/>
							</td>
							<td class="t2">
								<select name="tenderstatus" class="t2">
									<option value=""><xsl:value-of select="$lng/all"/></option>
									<option value="0"><xsl:value-of select="$lng/errors"/></option>
									<option value="2"><xsl:value-of select="$lng/open"/></option>
									<option value="4"><xsl:value-of select="$lng/uncompleted"/></option>
									<option value="6"><xsl:value-of select="$lng/completed"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/startdate"/>
							</td>
							<td class="t2">
								<input type="text" name="startdate" id="startdate" value="{daysago3}" class="t2" size="10" maxlength="10"/>
								<xsl:value-of select="' '"/>
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_startdate" style="cursor: pointer; border: 0px;" alt="Date selector" />
								<xsl:value-of select="' '"/>
								<a href="javascript:setthismonth()"><xsl:value-of select="$lng/thismonth"/></a>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/enddate"/>
							</td>
							<td class="t2">
								<input type="text" name="enddate" id="enddate" value="{today}" class="t2" size="10" maxlength="10"/>
								<xsl:value-of select="' '"/>
								<img src="./theme/{$theme}/icon/calendar.gif" id="trigger_enddate" style="cursor: pointer; border: 0px;" alt="Date selector" />
								<xsl:value-of select="' '"/>
								<a href="javascript:setlastmonth()"><xsl:value-of select="$lng/lastmonth"/></a>
							</td>							
						</tr>
						<tr>
							<td class="h1 t1" colspan="3">
								<xsl:value-of select="$lng/searchby"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="t2">
								<input type="text" name="rfqnumber" id="rfqnumber" class="t2" size="35">
									<xsl:if test="reportajaxstatus='1'">
										<xsl:attribute name="onkeypress">lsStart(<xsl:value-of select="'1'"/>)</xsl:attribute>
									</xsl:if>
								</input>
								<div id="rfqresults"><ul id="lsShadow1"><li></li></ul></div>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td class="t2">
								<input type="text" name="rfqreference" id="rfqreference" class="t2" size="35">
									<xsl:if test="reportajaxstatus='1'">
										<xsl:attribute name="onkeypress">lsStart(<xsl:value-of select="'2'"/>)</xsl:attribute>
									</xsl:if>
								</input>
								<div id="rfqrefresults"><ul id="lsShadow2"><li></li></ul></div>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td class="t2">
								<select name="stateid" id="state" class="t2" onchange="updateArea()">
									<option value="0"><xsl:value-of select="$lng/selectstate"/></option>
									<xsl:variable name="statematchid" select="stateid"/>
									<xsl:for-each select="state">
										<option>
											<xsl:attribute name="value"><xsl:value-of select="./stateid"/></xsl:attribute>
											<xsl:if test="./stateid=$statematchid">
												<xsl:attribute name="selected">selected</xsl:attribute> 
											</xsl:if>
											<xsl:value-of select="statename"/>
										</option>		
									</xsl:for-each> 
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td class="t2">
								<select name="areaid" id="area" class="t2">
									<option value="0"><xsl:value-of select="$lng/selectarea"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/branch"/>
							</td>
							<td class="t2">
								<select name="branchid" id="branch" class="t2" onchange="updateUsers()">
									<option value="0"><xsl:value-of select="$lng/selectbranch"/></option>
									<xsl:variable name="branchmatchid" select="branchid"/>
									<xsl:for-each select="branch">
											<option>
												<xsl:attribute name="value"><xsl:value-of select="./branchid"/></xsl:attribute>
												<xsl:if test="./branchid=$branchmatchid">
													<xsl:attribute name="selected">selected</xsl:attribute> 
												</xsl:if>
												<xsl:value-of select="branchname"/>
											</option>		
									</xsl:for-each> 
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/users"/>
							</td>
							<td class="t2">
								<select name="usersid" id="users" class="t2">
									<option value="0"><xsl:value-of select="$lng/selectuser"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="h1 t1" colspan="3">
								<xsl:value-of select="$lng/groupby"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/group"/>
							</td>
							<td class="t2">
								<select name="group" class="t2">
									<option value=""><xsl:value-of select="$lng/none"/></option>
									<option value="branch"><xsl:value-of select="$lng/branch"/></option>
									<option value="users"><xsl:value-of select="$lng/user"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="h1 t1" colspan="3">
								<xsl:value-of select="$lng/sortby"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/first"/>
							</td>
							<td class="t2">
								<select name="firstsort" class="t2">
									<option value="created"><xsl:value-of select="$lng/created"/></option>
									<option value="closed"><xsl:value-of select="$lng/closed"/></option>
									<option value="category"><xsl:value-of select="$lng/category"/></option>
									<option value="area"><xsl:value-of select="$lng/area"/></option>
									<option value="brand"><xsl:value-of select="$lng/brand"/></option>
									<option value="model"><xsl:value-of select="$lng/model"/></option>
									<option value="sent"><xsl:value-of select="$lng/sent"/></option>
									<option value="received"><xsl:value-of select="$lng/response"/></option>
									<option value="status"><xsl:value-of select="$lng/status"/></option>
									<option value="rfqnumber"><xsl:value-of select="$lng/rfqnumber"/></option>
									<option value="tenderstatus"><xsl:value-of select="$lng/tendertype"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/second"/>
							</td>
							<td class="t2">
								<select name="secondsort" class="t2">
									<option value="closed"><xsl:value-of select="$lng/closed"/></option>
									<option value="created"><xsl:value-of select="$lng/created"/></option>
									<option value="category"><xsl:value-of select="$lng/category"/></option>
									<option value="area"><xsl:value-of select="$lng/area"/></option>
									<option value="brand"><xsl:value-of select="$lng/brand"/></option>
									<option value="model"><xsl:value-of select="$lng/model"/></option>
									<option value="sent"><xsl:value-of select="$lng/sent"/></option>
									<option value="received"><xsl:value-of select="$lng/response"/></option>
									<option value="status"><xsl:value-of select="$lng/status"/></option>
									<option value="rfqnumber"><xsl:value-of select="$lng/rfqnumber"/></option>
									<option value="tenderstatus"><xsl:value-of select="$lng/tendertype"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t2" align="right">
								<input type="submit" name="display" class="t2">
									<xsl:attribute name="value"><xsl:value-of select="$lng/display"/></xsl:attribute>
								</input>
							</td>
							<td class="t2" align="right">
								<input type="submit" name="cancel" class="t2">
									<xsl:attribute name="value"><xsl:value-of select="$lng/cancel"/></xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>

	<script type="text/javascript">
		Calendar.setup({inputField:"startdate",ifFormat:"%Y-%m-%d",button:"trigger_startdate",singleClick:true});
		Calendar.setup({inputField:"enddate",ifFormat:"%Y-%m-%d",button:"trigger_enddate",singleClick:true});
		function setthismonth() {
			var currentdate = new Date();
			var month = currentdate.getMonth() + 1; 
			var year = currentdate.getFullYear();
			var day = currentdate.getDate();
			if (month &lt; 10) {
				month = "0" + month;
			}				
			document.report.startdate.value = year+"-"+month+"-01";
			document.report.enddate.value = year+"-"+month+"-"+day;
		}
		function setlastmonth() {
			var currentdate = new Date();
			var month = currentdate.getMonth(); 
			var year = currentdate.getFullYear();
			if (month &lt; 10) {
				month = "0" + month;
			}				
			document.report.startdate.value = year+"-"+month+"-01";
			var ndate1 = new Date(year, month , 1);
			var ndate2 =  new Date(ndate1.getTime() - 86400000);
			var month = ndate2.getMonth() + 1; 
			if (month &lt; 10) {
				month = "0" + month;
			}											
			document.report.enddate.value = ndate2.getFullYear()+"-"+month+"-"+ndate2.getDate();			
		}
		function updateUsers() {	
			var branchvalue = document.report.branch.value;
			var usersselect = document.report.users;
			var usersoptions = usersselect.options;
			var counter = 0;
			usersselect.length = 0;
			usersoptions[counter++] = new Option("<xsl:value-of select="$lng/selectuser"/>","");
			<xsl:for-each select="users">
				if (branchvalue == "<xsl:value-of select="branchid"/>" || branchvalue == "0") {
					usersoptions[counter++] = new Option("<xsl:value-of select="name"/> <xsl:value-of select="' '"/><xsl:value-of select="surname"/>","<xsl:value-of select="usersid"/>");
				}
			</xsl:for-each>
		}
		function updateArea() {	
			var stateIndex = document.report.state.selectedIndex;
			var stateValue = document.report.state.value;
			<xsl:if test="area/areaid">
				var areaSelect = document.report.area;
				var areaOptions = areaSelect.options;
				var counter = 0;
				areaSelect.length = 0;
				areaOptions[counter++] = new Option("<xsl:value-of select="$lng/selectarea"/>","");
				<xsl:for-each select="area">
					if (stateValue == "<xsl:value-of select="./stateid"/>" || stateValue == "0") {
						areaOptions[counter++] = new Option("<xsl:value-of select="areaname"/>","<xsl:value-of select="areaid"/>");
					}
				</xsl:for-each>
			</xsl:if>
		}		
		function updateFormat() {	
			var reportType = document.report.reporttype.value;
			var reportFormatSelect = document.report.reportformat;
			var reportFormatOptions = reportFormatSelect.options;
			var counter = 0;
			reportFormatSelect.length = 0;
			reportFormatOptions[counter++] = new Option("<xsl:value-of select="$lng/onlinereport"/>","online");
			if (reportType == "close") {
				reportFormatOptions[counter++] = new Option("<xsl:value-of select="$lng/csvreport"/>","csv");
			}
			<xsl:if test="xls_supported">
			if (reportType == "close") {
				reportFormatOptions[counter++] = new Option("<xsl:value-of select="$lng/xlsreport"/>","xls");
			}
			</xsl:if>
		}
		updateArea();
		updateUsers();
		updateFormat();
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
