<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<xsl:variable name="localprecurrency" select="localprecurrency"/>
<xsl:variable name="localpostcurrency" select="localpostcurrency"/>
<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/servicefee"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/oftendersbetween"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="startdate"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/and"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="enddate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="show_tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="t1" align="right" colspan="6">
								<xsl:value-of select="$lng/selectotherreport"/><xsl:value-of select="': '"/>
								<select name="reporttype" class="t1" onchange="gotoreport()">
									<xsl:if test="reporttype">
										<xsl:for-each select="reporttype">
											<option value="{value}">
												<xsl:value-of select="name"/>
											</option>
										</xsl:for-each>
									</xsl:if>
									<option value="audit"><xsl:value-of select="$lng/audittrail"/></option>
									<option value="close"><xsl:value-of select="$lng/closedtenders"/></option>
									<option value="awarded"><xsl:value-of select="$lng/awardedtenders"/></option>
									<option value="bordereaux"><xsl:value-of select="$lng/bordereaux"/></option>
									<option value="balance"><xsl:value-of select="$lng/balancescorecard"/></option>
									<option value="user_fees"><xsl:attribute name="selected"/><xsl:value-of select="$lng/fees"/></option>
								</select>
								<xsl:value-of select="' '"/>
								<input name="print" type="button" value="{$lng/print}" onclick="window.print()" class="t2"/>
							</td>
						</tr>
						<tr>
							 <td><br/></td>
							<td class="h t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/subscriber"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/items"/>
							</td>
							<td class="ha t1">
								<xsl:value-of select="$lng/transaction_fee"/>
							</td>
						</tr>
						<xsl:if test="tender/id">
							<xsl:for-each select="tender">
								<tr>
									<td><br/></td>
									<td class="h2b t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=procure&amp;function=profile&amp;id=',./id)"/>
											</xsl:attribute>
											<xsl:value-of select="rfq_number"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="rfq_reference"/>
									</td>
									<td class="h2c t2" align="center">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
											</xsl:attribute>
											<xsl:value-of select="name"/>
											<xsl:value-of select="' '"/>
											<xsl:value-of select="surname"/>
										</a>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="item_count"/>
									</td>
									<td class="h2c t2" align="center">
										<xsl:value-of select="$localprecurrency"/><xsl:value-of select="transaction_fee"/><xsl:value-of select="$localpostcurrency"/>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td class="h2b t1" align="right" colspan="3">
									<xsl:value-of select="$lng/total"/>
								</td>
								<td class="h2c t1" align="center">
									<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/price"/><xsl:value-of select="$localpostcurrency"/>
								</td>
								<td class="h2c t1" align="center">
									<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/transaction_fee"/><xsl:value-of select="$localpostcurrency"/>
								</td>
							</tr>
							<xsl:if test="all/user_fee != '0.00'">
								<tr>
									<td><br/></td>
									<td class="h2b t1"  align="right" colspan="4">
										<xsl:value-of select="$lng/user_fee"/>
									</td>
									<td class="h2c t1" align="center">
										<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/user_fee"/><xsl:value-of select="$localpostcurrency"/>
									</td>
								</tr>
							</xsl:if>
							<xsl:if test="all/message_fee != '0.00'">
								<tr>
									<td><br/></td>
									<td class="h2b t1"  align="right" colspan="4">
										<xsl:value-of select="$lng/sms_fee"/>
									</td>
									<td class="h2c t1" align="center">
										<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/message_fee"/><xsl:value-of select="$localpostcurrency"/>
									</td>
								</tr>
							</xsl:if>
							<tr>
								<td><br/></td>
								<td class="h1b t1" align="right" colspan="4">
									<xsl:value-of select="$lng/servicefees"/>
								</td>
								<td class="h1c t1" align="center">
									<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/total"/><xsl:value-of select="$localpostcurrency"/>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript">
		function gotoreport() {
			var otherreport = document.report.reporttype.value;
			var startdate = "<xsl:value-of select="reportinfo/startdate"/>";
			var enddate = "<xsl:value-of select="reportinfo/enddate"/>";
			var URL = "./main.php?module=report&amp;function=company&amp;reporttype=" + otherreport+"&amp;display=1"+"&amp;reportformat=online"+"&amp;startdate=" + startdate + "&amp;enddate=" + enddate;
			<xsl:if test="reportinfo/stateid != 0">
				URL += "&amp;stateid=" + <xsl:value-of select="reportinfo/stateid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/areaid != 0">
				URL += "&amp;areaid=" + <xsl:value-of select="reportinfo/areaid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/branchid != 0">
				URL += "&amp;branchid=" + <xsl:value-of select="reportinfo/branchid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/usersid != 0">
				URL += "&amp;usersid=" + <xsl:value-of select="reportinfo/usersid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/firstsort">
				URL += "&amp;firstsort=" + "<xsl:value-of select="reportinfo/firstsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/secondsort">
				URL += "&amp;secondsort=" + "<xsl:value-of select="reportinfo/secondsort"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/group">
				URL += "&amp;group=" + "<xsl:value-of select="reportinfo/group"/>";
			</xsl:if>
			<xsl:if test="reportinfo/organisationid">
				URL += "&amp;organisationid=" + <xsl:value-of select="reportinfo/organisationid"/>;
			</xsl:if>
			<xsl:if test="reportinfo/rfqnumber">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqnumber"/>";	
			</xsl:if>
			<xsl:if test="reportinfo/rfqreference">
				URL += "&amp;rfqreference=" + "<xsl:value-of select="reportinfo/rfqreference"/>";
			</xsl:if>
			parent.main.location.href = URL;
		}		
	</script>		
</body>
</html>

</xsl:template>

</xsl:stylesheet>
