<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/opentendersreport"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/oftendersbetween"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="startdate"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/and"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="enddate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="show_tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
				<xsl:if test="tender/id">
					<xsl:for-each select="tender">
						<tr>
							<td><br/></td>
							<td class="h t1" align="left">
								<xsl:value-of select="$lng/rfqnumber"/><br/>
								<xsl:value-of select="$lng/rfqreference"/>
							</td>
							<td class="ha t2" align="left">
								<xsl:value-of select="rfq_number"/><br/>
								<xsl:value-of select="rfq_reference"/>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/created"/><br/>
								<xsl:value-of select="$lng/closed"/>
							</td>
							<td class="ha t2" align="left">
								<xsl:value-of select="created_on"/><br/>
								<xsl:value-of select="close_on"/>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/area"/><br/>
								<xsl:value-of select="$lng/state"/>
							</td>
							<td class="ha t2" align="left">
								<xsl:value-of select="areaname"/><br/>
								<xsl:value-of select="statename"/>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/subscriber"/><br/>
								<xsl:value-of select="$lng/organisation"/>
							</td>
							<td class="ha t2" align="left">
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',./usersid)"/>
									</xsl:attribute>
									<xsl:value-of select="name"/>
									<xsl:value-of select="' '"/>
									<xsl:value-of select="surname"/>
								</a><br/>
								<a target="main">
									<xsl:attribute name="href">
										<xsl:value-of select="concat('./main.php?module=organisation&amp;function=profile&amp;id=',./organisationid)"/>
									</xsl:attribute>
									<xsl:value-of select="organisationname"/>
								</a>
							</td>
							<td class="ha t1" align="left">
								<xsl:value-of select="$lng/email"/><br/>
								<xsl:value-of select="$lng/phonework"/>
							</td>
							<td class="ha t2" align="left">
								<a>
									<xsl:attribute name="href"><xsl:value-of select="concat('mailto:',./email)"/></xsl:attribute>
									<xsl:value-of select="email"/>
								</a><br/>
								<a>
									<xsl:attribute name="href"><xsl:value-of select="'callto://+'"/><xsl:value-of select="phone_prefix"/><xsl:number value="phone_work" format="1"/></xsl:attribute>
									<xsl:value-of select="phone_work"/>
								</a>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td colspan="10" class="h2b">
								<table border="0" align="center" cellpadding="2" cellspacing="0" width="100%" bgcolor="FFFFFF">
									<tr>
										<td class="h1 t1" align="left">
											<xsl:value-of select="$lng/tenderitem"/>
										</td>
										<td class="h1a t1" align="left">
											<xsl:value-of select="$lng/category"/>
										</td>
										<td class="h1a t1" align="left">
											<xsl:value-of select="$lng/brand"/>
										</td>
										<td class="h1a t1" align="left">
											<xsl:value-of select="$lng/model"/>
										</td>
										<td class="h1a t1" align="left">
											<xsl:value-of select="$lng/des"/>
										</td>
										<td class="h1a t1" align="left">
											<xsl:value-of select="$lng/sent"/>
										</td>
										<xsl:if test="../tenderbudget">
											<td class="h1a t1" align="left">
												<xsl:value-of select="$lng/budget"/>
											</td>
										</xsl:if>
									</tr>
									<xsl:variable name="tenderid" select="id"/>
									<xsl:for-each select="../tender_item">
										<xsl:if test="$tenderid=tenderid">
											<tr>
												<td class="h2b t2" align="left">
													<xsl:value-of select="id"/>
												</td>
												<td class="h2c t2" align="left">
													<xsl:value-of select="categoryname"/><br/>
													<xsl:value-of select="category_subname"/>
												</td>
												<td class="h2c t2" align="left">
													<xsl:value-of select="brand"/>
												</td>
												<td class="h2c t2" align="left">
													<xsl:value-of select="model"/>
												</td>
												<td class="h2c t2" align="left">
													<textarea class="readonly t2" readonly=""><xsl:value-of select="description"/></textarea>
												</td>
												<td class="h2c t2" align="left">
													<xsl:value-of select="sent"/>
												</td>
												<xsl:if test="../tenderbudget">
													<td class="h2c t2" align="left">
														<xsl:value-of select="../localprecurrency"/><xsl:value-of select="budget"/><xsl:value-of select="../localpostcurrency"/>
													</td>
												</xsl:if>
											</tr>
										</xsl:if>
									</xsl:for-each>
									<xsl:if test="../tenderbudget">
										<tr>
											<td class="h2b t1" align="right" colspan="6">
												<xsl:value-of select="$lng/total"/>
											</td>
											<xsl:if test="../tenderbudget">
												<td class="h2c t1" align="left">
													<xsl:value-of select="../localprecurrency"/><xsl:value-of select="budget"/><xsl:value-of select="../localpostcurrency"/>
												</td>
											</xsl:if>
										</tr>
									</xsl:if>
								</table>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
