<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<ul class="lsRes">
	<xsl:for-each select="tender">
		<xsl:choose>
			<xsl:when test="../rfqnumber">
				<li class="lsRow">
					<a href="javascript:lsFill('{rfq_number}', '{rfq_reference}', 1)"><xsl:value-of select="rfq_number"/></a>
				</li>
			</xsl:when>
			<xsl:otherwise>
				<li class="lsRow">
					<a href="javascript:lsFill('{rfq_number}', '{rfq_reference}', 0)"><xsl:value-of select="rfq_reference"/></a>
				</li>				
			</xsl:otherwise>
		</xsl:choose>		
	</xsl:for-each>
</ul>
				
</xsl:template>
</xsl:stylesheet>