<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/reportsettings"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="settings"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/changedsuccess"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/reportajaxstatus"/>
							</td>
							<td align="left" class="t2">
								<input name="reportajaxstatus" value="TRUE" type="radio">
									<xsl:if test="settings/reportajaxstatus='TRUE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/yes"/>
								<input name="reportajaxstatus" value="FALSE" type="radio">
									<xsl:if test="settings/reportajaxstatus='FALSE'">
										<xsl:attribute name="checked"/>
									</xsl:if>
								</input>
								<xsl:value-of select="$lng/no"/>
							</td>
						</tr>
						<xsl:call-template name="rating">
							<xsl:with-param name="name" select="$lng/arating"/>
							<xsl:with-param name="start" select="'reportbalanceAstart'"/>
							<xsl:with-param name="end" select="'reportbalanceAend'"/>
							<xsl:with-param name="factor" select="'reportbalanceAfactor'"/>
							<xsl:with-param name="start_value" select="settings/reportbalanceAstart"/>
							<xsl:with-param name="end_value" select="settings/reportbalanceAend"/>
							<xsl:with-param name="factor_value" select="settings/reportbalanceAfactor"/>
						</xsl:call-template>
						<xsl:call-template name="rating">
							<xsl:with-param name="name" select="$lng/brating"/>
							<xsl:with-param name="start" select="'reportbalanceBstart'"/>
							<xsl:with-param name="end" select="'reportbalanceBend'"/>
							<xsl:with-param name="factor" select="'reportbalanceBfactor'"/>
							<xsl:with-param name="start_value" select="settings/reportbalanceBstart"/>
							<xsl:with-param name="end_value" select="settings/reportbalanceBend"/>
							<xsl:with-param name="factor_value" select="settings/reportbalanceBfactor"/>
						</xsl:call-template>
						<xsl:call-template name="rating">
							<xsl:with-param name="name" select="$lng/crating"/>
							<xsl:with-param name="start" select="'reportbalanceCstart'"/>
							<xsl:with-param name="end" select="'reportbalanceCend'"/>
							<xsl:with-param name="factor" select="'reportbalanceCfactor'"/>
							<xsl:with-param name="start_value" select="settings/reportbalanceCstart"/>
							<xsl:with-param name="end_value" select="settings/reportbalanceCend"/>
							<xsl:with-param name="factor_value" select="settings/reportbalanceCfactor"/>
						</xsl:call-template>
						<xsl:call-template name="rating">
							<xsl:with-param name="name" select="$lng/drating"/>
							<xsl:with-param name="start" select="'reportbalanceDstart'"/>
							<xsl:with-param name="end" select="'reportbalanceDend'"/>
							<xsl:with-param name="factor" select="'reportbalanceDfactor'"/>
							<xsl:with-param name="start_value" select="settings/reportbalanceDstart"/>
							<xsl:with-param name="end_value" select="settings/reportbalanceDend"/>
							<xsl:with-param name="factor_value" select="settings/reportbalanceDfactor"/>
						</xsl:call-template>
						<xsl:call-template name="rating">
							<xsl:with-param name="name" select="$lng/erating"/>
							<xsl:with-param name="start" select="'reportbalanceEstart'"/>
							<xsl:with-param name="end" select="'reportbalanceEend'"/>
							<xsl:with-param name="factor" select="'reportbalanceEfactor'"/>
							<xsl:with-param name="start_value" select="settings/reportbalanceEstart"/>
							<xsl:with-param name="end_value" select="settings/reportbalanceEend"/>
							<xsl:with-param name="factor_value" select="settings/reportbalanceEfactor"/>
						</xsl:call-template>
						<tr>
							<td align="right" width="270" colspan="2">
								<input type="submit" name="action" class="t2">
									<xsl:attribute name="value">
										<xsl:value-of select="$lng/submit"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/instruct">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>
	
<xsl:template name="rating">
	<xsl:param name="name" select="''"/>
	<xsl:param name="start" select="''"/>
	<xsl:param name="end" select="''"/>
	<xsl:param name="factor" select="''"/>
	<xsl:param name="start_value" select="''"/>
	<xsl:param name="end_value" select="''"/>
	<xsl:param name="factor_value" select="''"/>
	<tr>
		<td align="left" colspan="2" class="h1 t1">
			<xsl:value-of select="$name"/> 
		</td>
	</tr>
	<tr>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/reportbalancestart"/>
		</td>
		<td align="left" class="t2">
			<input type="text" name="{$start}" size="4" maxlenght="40" class="t2" value="{$start_value}"/>
			<xsl:value-of select="'%'"/>
		</td>
	</tr>
	<tr>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/reportbalanceend"/>
		</td>
		<td align="left" class="t2">
			<input type="text" name="{$end}" size="4" maxlenght="40" class="t2" value="{$end_value}"/>
			<xsl:value-of select="'%'"/>
		</td>
	</tr>
	<tr>
		<td align="left" class="t1">
			<xsl:value-of select="$lng/reportbalancefactor"/>
		</td>
		<td align="left" class="t2">
			<input type="text" name="{$factor}" size="4" maxlenght="40" class="t2" value="{$factor_value}"/>
			<xsl:value-of select="'%'"/>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
