<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
		<link rel="stylesheet" type="text/css" media="all" href="./theme/{$theme}/style_calendar.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/tenderreport"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="supplier"/>
					<input type="hidden" name="supplierid" value="{supplierid}"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td class="h t1" colspan="3">
								<xsl:value-of select="$lng/reportinfo"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/reporttype"/>
							</td>
							<td class="t2">
								<select name="reporttype" class="t2">
									<!--<option value="all"><xsl:value-of select="$lng/alltenders"/></option>-->
									<option value="open"><xsl:value-of select="$lng/opentenders"/></option>
									<option value="closed"><xsl:value-of select="$lng/closedtenders"/></option>
									<option value="awarded"><xsl:value-of select="$lng/awardedtenders"/></option>
									<option value="agent_fees"><xsl:value-of select="$lng/fees"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/startdate"/>
							</td>
							<td class="t2">
								<input type="text" name="startdate" id="startdate" value="{daysago3}" class="t2" size="10" maxlength="10"/>
								<xsl:value-of select="' '"/><img src="./theme/{$theme}/icon/calendar.gif" id="trigger_startdate" style="cursor: pointer; border: 0px;" alt="Date selector" />
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/enddate"/>
							</td>
							<td class="t2">
								<input type="text" name="enddate" id="enddate" value="{today}" class="t2" size="10" maxlength="10"/>
								<xsl:value-of select="' '"/><img src="./theme/{$theme}/icon/calendar.gif" id="trigger_enddate" style="cursor: pointer; border: 0px;" alt="Date selector" />
							</td>
						</tr>
						<tr>
							<td class="h1 t1" colspan="3">
								<xsl:value-of select="$lng/searchby"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/rfqnumber"/>
							</td>
							<td class="t2">
								<input type="text" name="rfqnumber" class="t2" size="14"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/state"/>
							</td>
							<td class="t2">
								<select name="stateid" id="state" class="t2" onchange="updateArea()">
									<option value="0"><xsl:value-of select="$lng/selectstate"/></option>
									<xsl:variable name="statematchid" select="stateid"/>
									<xsl:for-each select="state">
											<option>
												<xsl:attribute name="value"><xsl:value-of select="./stateid"/></xsl:attribute>
												<xsl:if test="./stateid=$statematchid">
													<xsl:attribute name="selected">selected</xsl:attribute> 
												</xsl:if>
												<xsl:value-of select="statename"/>
											</option>		
									</xsl:for-each> 
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/area"/>
							</td>
							<td class="t2">
								<select name="areaid" id="area" class="t2">
									<option value="0"><xsl:value-of select="$lng/selectarea"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="h1 t1" colspan="3">
								<xsl:value-of select="$lng/sortby"/>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/first"/>
							</td>
							<td class="t2">
								<select name="firstsort" class="t2">
									<option value="created"><xsl:value-of select="$lng/created"/></option>
									<option value="closed"><xsl:value-of select="$lng/closed"/></option>
									<option value="category"><xsl:value-of select="$lng/category"/></option>
									<option value="area"><xsl:value-of select="$lng/area"/></option>
									<option value="brand"><xsl:value-of select="$lng/brand"/></option>
									<option value="model"><xsl:value-of select="$lng/model"/></option>
									<option value="sent"><xsl:value-of select="$lng/sent"/></option>
									<option value="received"><xsl:value-of select="$lng/response"/></option>
									<option value="users"><xsl:value-of select="$lng/user"/></option>
									<option value="branch"><xsl:value-of select="$lng/branch"/></option>
									<option value="rfqnumber"><xsl:value-of select="$lng/rfqnumber"/></option>
									<option value="tenderstatus"><xsl:value-of select="$lng/tendertype"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t1">
								<xsl:value-of select="$lng/second"/>
							</td>
							<td class="t2">
								<select name="secondsort" class="t2">
									<option value="closed"><xsl:value-of select="$lng/closed"/></option>
									<option value="created"><xsl:value-of select="$lng/created"/></option>
									<option value="category"><xsl:value-of select="$lng/category"/></option>
									<option value="area"><xsl:value-of select="$lng/area"/></option>
									<option value="brand"><xsl:value-of select="$lng/brand"/></option>
									<option value="model"><xsl:value-of select="$lng/model"/></option>
									<option value="sent"><xsl:value-of select="$lng/sent"/></option>
									<option value="received"><xsl:value-of select="$lng/response"/></option>
									<option value="rfqnumber"><xsl:value-of select="$lng/rfqnumber"/></option>
									<option value="tenderstatus"><xsl:value-of select="$lng/tendertype"/></option>
								</select>
							</td>
						</tr>
						<tr>
							<td class="t2" align="right">
								<input type="submit" name="display" class="t2">
									<xsl:attribute name="value"><xsl:value-of select="$lng/display"/></xsl:attribute>
								</input>
							</td>
							<td class="t2" align="right">
								<input type="submit" name="cancel" class="t2">
									<xsl:attribute name="value"><xsl:value-of select="$lng/cancel"/></xsl:attribute>
								</input>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/language/{$language}/calendar.js"></script>
	<script type="text/javascript" src="./modules/external/javascript/calendar/calendar-setup.js"></script>

	<script type="text/javascript">
		Calendar.setup({inputField:"startdate",ifFormat:"%Y-%m-%d",button:"trigger_startdate",singleClick:true});
		Calendar.setup({inputField:"enddate",ifFormat:"%Y-%m-%d",button:"trigger_enddate",singleClick:true});

		function updateArea() {	
			var stateIndex = document.report.state.selectedIndex;
			var stateValue = document.report.state.value;
			<xsl:if test="area/areaid">
				var areaSelect = document.report.area;
				var areaOptions = areaSelect.options;
				var counter = 0;
				areaSelect.length = 0;
				areaOptions[counter++] = new Option("<xsl:value-of select="$lng/selectarea"/>","");
				<xsl:for-each select="area">
					if (stateValue == "<xsl:value-of select="./stateid"/>" || stateValue == "0") {
						areaOptions[counter++] = new Option("<xsl:value-of select="areaname"/>","<xsl:value-of select="areaid"/>");
					}
				</xsl:for-each>
			</xsl:if>
		}
		updateArea();
	</script>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
