<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/',$language,'/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Template -->
<xsl:template match="/response">
<xsl:variable name="localprecurrency" select="localprecurrency"/>
<xsl:variable name="localpostcurrency" select="localpostcurrency"/>
<html>
	<head>
		<title><xsl:value-of select="$lng/title"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/servicefee"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/oftendersbetween"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="startdate"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="$lng/and"/>
			<xsl:value-of select="' '"/>
	`		<xsl:value-of select="enddate"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'report'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="report"/>
					<input type="hidden" name="function" value="show_tender"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h2 t1"  align="right" colspan="4">
								<xsl:value-of select="$lng/user_fee"/>
							</td>
							<td class="h2a t1" align="center">
								<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/user_fee"/><xsl:value-of select="$localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h2b t1"  align="right" colspan="4">
								<xsl:value-of select="$lng/sms_fee"/>
							</td>
							<td class="h2c t1" align="center">
								<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/message_fee"/><xsl:value-of select="$localpostcurrency"/>
							</td>
						</tr>
						<tr>
							<td><br/></td>
							<td class="h1b t1" align="right" colspan="4">
								<xsl:value-of select="$lng/servicefees"/>
							</td>
							<td class="h1c t1" align="center">
								<xsl:value-of select="$localprecurrency"/><xsl:value-of select="all/total"/><xsl:value-of select="$localpostcurrency"/>
							</td>
						</tr>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
