<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Login user
* @package TenderSystem
* @subpackage session
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// if user is logged in display control panel
if ($_SESSION['ts_id']) {
	// paramaters to send to the application server
	$params = array(
		'module'	=> 'user',
		'function'	=> 'control'
	);
	$id = $_SESSION['next_call_id'];
	if($id) {
		if(!isset($_SESSION['next_done'][$id])) {
			$_SESSION['next_done'][$id] = 0;
		} else {
			$_SESSION['next_done'][$id] = $_SESSION['next_done'][$id] + 1;
		}
	}
	if($_SESSION['next_module'] && $_SESSION['next_function'] && $_SESSION['next_done'][$id] < 3) {
		$params['next_module'] = $_SESSION['next_module'];
		$params['next_function'] = $_SESSION['next_function'];
		// unset the next module
		unset($_SESSION['next_module']);
		unset($_SESSION['next_function']);
	}
	// send the message to app
	send_message($params,$cfg);
} else {
	// field request errors and type 
	$fields_request = array (
		'action'			=> array()	
	);
	get_request($fields_request,$action,$error,$cfg);
	// login submitted
	if ($action['action']) {
		// field request errors and type 
		$fields_request = array (
			'username'			=> array("",	REQUEST_USERNAME,	FORMAT_USERNAME,	"e3"),
			'password'			=> array("",	REQUEST_PASSWORD,	FORMAT_PASSWORD,	"e4"),
			'offsite'			=> array(),
			'rfqnumber'			=> array()
		);
		// get data
		get_request($fields_request,$info,$error,$cfg);
		// if system inactive only superuser can login
		if ($cfg['status']) {
			$info['username'] = "admin";
		} elseif(!$info['username']) {
			// missing username
			$error[] = "e1";
		}
		if($error) {
			// generate and display the error
			xml_generator('session','login',$error,$info,$cfg);
		} else {
			// set hash function
			 $hash_function = $cfg['password']['hash'];
			 // check if function exists
			 if(!function_exists($hash_function)) {
			 	// set to default
			 	$hash_function = "md5";
			 }
			 // check password scheme
			 if($cfg['password']['scheme'] == "2") {
			 	// hash(pre_salt + password + post_salt)
			 	$hashed_pwd = $hash_function($cfg['password']['salt']['pre'].$info['password'].$cfg['password']['salt']['post']);
			 } elseif($cfg['password']['scheme'] == "3") {
			 	$hash_1 = $hash_function($cfg['password']['salt']['pre']);
			 	$hash_2 = $hash_function($info['password']);
			 	$hash_3 = $hash_function($cfg['password']['salt']['post']);
			 	$hashed_pwd = $hash_function($hash_1.$hash_2.$hash_3);
			 } else {
			 	$hashed_pwd = $hash_function($info['password']);
			 }
			// get browser
			$browser = $_SERVER['HTTP_USER_AGENT'];
			if(!$browser) {
				$browser = "N/A";
			}
			// paramaters to send to the application server
			$params = array(
				'module'		=> 'session',
				'function'		=> 'login',
			    'username'  	=> $info['username'],
			    'password' 		=> $hashed_pwd,
				'browser'  		=> $browser,
				'rfqnumber'		=> $info['rfqnumber']
			);
			// if offsite login
			if ($info['offsite']) {
				$params['offsite'] = "true";						
			}
			// set that busy logging in
			$cfg['logging_in'] = TRUE;
			$id = $_SESSION['next_call_id'];
			if($id) {
				if(!isset($_SESSION['next_done'][$id])) {
					$_SESSION['next_done'][$id] = 0;
				} else {
					$_SESSION['next_done'][$id] = $_SESSION['next_done'][$id] + 1;
				}
			}
			if($_SESSION['next_module'] && $_SESSION['next_function'] && $_SESSION['next_done'][$id] < 3) {
				$params['next_module'] = $_SESSION['next_module'];
				$params['next_function'] = $_SESSION['next_function'];
				// unset the next module
				unset($_SESSION['next_module']);
				unset($_SESSION['next_function']);
			}
			// send the message to app
			send_message($params,$cfg);
		}
	} else {
		if ($_SESSION['ts_username']) {
			// set the username from the session
			$params['username'] = $_SESSION['ts_username'];
		} elseif ($username) {
			// set the username from the input field
			$params['username'] = $username;
		}
		// if offsite login
		if ($info['offsite']) {
			$params['offsite'] = "true";						
		}
		// determine if the site is offline
		if ($cfg['status']) {
			// determine if it is an administrator trying to login
			$adminlogin = sanitise($_POST['adminlogin']);
			// set that not offline
			if ($adminlogin) {
				$params['adminlogin'] = "true";
			} else {
				// set offline
				$params['offline'] = $cfg['statusmessage'];
			}
		}
		$params['rfqnumber'] = $_REQUEST['rfqnumber'];
	    // generate and display the xml
		xml_generator('session','login',$error,$params,$cfg);
	}
}
?>