<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<xsl:param name="display" select="/response/display"/>
<xsl:param name="more" select="/response/more"/>
<xsl:param name="type" select="/response/type"/>

<!-- Template -->
<xsl:template match="/response">
<html>
	<head>
		<title><xsl:value-of select="$lng/controlpanel"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/sessionlog"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'session'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="session"/>
					<input type="hidden" name="function" value="list_session"/>
					<table border="0" align="left" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td><br/></td>
							<td class="h t1"><xsl:value-of select="$lng/fullname"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/date"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/idle"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/userclass"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/ipaddress"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/guiip"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/apiip"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/browser"/></td>
							<td class="ha t1"><xsl:value-of select="$lng/status"/></td>
						</tr>
						<xsl:if test="login">
							<xsl:variable name="usersid" select="user/usersid"/>
							<xsl:for-each select="login">
								<tr>
									<td><br/></td>
									<td class="h2b">
										<a target="main">
											<xsl:attribute name="href">
												<xsl:value-of select="concat('./main.php?module=user&amp;function=profile&amp;id=',usersid)"/>
											</xsl:attribute>
											<xsl:choose>
												<xsl:when test="$usersid=usersid">
													<xsl:value-of select="$lng/you"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="name"/>
													<xsl:value-of select="' '"/>
													<xsl:value-of select="surname"/>
												</xsl:otherwise>
											</xsl:choose>
										</a>
									</td>
									<td class="h2c"><xsl:value-of select="created_on"/></td>
								<xsl:if test="idle!='--'">
									<td class="h2c" align="right"><xsl:value-of select="idle"/></td>
								</xsl:if>
								<xsl:if test="idle='--'">
									<td class="h2c" align="center"><xsl:value-of select="idle"/></td>
								</xsl:if>
									<td class="h2c">
										<xsl:choose>
											<xsl:when test="classification='3'">
												<xsl:choose>
													<xsl:when test="permission='2'">
														<xsl:value-of select="$lng/admininstrator"/>
													</xsl:when>
													<xsl:when test="permission='1'">
														<xsl:value-of select="$lng/moderator"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$lng/unknown"/>
														<xsl:value-of select="' ('"/>
														<xsl:value-of select="classification"/>
														<xsl:value-of select="')'"/>
														<xsl:value-of select="'('"/>
														<xsl:value-of select="permission"/>
														<xsl:value-of select="')'"/>
													</xsl:otherwise>
												</xsl:choose>											
											</xsl:when>
											<xsl:when test="classification='1'">
												<xsl:choose>
													<xsl:when test="permission='2'">
														<xsl:value-of select="$lng/superagent"/>
													</xsl:when>
													<xsl:when test="permission='1'">
														<xsl:value-of select="$lng/agent"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$lng/unknown"/>
														<xsl:value-of select="' ('"/>
														<xsl:value-of select="classification"/>
														<xsl:value-of select="')'"/>
														<xsl:value-of select="'('"/>
														<xsl:value-of select="permission"/>
														<xsl:value-of select="')'"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:when test="classification='2'">
												<xsl:choose>
													<xsl:when test="permission='4'">
														<xsl:value-of select="$lng/organisationsubscriber"/>
													</xsl:when>
													<xsl:when test="permission='3'">
														<xsl:value-of select="$lng/statesubscriber"/>
													</xsl:when>
													<xsl:when test="permission='2'">
														<xsl:value-of select="$lng/branchsubscriber"/>
													</xsl:when>
													<xsl:when test="permission='1'">
														<xsl:value-of select="$lng/subscriber"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$lng/unknown"/>
														<xsl:value-of select="' ('"/>
														<xsl:value-of select="classification"/>
														<xsl:value-of select="')'"/>
														<xsl:value-of select="'('"/>
														<xsl:value-of select="permission"/>
														<xsl:value-of select="')'"/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
												<xsl:value-of select="' ('"/>
												<xsl:value-of select="classification"/>
												<xsl:value-of select="')'"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c">
										<xsl:choose>
											<xsl:when test="ip_address='127.0.0.1'">
												<xsl:value-of select="$lng/localhost"/>
											</xsl:when>
											<xsl:otherwise>
												<a href="http://ws.arin.net/cgi-bin/whois.pl?queryinput={ip_address}">
													<xsl:value-of select="ip_address"/>
												</a>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c">
										<xsl:choose>
											<xsl:when test="ip_server='127.0.0.1'">
												<xsl:value-of select="$lng/localhost"/>
											</xsl:when>
											<xsl:otherwise>
												<a href="http://ws.arin.net/cgi-bin/whois.pl?queryinput={ip_address}">
													<xsl:value-of select="ip_server"/>
												</a>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c">
										<xsl:choose>
											<xsl:when test="ip_api='127.0.0.1'">
												<xsl:value-of select="$lng/localhost"/>
											</xsl:when>
											<xsl:otherwise>
												<a href="http://ws.arin.net/cgi-bin/whois.pl?queryinput={ip_address}">
													<xsl:value-of select="ip_api"/>
												</a>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c" align="right">
										<xsl:choose>
											<xsl:when test="browser='--'">
												<xsl:value-of select="$lng/unknown"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="browser"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td class="h2c">
										<xsl:choose>
											<xsl:when test="status='1'">
												<xsl:choose>
													<xsl:when test="expired='1'">
														<xsl:value-of select="$lng/expired"/>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="$lng/active"/>
													</xsl:otherwise>
												</xsl:choose>		
											</xsl:when>
											<xsl:when test="status='0'">
												<xsl:value-of select="$lng/logout"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$lng/unknown"/>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td><br/></td>
								<td class="h2b" colspan="7">
									<xsl:if test="$display &gt; 0">
										<xsl:variable name="previous" select="$display - 1"/>
										<a href="main.php?module=session&amp;function=list_session&amp;displaypage={$previous}">
											<img src="./theme/{$theme}/icon/left.gif" border="0" alt="Previous" hspace="1" align="absmiddle"/>
										</a>
									</xsl:if>
									<xsl:if test="$more='1'">
										<xsl:variable name="next" select="$display + 1"/>
										<a href="main.php?module=session&amp;function=list_session&amp;displaypage={$next}">
											<img src="./theme/{$theme}/icon/right.gif" border="0" alt="Next" hspace="1" align="absmiddle" />
										</a>
									</xsl:if>
								</td>
								<td class="h2c" colspan="2" align="right">
									<form enctype="multipart/form-data" action="main.php" method="post" name="report">
										<input type="hidden" name="module" value="session"/>
										<input type="hidden" name="function" value="list_session"/>
										<input type="submit" value="{$lng/refresh}" class="t2"/>
									</form>
								</td>
							</tr>
						</xsl:if>
					</table>
				</form>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>