<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,error,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>

<!-- Response -->
<xsl:template match="/response">
<html>
<head>
	<title><xsl:value-of select="$lng/login"/></title>
	<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
</head>
<body>
<xsl:choose>
	<xsl:when test="offline">
		<div id="wrapper">
			<div id="header">
				<xsl:value-of select="offline"/>
			</div>
			<div id="content">
				<xsl:call-template name="header">
					<xsl:with-param name="module" select="'session'"/>
				</xsl:call-template>
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="session"/>
					<input type="hidden" name="function" value="login"/>
					<xsl:if test="offsite">
						<input type="hidden" name="offsite" value="true"/>
					</xsl:if>
					<input type="submit" name="adminlogin" value="{$lng/admintext}" class="t2"/>
				</form>
			</div>
		</div>
	</xsl:when>
	<xsl:otherwise>
		<div id="wrapper">
			<div id="header">
				<xsl:value-of select="$lng/login"/>
			</div>
			<div id="content">
				<xsl:call-template name="header">
					<xsl:with-param name="module" select="'session'"/>
				</xsl:call-template>
				<div id="main">		
					<form enctype="multipart/form-data" action="main.php" method="post" name="report">
						<input type="hidden" name="module" value="session"/>
						<input type="hidden" name="function" value="login"/>
						<input type="hidden" name="rfqnumber" value="{rfqnumber}"/>
						<xsl:if test="offsite">
							<input type="hidden" name="offsite" value="true"/>
						</xsl:if>
						<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
							<tr>
								<td align="left" colspan="2" class="t1"><xsl:value-of select="$lng/logintext"/></td>
							</tr>
							<tr>
								<td colspan="2"><br/></td>
							</tr>
							<xsl:if test="not(adminlogin)">
								<tr>
									<td align="right" width="110" class="t1"><xsl:value-of select="$lng/username"/></td>
									<td align="left" width="270"><input type="text" name="username" size="12" value="{username}" maxlenght="32" class="t2"/></td>
								</tr>
							</xsl:if>
							<tr>
								<td align="right" width="110" class="t1"><xsl:value-of select="$lng/password"/></td>
								<td align="left" width="270"><input type="password" size="12" name="password" maxlenght="32" class="t2"/></td>
							</tr>
							<tr>
								<td colspan="2"><br/></td>
							</tr>
							<tr>
								<td width="110"></td>
								<td align="left" width="270"><input type="submit" name="action" value="{$lng/login}" class="t2"/></td>
							</tr>
						</table>
					</form>
				</div>
				<div id="right">
					<div id="right_header"><xsl:value-of select="$lng/passwordforgot"/></div>
					<div id="right_content"><a href="./main.php?module=password&amp;function=reset"><xsl:value-of select="$lng/passwordresetclick"/></a></div>
					<div id="right_header" onClick="javascript:addbookmark()"><xsl:value-of select="$lng/bookmark"/></div>
					<div id="right_content" onClick="javascript:addbookmark()"><xsl:value-of select="$lng/bookmarktext"/></div>
			<xsl:if test="$lng/supportheader">
					<div id="right_header"><xsl:value-of select="$lng/supportheader"/></div>
					<div id="right_content">
				<xsl:for-each select="$lng/supporttext">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
				<xsl:if test="$lng/supportemail">
					<xsl:value-of select="$lng/email"/>: <a href="mailto:{$lng/supportemail}"><xsl:value-of select="$lng/supportemail"/></a>
				</xsl:if>
					</div>
			</xsl:if>
				</div>
			</div>
		</div>
		<script language="javascript">
			function addbookmark(){
				var test = window.external;
				if (test) {
					var test = window.external.AddFavorite(parent.location.href,'TenderSystem Login');
				} else if (window.sidebar) {
					window.sidebar.addPanel("TenderSystem Login", parent.location.href, "")
				} else {
					alert("Please press control + D");
				}
			}
		<xsl:choose>
			<xsl:when test="username">
				document.report.password.focus();
			</xsl:when>
			<xsl:otherwise>
				document.report.username.focus();
			</xsl:otherwise>
		</xsl:choose>
		</script>
	</xsl:otherwise>
</xsl:choose>
	<xsl:call-template name="footer"/>
</body>
</html>
</xsl:template>
</xsl:stylesheet>