<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* GUI configuration settings
* @package TenderSystem
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

/**
* System configuration
* 	header:		website header
* 	theme:		default theme
* 	lang:		default language
* 	timer:		display time taken to execute code at the bottom of the pages
* 	disclaimer:	website disclaimer url - if not set it will not be displayed
* 				=, <, and > may not be in the URL
* 	privacy:	website privacy policy url - if not set it will not be displayed
* 				=, <, and > may not be in the URL
* 	error:		error meesage to display if connection to api could not be established
* 	notice:		notice displayed on login screen
* 	status:		login status. if set to false will display static maintenance page
* 	currency:	country currency
* 	xslt:		client side xslt options: (Xslt and sablotron must be enabled in php4 for browser and server)
* 	- client: 		always let the browser parse the xsl and xml files
* 					will work correct in IE > v6 and Mozilla and Netsacape > v5 (incl Firefox)
* 	- server:		parse all xsl file on the server and send html 
* 					puts cpu strain on server
* 	- browser:		determine if client browser is capable of parsing xsl and if not
* 					send xml. 
* 	input:
* 	- format:	format input
* 	- type:		check the input type
* 	- phone:	telephone numbers
* 		- min:		minimum characters
* 		- max:		maximum characters   
*/
$cfg['header'] = 'TenderSystem Open Source Procurement';
$cfg['version'] = '0.9.5';
$cfg['theme'] = 'blue';
$cfg['language'] = 'en';
$cfg['local']['postcurrency'] = '';
$cfg['local']['precurrency'] = '$';
$cfg['timer'] = TRUE;
$cfg['disclaimer'] = 'http://www.tendersystem.com/modules/articles/article.php?id=12';
$cfg['privacy'] = 'http://www.tendersystem.com/modules/articles/article.php?id=13';
$cfg['help'] = 'http://www.tendersystem.com/modules/newbb/index.php?xoops_theme_select=noheader';
$cfg['faq'] = 'http://www.tendersystem.com/modules/smartfaq/category.php?categoryid=2&amp;xoops_theme_select=noheader';
$cfg['status'] = FALSE;
$cfg['statusmessage'] = 'TenderSystem is currently down for maintenance.';
$cfg['xslt'] = 'browser';
// should input be reformated
$cfg['input']['format'] = TRUE;
// should the input type be check
$cfg['input']['type'] = TRUE;
// length of a phone number
$cfg['input']['phone']['min'] = '7';
$cfg['input']['phone']['max'] = '12';
// index.php takes you straight to install
$cfg['installed'] = FALSE;
// NOTICE : MUST CHANGE THIS ON THE API AS WELL
$cfg['password']['salt']['pre'] = 'wall';
$cfg['password']['salt']['post'] = 'pipe';
$cfg['password']['scheme'] = '2';
$cfg['password']['hash'] = 'md5';
$cfg['hide_footer'] = FALSE;
$cfg['force_xslt'] = FALSE;
// whether or not to display error codes
$cfg['error']['codes'] = TRUE;

/**
* Menu generation
* 	cache:		binary generate menu from cache or dynamically
* 	lefthtml:	string
*/
$cfg['menu']['cache'] = FALSE;
$cfg['menu']['lefthtml'] = '[a href={quote}http://sourceforge.net/projects/tendersystem/{quote} target={quote}blank{quote}][img src={quote}http://sourceforge.net/sflogo.php?group_id=134537{and}type=1{quote} border={quote}0{quote}][/a]';
// sorting for agent
$cfg['menu']['sort']['1'] = 'ksort';
// sorting for user
$cfg['menu']['sort']['2'] = 'krsort';
// sorting for classification
$cfg['menu']['sort']['3'] = 'ksort';

/**
* API configuration
* 	server:		url to the api server
* 	connection:
* 		curl:	cURL is a command line tool for transferring files with URL syntax.
* 					Note that cURL must be loaded as a PHP module to work
* 					cURL is 3 times slower than module but is used for off-site application servers
* 		module:	Directly included as as a module
* 					Note module is approximately 3 times faster than curl
* 	debug:		Display connection messages
* 	dontverify:		Verify SSL certificate authenticity
*/
$cfg['api']['server'] = 'http://192.168.1.100/tendersystem/application/api.php';
$cfg['api']['connection'] = 'module';
$cfg['api']['debug'] = FALSE;
$cfg['api']['dontverify'] = TRUE;

/**
* GUI configuration
* 	GUI / API authentication
*/
$cfg['gui']['username'] = 'test';
$cfg['gui']['password'] = 'test';

/**
 * Settings configuration
 *  
 */

$cfg['settings']['rename'] = FALSE;

/**
 * Display configuration
 *  
 * strip:	strip white spaces and line breaks
 * gzip: 	compress the output
 */

$cfg['display']['strip'] = FALSE;
$cfg['display']['gzip'] = FALSE;

/**
* Upload configuration
* 	active:		wether users are allowed to upload files
* 	path:		path were uploaded files are saved - dynamic or static
* 	filesize:	maximum file size allowable in KB
* 	filetype:	array of allowable upload file tipes
* 	delete:		wether files are to be deleted afterwords
*/
$cfg['upload']['active'] = TRUE;
$cfg['upload']['any'] = TRUE;
$cfg['upload']['path'] = './upload/';
$cfg['upload']['filesize'] = '400';
$cfg['upload']['filedelete'] = '';
// pictures
$cfg['upload']['filetype']['gif'] = FALSE;
$cfg['upload']['filetype']['jpg'] = FALSE;
$cfg['upload']['filetype']['jpeg'] = FALSE;
$cfg['upload']['filetype']['tiff'] = FALSE;
$cfg['upload']['filetype']['tif'] = FALSE;
$cfg['upload']['filetype']['png'] = FALSE;
$cfg['upload']['filetype']['bmp'] = FALSE;
// spreadsheet
$cfg['upload']['filetype']['xls'] = FALSE;
$cfg['upload']['filetype']['sxc'] = FALSE;
// documents
$cfg['upload']['filetype']['doc'] = FALSE;
$cfg['upload']['filetype']['txt'] = FALSE;
$cfg['upload']['filetype']['sxw'] = FALSE;
$cfg['upload']['filetype']['pdf'] = FALSE;
$cfg['upload']['filetype']['xml'] = FALSE;
$cfg['upload']['filetype']['html'] = FALSE;
// archives
$cfg['upload']['filetype']['zip'] = FALSE;
$cfg['upload']['filetype']['tar'] = FALSE;
$cfg['upload']['filetype']['gz'] = FALSE;
$cfg['upload']['filetype']['bz2'] = FALSE;
$cfg['upload']['filetype']['rar'] = FALSE;
?>