<?php
// +---------------------------------------------------------------------------------------+
// | TenderSystem                                                                          |
// +---------------------------------------------------------------------------------------+
// | The contents of this file are subject to the TenderSystem Public License Version 1.1  |
// | ("License"); you may not use this file except in compliance with the License. You may |
// | obtain a copy of the License at http://www.tendersystem.com/tpl/                      |
// |                                                                                       |
// | Software distributed under the License is distributed on an "AS IS" basis, WITHOUT    |
// | WARRANTY OF ANY KIND, either express or implied. See the License for the specific     |
// | language governing rights and limitations under the License.                          |
// |                                                                                       |
// | All copies of the Covered Code must include the "Powered by TenderSystem" logo and    |
// | ValueCard copyright notice on every user interface screen and in every outgoing       |
// | email in the same form as they appear in the distribution.                            |
// |                                                                                       |
// | The Original Code is: TenderSystem                                                    |
// | The Initial Developer of the Original Code is ValueCard (Pty) Limited.                |
// | Portions created by ValueCard are Copyright (C) 2002 ValueCard (Pty) Limited.         |
// | All Rights Reserved.                                                                  |
// | Contributor(s): __________________.                                                   |
// +---------------------------------------------------------------------------------------+

/**
* Display settings
* @package TenderSystem
* @subpackage settings
* @copyright Copyright &copy; 2002, ValueCard (Pty) Ltd
* @license http://www.tendersystem.com/tpl/ TenderSystem Public License
* @version 
*/

// determine if it is a administrator with level 2 permission
if ($_SESSION['ts_classification'] == "3" && $_SESSION['ts_permission'] == "2") {
	// valid upload extensions
	$extensions = array("gif","jpeg","jpg","tiff","tif","png","bmp","xls","sxc","doc","sxw","pdf","xml","html","zip","tar","gz","bz2","rar","txt");
	// set the variables
	$action = sanitise($_POST['action']);
	// login submitted
	if ($action) {
		// set the type
		$display_type = sanitise($_POST['display_type']);
		// set that no display type inserted
		if (!$display_type) {
			// unknown type selected
			$errors[] = "e1";
			// response
			xml_generator("generic","error",$errors,$params,$cfg);
		}
		// determine which type to display
		if ($display_type == "general" || $display_type == "gui") {
			// all the gui settings
			$guisettings = array(
				'theme'				=> "['theme']",
				'language'			=> "['language']",
				'version'			=> "['version']",
				'header'			=> "['header']",
				'localpostcurrency'	=> "['local']['postcurrency']",
				'localprecurrency' 	=> "['local']['precurrency']",
				'apiserver'			=> "['api']['server']",
				'apiconnection'		=> "['api']['connection']",
				'apidebug'			=> "['api']['debug']",
				'guiusername'		=> "['gui']['username']",
				'guipassword'		=> "['gui']['password']",
				'uploadactive'		=> "['upload']['active']",
				'uploadany'			=> "['upload']['any']",
				'uploadpath'		=> "['upload']['path']",
				'uploadfilesize'	=> "['upload']['filesize']",
				'uploadfiledelete'	=> "['upload']['filedelete']",
				'displaystrip'		=> "['display']['strip']",
				'displaygzip'		=> "['display']['gzip']",
				'disclaimer'		=> "['disclaimer']",
				'privacy'			=> "['privacy']",
				'help'				=> "['help']",
				'faq'				=> "['faq']",
				'menucache'			=> "['menu']['cache']",
				'menusort1'			=> "['menu']['sort']['1']",
				'menusort2'			=> "['menu']['sort']['2']",
				'menusort3'			=> "['menu']['sort']['3']",
				'menuleft'			=> "['menu']['lefthtml']",
				'timer'				=> "['timer']",
				'status'			=> "['status']",
				'xslt'				=> "['xslt']",
				'statusmessage'		=> "['statusmessage']",
				'announcement'		=> "['announcement']",
				'inputformat'		=> "['input']['format']",
				'inputtype'			=> "['input']['type']",
				'inputphonemax'		=> "['input']['phone']['max']",
				'inputphonemin'		=> "['input']['phone']['min']"
			);
			// settings that are allowed to be empty
			$gui_empty_settings = array("help","faq","disclaimer","privacy","menuleft","apiusername","apipassword");
			
			// check for gui settings
			foreach($guisettings as $key => $value){
				$post = sanitise($_POST[$key]);
				if($post || ($display_type == "gui" && in_array($key,$gui_empty_settings)) || ($display_type == "general" && (($key=="localprecurrency") || ($key=="localpostcurrency")))) {
					$newguisettings[$key] = $post;
					if ($key == "xslt") {
						// destroy the xslt session so that it can be regenerated
						$_SESSION['ts_xslt'] = "";
					}
				} 
			}
			// file types
			if($display_type == "gui") {
				foreach($extensions as $ext) {
					$guisettings['uploadfiletype'.$ext] = "['upload']['filetype']['".$ext."']";
					$post = sanitise($_POST['uploadfiletype'.$ext]);
					if($post == "on") {
						$newguisettings['uploadfiletype'.$ext] = "TRUE";
					} else {
						$newguisettings['uploadfiletype'.$ext] = "FALSE";
					}
				}
			}
			$result = write_settings("modules/settings/config.inc.php",$newguisettings,$guisettings);
			if($result) {
				$params['updated'] = "1";
				if($display_type == "general") {
					$params['newappsettings'] = $newguisettings;
				}
				// action completed
				$action = FALSE;
			} else {
				// Can't write Settings
				xml_generator("settings","error","e2",$params,$cfg);
			}
		} else {
			// determine which display types to include
			if ($display_type == "pop") {
				$appsettings[] = "popstatus";
				$appsettings[] = "popserver";
				$appsettings[] = "popport";
				$appsettings[] = "poptenderusername";
				$appsettings[] = "poptenderpassword";
				$appsettings[] = "popnotype";
			} elseif ($display_type == "security") {
				$appsettings[] = "errorfile";
				$appsettings[] = "erroremail";
				$appsettings[] = "logstatus";
				$appsettings[] = "logfile";
				$appsettings[] = "securityip_track";
				$appsettings[] = "securitycall";
				$appsettings[] = "securityip0";
				$appsettings[] = "securityip1";
				$appsettings[] = "securityip2";
				$appsettings[] = "displaylogin";
				$appsettings[] = "displaylogs";
				$appsettings[] = "displaylimit";
				$appsettings[] = "logphp";
				$appsettings[] = "apiauthenticate";
				$appsettings[] = "apiusername0";
				$appsettings[] = "apipassword0";
				$appsettings[] = "apiusername1";
				$appsettings[] = "apipassword1";
				$appsettings[] = "apiusername2";
				$appsettings[] = "apipassword2";
				$appsettings[] = "apiusername3";
				$appsettings[] = "apipassword3";
				$appsettings[] = "apiusername4";
				$appsettings[] = "apipassword4";
				// must be last
				$appsettings[] = "passwordrenewal";
			} elseif ($display_type == "sms") {
				$appsettings[] = "smsstatus";
				$appsettings[] = "smscode";
				$appsettings[] = "smsapi_id";
				$appsettings[] = "smsuser";
				$appsettings[] = "smspassword";
				$appsettings[] = "smsurlsend";
				$appsettings[] = "smsreceipt";
				// this must be last for test feature to work
				$appsettings[] = "smstest";
			} elseif ($display_type == "smtp") {
				$appsettings[] = "smtpstatus";
				$appsettings[] = "smtpserver";
				$appsettings[] = "smtpport";
				$appsettings[] = "smtpauth";
				$appsettings[] = "smtphelo";
				$appsettings[] = "smtpuser";
				$appsettings[] = "smtppassword";
				$appsettings[] = "smtpencoding";
				$appsettings[] = "smtpblob";
				$appsettings[] = "smtpfrom";
				$appsettings[] = "smtptenderemail";
				$appsettings[] = "smtpmessage";
				$appsettings[] = "smtpdisclaimer";
				$appsettings[] = "smtpsourceforge";
				$appsettings[] = "smtpsupportemail";
				$appsettings[] = "smtpbackupstatus";
				$appsettings[] = "smtpbackupemail";
				$appsettings[] = "smtpschedule";
				$appsettings[] = "smtpkeyword0";
				$appsettings[] = "smtpkeyword1";
				$appsettings[] = "smtpkeyword2";
				$appsettings[] = "smtpreceiptimgenable";
				$appsettings[] = "smtpsupportpriority";
				$appsettings[] = "smtptenderpriority";
				// this must be last for test feature to work
				$appsettings[] = "smtptest";
			} elseif ($display_type == "time") {
				$appsettings[] = "timeformat";
				$appsettings[] = "dateformat";
				$appsettings[] = "timeopen0";
				$appsettings[] = "timeclose0";
				$appsettings[] = "timeopen1";
				$appsettings[] = "timeclose1";
				$appsettings[] = "timeopen2";
				$appsettings[] = "timeclose2";
				$appsettings[] = "timeopen3";
				$appsettings[] = "timeclose3";
				$appsettings[] = "timeopen4";
				$appsettings[] = "timeclose4";
				$appsettings[] = "timeopen5";
				$appsettings[] = "timeclose5";
				$appsettings[] = "timeopen6";
				$appsettings[] = "timeclose6";
				$appsettings[] = "timelunchstarthour";
				$appsettings[] = "timelunchstartmin";
				$appsettings[] = "timelunchendhour";
				$appsettings[] = "timelunchendmin";
				$appsettings[] = "loginagent";
				$appsettings[] = "loginsubscriber";
				$appsettings[] = "loginadmin";
				$appsettings[] = "localduration";
				$appsettings[] = "localdisplay";
				$params['newappsettings']['localdisplay'] = "";
			} elseif ($display_type == "message") {
				$appsettings[] = "messageschedulestatus";
				$appsettings[] = "messagescheduleattempts";
				$appsettings[] = "messagescheduletime";
				$appsettings[] = "messageschedulego";
			}  elseif ($display_type == "holiday") {
				for($i = 0; $i < 30; $i++) {
					$appsettings[] = 'holiday'.$i.'date'; 
					$appsettings[] = 'holiday'.$i.'name';
					$params['newappsettings']['holiday'.$i.'date'] = "";
					$params['newappsettings']['holiday'.$i.'name'] = "";
				}
			}
			// all the app settings
			$appsettings[] = "theme";
			$appsettings[] = "language";
			$appsettings[] = "url";
			// loop through every submitted settings
			foreach($appsettings as $value){
				$post = sanitise($_POST[$value]);
				if($post || $post === "0") {
					$params['newappsettings'][$value] = $post; 
				} 
			}
			// action completed
			$action = FALSE;
		}
	}
	
	if(!$action) {
		// set the type
		if (!isset($display_type)) {
			// set it from the post
			$display_type = sanitise($_REQUEST['display_type']);
		}
		// set that no display type inserted
		if (!$display_type) {
			// unknown type selected
			$errors[] = "e1";
			// response
			xml_generator("settings","error",$errors,$params,$cfg);
		}
		// determine what to display
		if ($display_type == "gui") {
			// valid settings and what they look like in the config file
			$valid_settings = array(
				'version'			=> "['version']",
				'apiserver'			=> "['api']['server']",
				'apiconnection'		=> "['api']['connection']",
				'apidebug'			=> "['api']['debug']",
				'guiusername'		=> "['gui']['username']",
				'guipassword'		=> "['gui']['password']",
				'uploadactive'		=> "['upload']['active']",
				'uploadany'			=> "['upload']['any']",
				'uploadpath'		=> "['upload']['path']",
				'uploadfilesize'	=> "['upload']['filesize']",
				'uploadfiledelete'	=> "['upload']['filedelete']",
				'displaystrip'		=> "['display']['strip']",
				'displaygzip'		=> "['display']['gzip']",
				'disclaimer'		=> "['disclaimer']",
				'privacy'			=> "['privacy']",
				'help'				=> "['help']",
				'faq'				=> "['faq']",
				'menucache'			=> "['menu']['cache']",
				'menusort1'			=> "['menu']['sort']['1']",
				'menusort2'			=> "['menu']['sort']['2']",
				'menusort3'			=> "['menu']['sort']['3']",
				'menuleft'			=> "['menu']['lefthtml']",
				'timer'				=> "['timer']",
				'status'			=> "['status']",
				'xslt'				=> "['xslt']",
				'statusmessage'		=> "['statusmessage']",
				'announcement'		=> "['announcement']",
				'inputformat'		=> "['input']['format']",
				'inputtype'			=> "['input']['type']",
				'inputphonemax'		=> "['input']['phone']['max']",
				'inputphonemin'		=> "['input']['phone']['min']"
			);
			foreach($extensions as $ext) {
				$valid_settings['uploadfiletype'.$ext] = "['upload']['filetype']['".$ext."']";
			}
			// check libxslt
			if(class_exists('XSLTProcessor')) {
				$params['libxslt'] = "1";
			}
			// check 
			if(function_exists('xslt_create')) {
				$params['sablotron'] = "1";
			}
			// read settings and display
			read_settings("modules/settings/config.inc.php",$display_type,$valid_settings,$params,$errors,$cfg);
		} else {
			if($display_type == "general") {
				// get the themes
				$params['availabletheme'] = get_themes();
				// get the languages
				$params['availablelang'] = get_languages();
			}
			$params['module'] = 'settings';
			$params['function'] = 'display';
			$params['settings_type'] = $display_type;
			$params['session'] = $_SESSION['ts_id'];
			$params['ip'] = $_SERVER['REMOTE_ADDR'];
			// send message to api
			send_message($params,$cfg);
		}
	}
} else {
	// unauthorised
	$errors[] = "e15";
	// response
	xml_generator("generic","error",$errors,$params,$cfg);
}
?>