<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>

<!-- Language,theme,footer -->
<xsl:param name="language" select="/response/user/language"/>
<xsl:param name="lng" select="document(concat('../language/', $language, '/default.xml'))/l"/>
<xsl:param name="theme" select="/response/user/theme"/>
<xsl:include href="../../generic/templates/footer.xsl"/>
<xsl:include href="../../generic/templates/header.xsl"/>
<xsl:include href="../../generic/templates/languages.xsl"/>
<!-- Generic Settings Templates -->
<xsl:include href="../../settings/templates/settings_generic.xsl"/>

<!-- Template -->
<xsl:template match="/response">

<html>
	<head>
		<title><xsl:value-of select="$lng/module_name"/></title>
		<link rel="stylesheet" type="text/css" href="./theme/{$theme}/style.css"/>
	</head>
<body>
	<div id="wrapper">
		<div id="header">
			<xsl:value-of select="$lng/changegeneraltitle"/>
		</div>
		<div id="content">
			<xsl:call-template name="header">
				<xsl:with-param name="module" select="'settings'"/>
			</xsl:call-template>
			<div id="main">
				<form enctype="multipart/form-data" action="main.php" method="post" name="report">
					<input type="hidden" name="module" value="settings"/>
					<input type="hidden" name="function" value="display"/>
					<input type="hidden" name="display_type" value="general"/>
					<table border="0" align="center" cellpadding="2" cellspacing="0" width="400" bgcolor="FFFFFF">
						<tr>
							<td colspan="2" class="t1">
								<xsl:if test="updated='1'">
									<xsl:value-of select="$lng/changedsuccess"/>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td align="left" class="h t1">
								<xsl:value-of select="$lng/setting"/>
							</td>
							<td align="left" class="ha t1">
								<xsl:value-of select="$lng/value"/>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/theme"/>
							</td>
							<td align="left" class="t2">
								<select name="theme" class="t2">
									<xsl:variable name="currenttheme" select="settings/theme"/>
									<xsl:for-each select="availabletheme">
										<option>
											<xsl:if test=".=$currenttheme">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
											<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
											<xsl:value-of select="."/>
										</option>
									</xsl:for-each>
								</select>	
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/language"/>
							</td>
							<td align="left" class="t2">
								<select name="language" class="t2">
									<xsl:variable name="currentlang" select="settings/language"/>
									<xsl:for-each select="availablelang">
										<option>
											<xsl:if test=".=$currentlang">
												<xsl:attribute name="selected">selected</xsl:attribute>
											</xsl:if>
											<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
											<xsl:call-template name="language_value">
												<xsl:with-param name="iso" select="."/>
											</xsl:call-template>
										</option>
									</xsl:for-each>
								</select>
							</td>
						</tr>
						<tr>
							<td align="left" class="t1">
								<xsl:value-of select="$lng/header"/>								
							</td>
							<td align="left" class="t2">
								<input name="header" size="40" class="t2" value="{settings/header}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/localcurrencyprefix"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="localprecurrency" size="2" maxlenght="40" class="t2" value="{settings/localprecurrency}"/>
							</td>
						</tr>
						<tr> 
							<td align="left" class="t1">
								<xsl:value-of select="$lng/localcurrencypostfix"/> 
							</td>
							<td align="left" class="t2">
								<input type="text" name="localpostcurrency" size="2" maxlenght="40" class="t2" value="{settings/localpostcurrency}"/>
							</td>
						</tr>
						<xsl:call-template name="submit_button">
							<xsl:with-param name="readonly" select="readonly"/>
						</xsl:call-template>
					</table>
				</form>
			</div>
			<div id="right">
				<div id="right_header">
					<xsl:value-of select="$lng/changesettings"/>
				</div>
				<div id="right_content">
					<xsl:for-each select="$lng/generalinst">
						<xsl:value-of select="."/><br/>
					</xsl:for-each>
				</div>
			</div>
		</div>
	</div>
	<xsl:call-template name="footer"/>
</body>
</html>

</xsl:template>

</xsl:stylesheet>
